jsonconf
========

Go library to make it easy to deal with JSON configuration files.
Includes configuration validation as well as types to parse values
in a more human-friendly format so that your configuration files
are easier to manage.

### Example ###

    package main

    import "io"
    import "code.justin.tv/chat/jsonconf"

    // ./example.json
    // {
    // "name": "some_name",
    // "timeout": "10s",
    // "key": "third"
    // }

    type MyConfig struct {
        Name    string            `json:"name" validate:"nonzero"`
        Timeout jsonconf.Duration `json:"timeout" validate:"nonzero"`
        Key     string            `json:"key" validate:"regexp=^(first|second|third)$"`
    }

    func main() {
        var conf MyConfig
        err := jsonconf.ReadFile(&conf, "./example.json")
        if err != nil {
            log.Fatalln("invalid config:", e)
        }
        // do stuff with your valid configuration struct
    }

    
