package util

import "strings"

const (
	roomPrefix = "#"
)

// NameFromIrcChannel returns a room name given an IRC channel.
// Example: "#some_broadcaster" => "some_broadcaster"
func NameFromIrcChannel(ircChannel string) string {
	return strings.TrimPrefix(ircChannel, roomPrefix)
}

// IrcChannelFromName returns an an IRC channel given a room name.
// Example: "some_broadcaster" => "#some_broadcaster"
func IrcChannelFromName(name string) string {
	if strings.HasPrefix(name, roomPrefix) {
		return name
	}
	return roomPrefix + name
}
