package util

import (
	"io"
	"log"
)

type NoopWriter struct{}

func (w NoopWriter) Write(b []byte) (int, error) {
	return len(b), nil
}

type StatsdLogger struct {
	StatsWriter io.Writer
}

func (w StatsdLogger) Write(b []byte) (int, error) {
	log.Print("statsd: ", string(b))
	return w.StatsWriter.Write(b)
}
