//line sql.y:6
package pgparse

import __yyfmt__ "fmt"

//line sql.y:6
import "bytes"

func SetParseTree(yylex interface{}, stmt Statement) {
	yylex.(*Tokenizer).ParseTree = stmt
}

func SetAllowComments(yylex interface{}, allow bool) {
	yylex.(*Tokenizer).AllowComments = allow
}

func ForceEOF(yylex interface{}) {
	yylex.(*Tokenizer).ForceEOF = true
}

var (
	SHARE        = []byte("share")
	MODE         = []byte("mode")
	IF_BYTES     = []byte("if")
	VALUES_BYTES = []byte("values")
)

//line sql.y:31
type yySymType struct {
	yys         int
	empty       struct{}
	statement   Statement
	selStmt     SelectStatement
	byt         byte
	bytes       []byte
	bytes2      [][]byte
	str         string
	selectExprs SelectExprs
	selectExpr  SelectExpr
	columns     Columns
	colName     *ColName
	tableExprs  TableExprs
	tableExpr   TableExpr
	smTableExpr SimpleTableExpr
	tableName   *TableName
	indexHints  *IndexHints
	expr        Expr
	boolExpr    BoolExpr
	valExpr     ValExpr
	colTuple    ColTuple
	valExprs    ValExprs
	values      Values
	rowTuple    RowTuple
	subquery    *Subquery
	caseExpr    *CaseExpr
	whens       []*When
	when        *When
	orderBy     OrderBy
	order       *Order
	limit       *Limit
	insRows     InsertRows
	updateExprs UpdateExprs
	updateExpr  *UpdateExpr
}

const LEX_ERROR = 57346
const SELECT = 57347
const INSERT = 57348
const UPDATE = 57349
const DELETE = 57350
const FROM = 57351
const WHERE = 57352
const GROUP = 57353
const HAVING = 57354
const ORDER = 57355
const BY = 57356
const NULLS = 57357
const FIRST = 57358
const LAST = 57359
const LIMIT = 57360
const OFFSET = 57361
const FOR = 57362
const ALL = 57363
const DISTINCT = 57364
const AS = 57365
const EXISTS = 57366
const IN = 57367
const IS = 57368
const LIKE = 57369
const BETWEEN = 57370
const NULL = 57371
const ASC = 57372
const DESC = 57373
const VALUES = 57374
const INTO = 57375
const RETURNING = 57376
const DUPLICATE = 57377
const KEY = 57378
const DEFAULT = 57379
const SET = 57380
const LOCK = 57381
const FALSE_P = 57382
const TRUE_P = 57383
const KEYRANGE = 57384
const ID = 57385
const STRING = 57386
const NUMBER = 57387
const VALUE_ARG = 57388
const LIST_ARG = 57389
const COMMENT = 57390
const TIME = 57391
const ZONE = 57392
const LE = 57393
const GE = 57394
const NE = 57395
const NULL_SAFE_EQUAL = 57396
const UNION = 57397
const MINUS = 57398
const EXCEPT = 57399
const INTERSECT = 57400
const JOIN = 57401
const STRAIGHT_JOIN = 57402
const LEFT = 57403
const RIGHT = 57404
const INNER = 57405
const OUTER = 57406
const CROSS = 57407
const NATURAL = 57408
const USE = 57409
const FORCE = 57410
const ON = 57411
const OR = 57412
const AND = 57413
const NOT = 57414
const AT = 57415
const UNARY = 57416
const CASE = 57417
const WHEN = 57418
const THEN = 57419
const ELSE = 57420
const END = 57421
const CREATE = 57422
const ALTER = 57423
const DROP = 57424
const RENAME = 57425
const ANALYZE = 57426
const TABLE = 57427
const INDEX = 57428
const VIEW = 57429
const TO = 57430
const IGNORE = 57431
const IF = 57432
const UNIQUE = 57433
const USING = 57434
const SHOW = 57435
const DESCRIBE = 57436
const EXPLAIN = 57437

var yyToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"LEX_ERROR",
	"SELECT",
	"INSERT",
	"UPDATE",
	"DELETE",
	"FROM",
	"WHERE",
	"GROUP",
	"HAVING",
	"ORDER",
	"BY",
	"NULLS",
	"FIRST",
	"LAST",
	"LIMIT",
	"OFFSET",
	"FOR",
	"ALL",
	"DISTINCT",
	"AS",
	"EXISTS",
	"IN",
	"IS",
	"LIKE",
	"BETWEEN",
	"NULL",
	"ASC",
	"DESC",
	"VALUES",
	"INTO",
	"RETURNING",
	"DUPLICATE",
	"KEY",
	"DEFAULT",
	"SET",
	"LOCK",
	"FALSE_P",
	"TRUE_P",
	"KEYRANGE",
	"ID",
	"STRING",
	"NUMBER",
	"VALUE_ARG",
	"LIST_ARG",
	"COMMENT",
	"TIME",
	"ZONE",
	"LE",
	"GE",
	"NE",
	"NULL_SAFE_EQUAL",
	"'('",
	"'='",
	"'<'",
	"'>'",
	"'~'",
	"UNION",
	"MINUS",
	"EXCEPT",
	"INTERSECT",
	"','",
	"JOIN",
	"STRAIGHT_JOIN",
	"LEFT",
	"RIGHT",
	"INNER",
	"OUTER",
	"CROSS",
	"NATURAL",
	"USE",
	"FORCE",
	"ON",
	"OR",
	"AND",
	"NOT",
	"'&'",
	"'|'",
	"'^'",
	"'+'",
	"'-'",
	"'*'",
	"'/'",
	"'%'",
	"AT",
	"'.'",
	"UNARY",
	"CASE",
	"WHEN",
	"THEN",
	"ELSE",
	"END",
	"CREATE",
	"ALTER",
	"DROP",
	"RENAME",
	"ANALYZE",
	"TABLE",
	"INDEX",
	"VIEW",
	"TO",
	"IGNORE",
	"IF",
	"UNIQUE",
	"USING",
	"SHOW",
	"DESCRIBE",
	"EXPLAIN",
	"')'",
}
var yyStatenames = [...]string{}

const yyEofCode = 1
const yyErrCode = 2
const yyMaxDepth = 200

//line yacctab:1
var yyExca = [...]int{
	-1, 1,
	1, -1,
	-2, 0,
}

const yyNprod = 215
const yyPrivate = 57344

var yyTokenNames []string
var yyStates []string

const yyLast = 679

var yyAct = [...]int{

	94, 304, 162, 385, 91, 85, 347, 255, 62, 165,
	92, 381, 246, 90, 80, 201, 299, 212, 164, 3,
	63, 181, 396, 81, 138, 137, 50, 105, 360, 266,
	267, 268, 269, 270, 396, 271, 272, 189, 65, 396,
	132, 70, 64, 237, 73, 76, 53, 68, 77, 262,
	126, 302, 51, 52, 28, 29, 30, 31, 86, 235,
	132, 132, 237, 43, 358, 44, 46, 47, 48, 398,
	122, 14, 15, 16, 17, 326, 335, 247, 357, 130,
	72, 397, 356, 38, 134, 40, 395, 333, 49, 41,
	328, 69, 166, 45, 161, 163, 167, 123, 301, 277,
	125, 322, 324, 136, 18, 236, 119, 289, 287, 238,
	138, 137, 115, 153, 175, 65, 121, 71, 65, 64,
	185, 184, 64, 179, 137, 171, 337, 247, 117, 293,
	138, 137, 323, 353, 300, 86, 207, 185, 183, 300,
	258, 365, 211, 209, 210, 219, 220, 186, 226, 227,
	228, 229, 230, 231, 232, 233, 206, 199, 208, 205,
	129, 19, 20, 22, 21, 23, 355, 195, 214, 354,
	320, 239, 86, 86, 24, 25, 26, 319, 65, 65,
	318, 182, 64, 253, 241, 243, 251, 244, 257, 316,
	259, 193, 118, 314, 317, 250, 117, 196, 315, 237,
	182, 254, 145, 146, 147, 148, 149, 150, 151, 152,
	153, 150, 151, 152, 153, 131, 239, 260, 14, 276,
	280, 281, 263, 278, 148, 149, 150, 151, 152, 153,
	366, 205, 132, 340, 279, 264, 290, 14, 376, 375,
	286, 285, 374, 204, 214, 86, 28, 29, 30, 31,
	192, 194, 191, 294, 117, 203, 204, 288, 292, 59,
	298, 102, 303, 364, 110, 168, 215, 177, 203, 173,
	132, 172, 104, 103, 213, 66, 99, 100, 101, 170,
	312, 313, 221, 169, 178, 330, 234, 168, 332, 222,
	112, 108, 205, 205, 71, 66, 336, 275, 327, 86,
	225, 224, 325, 65, 334, 343, 309, 342, 344, 345,
	348, 339, 338, 135, 106, 107, 75, 274, 113, 308,
	198, 116, 111, 145, 146, 147, 148, 149, 150, 151,
	152, 153, 359, 71, 197, 349, 180, 109, 223, 329,
	361, 145, 146, 147, 148, 149, 150, 151, 152, 153,
	127, 362, 124, 120, 60, 239, 79, 371, 370, 373,
	74, 331, 372, 114, 363, 78, 393, 378, 379, 348,
	341, 296, 384, 380, 58, 386, 386, 386, 65, 387,
	388, 383, 64, 368, 369, 394, 389, 284, 242, 400,
	97, 14, 187, 128, 56, 102, 54, 401, 110, 305,
	306, 402, 216, 403, 217, 218, 104, 103, 98, 84,
	99, 100, 101, 266, 267, 268, 269, 270, 249, 271,
	272, 89, 352, 390, 391, 108, 382, 351, 307, 256,
	311, 182, 145, 146, 147, 148, 149, 150, 151, 152,
	153, 283, 102, 61, 88, 399, 377, 97, 106, 107,
	82, 14, 102, 104, 103, 110, 111, 99, 100, 101,
	33, 188, 39, 104, 103, 98, 84, 99, 100, 101,
	261, 109, 190, 42, 67, 295, 252, 240, 89, 32,
	176, 392, 108, 282, 14, 145, 146, 147, 148, 149,
	150, 151, 152, 153, 367, 34, 35, 36, 37, 346,
	350, 88, 310, 97, 291, 106, 107, 82, 102, 174,
	245, 110, 96, 111, 93, 95, 297, 248, 139, 104,
	103, 98, 66, 99, 100, 101, 87, 321, 109, 202,
	265, 200, 97, 83, 89, 273, 133, 102, 108, 55,
	110, 27, 57, 13, 12, 11, 10, 9, 104, 103,
	98, 66, 99, 100, 101, 8, 7, 88, 6, 5,
	4, 106, 107, 89, 2, 1, 0, 108, 0, 111,
	145, 146, 147, 148, 149, 150, 151, 152, 153, 0,
	0, 0, 0, 0, 109, 102, 88, 0, 110, 0,
	106, 107, 0, 0, 0, 0, 104, 103, 111, 66,
	99, 100, 101, 0, 0, 0, 0, 0, 0, 0,
	0, 168, 0, 109, 0, 108, 140, 144, 142, 143,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 106, 107,
	0, 0, 157, 158, 159, 160, 111, 154, 155, 156,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 109, 0, 0, 0, 0, 0, 0, 0, 141,
	145, 146, 147, 148, 149, 150, 151, 152, 153,
}
var yyPact = [...]int{

	66, -1000, -1000, 186, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -17,
	-39, -7, -34, -12, -1000, -1000, -1000, 446, 375, -1000,
	-1000, -1000, 372, -1000, 341, 311, 434, 252, -58, -10,
	251, -1000, -20, 251, -1000, 317, -60, 251, -60, 313,
	-1000, -1000, -1000, -1000, -1000, 423, -1000, 242, 311, 325,
	24, 311, 132, -1000, 136, -1000, 18, 310, 38, 251,
	-1000, -1000, 309, -1000, -53, 307, 369, 85, 251, -1000,
	206, -1000, -1000, 290, 15, 54, 591, -1000, 508, 479,
	-1000, -1000, -1000, 556, 228, 224, -1000, 216, 214, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 556, -1000, 229, 252, 293, 421, 252, 556, 251,
	-1000, 368, -70, -1000, 154, -1000, 291, -1000, -1000, 277,
	-1000, 200, 423, -1000, -1000, 251, 74, 508, 508, 556,
	219, 377, 556, 556, 260, 556, 556, 556, 556, 556,
	556, 556, 556, 237, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 591, -52, -6, -2, 591, -1000, 232, 366,
	423, -1000, 446, 413, -14, 491, 386, 252, 252, 190,
	-1000, 416, 508, -1000, 491, -1000, -1000, -1000, 65, 251,
	-1000, -54, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	171, 348, 274, 213, 11, -1000, -1000, -1000, -1000, -1000,
	47, 491, -1000, 232, -1000, -1000, 219, 556, 556, 491,
	406, 432, -1000, 358, -1000, -1000, 142, 142, 142, 127,
	127, 26, 26, 26, 191, -1000, -1000, 556, -1000, 491,
	-1000, -3, 423, -4, 172, 36, -1000, 508, 337, 210,
	186, 64, -13, -1000, 416, 381, 414, 54, 276, -1000,
	-1000, 263, -1000, 419, 200, 200, -1000, -1000, 128, 124,
	115, 112, 105, 28, -1000, 259, -36, 255, -21, -1000,
	491, 262, 556, 320, -1000, 556, 491, -1000, -24, -1000,
	413, -18, -1000, 556, 34, 59, 423, 169, -1000, -1000,
	335, -1000, 252, 381, -1000, 556, 556, 556, -1000, -1000,
	415, 408, 348, 58, -1000, 104, -1000, 101, -1000, -1000,
	-1000, -1000, -19, -23, -37, -1000, -1000, -1000, -1000, 556,
	491, -1000, -1000, -1000, -83, -1000, 491, 556, -1000, 168,
	210, 328, -1000, -1000, 244, 123, 166, -1000, 353, -1000,
	416, 508, 556, 508, -1000, -1000, 187, 184, 183, 491,
	-1000, 491, -1000, 439, 556, 556, 556, -1000, 411, 411,
	381, 54, 135, 54, 251, 251, 251, 252, 491, 491,
	-1000, -1000, 407, -1000, 346, -25, -1000, -30, -42, 132,
	-1000, -1000, -1000, 438, 364, -1000, 251, -1000, -1000, -1000,
	251, -1000, 251, -1000,
}
var yyPgo = [...]int{

	0, 565, 564, 18, 560, 559, 558, 556, 555, 547,
	546, 545, 544, 543, 479, 542, 541, 539, 14, 23,
	536, 535, 533, 531, 15, 530, 529, 259, 527, 3,
	21, 5, 526, 518, 517, 13, 2, 17, 9, 516,
	10, 515, 27, 514, 4, 512, 510, 12, 509, 504,
	502, 500, 7, 499, 6, 494, 1, 481, 480, 476,
	475, 16, 8, 20, 316, 474, 473, 472, 470, 462,
	461, 0, 26, 460, 11,
}
var yyR1 = [...]int{

	0, 1, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 3, 3, 4, 4, 5, 6, 7,
	8, 8, 8, 9, 9, 9, 10, 11, 11, 11,
	12, 13, 13, 13, 73, 14, 15, 15, 16, 16,
	16, 16, 16, 17, 17, 18, 18, 19, 19, 19,
	22, 22, 20, 20, 20, 23, 23, 24, 24, 24,
	24, 21, 21, 21, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 26, 26, 26, 27, 27, 28, 28,
	28, 28, 29, 29, 30, 30, 31, 31, 31, 31,
	31, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 33, 33, 33, 33, 33,
	33, 33, 37, 37, 37, 42, 38, 38, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 41, 41, 43, 43,
	43, 45, 48, 48, 46, 46, 47, 49, 49, 44,
	44, 35, 35, 35, 35, 35, 35, 50, 50, 51,
	51, 52, 52, 53, 53, 54, 55, 55, 55, 74,
	74, 74, 56, 56, 56, 56, 57, 57, 57, 58,
	58, 59, 59, 60, 60, 61, 61, 34, 34, 39,
	39, 40, 40, 62, 62, 63, 64, 64, 65, 65,
	66, 66, 67, 67, 67, 67, 67, 68, 68, 69,
	69, 70, 70, 71, 72,
}
var yyR2 = [...]int{

	0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 12, 3, 8, 7, 8, 7, 3,
	5, 8, 4, 6, 7, 4, 5, 4, 5, 5,
	3, 2, 2, 2, 0, 2, 0, 2, 1, 2,
	1, 1, 1, 0, 1, 1, 3, 1, 2, 3,
	1, 1, 0, 1, 2, 1, 3, 3, 3, 3,
	5, 0, 1, 2, 1, 1, 2, 3, 2, 3,
	2, 2, 2, 1, 3, 1, 1, 3, 0, 5,
	5, 5, 1, 3, 0, 2, 1, 3, 3, 2,
	3, 3, 3, 4, 3, 4, 5, 6, 5, 3,
	4, 3, 3, 2, 6, 1, 1, 1, 1, 1,
	1, 1, 3, 1, 1, 3, 1, 3, 1, 1,
	1, 3, 3, 3, 3, 3, 3, 3, 3, 5,
	2, 3, 4, 5, 4, 1, 1, 1, 1, 1,
	1, 5, 0, 1, 1, 2, 4, 0, 2, 1,
	3, 1, 1, 1, 1, 1, 1, 0, 3, 0,
	2, 0, 3, 1, 3, 2, 0, 2, 2, 0,
	2, 2, 0, 4, 4, 2, 0, 2, 4, 0,
	3, 1, 3, 0, 2, 0, 5, 2, 1, 1,
	3, 3, 1, 1, 3, 3, 0, 2, 0, 3,
	0, 1, 1, 1, 1, 1, 1, 0, 1, 0,
	1, 0, 2, 1, 0,
}
var yyChk = [...]int{

	-1000, -1, -2, -3, -4, -5, -6, -7, -8, -9,
	-10, -11, -12, -13, 5, 6, 7, 8, 38, 95,
	96, 98, 97, 99, 108, 109, 110, -16, 60, 61,
	62, 63, -14, -73, -14, -14, -14, -14, 100, -69,
	102, 106, -66, 102, 104, 100, 100, 101, 102, 100,
	-72, -72, -72, -3, 21, -17, 22, -15, 33, -27,
	43, 9, -62, -63, -44, -71, 43, -65, 105, 101,
	-71, 43, 100, -71, 43, -64, 105, -71, -64, 43,
	-18, -19, 84, -22, 43, -31, -36, -32, 78, 55,
	-35, -44, -40, -43, -71, -41, -45, 24, 42, 44,
	45, 46, 29, 41, 40, -42, 82, 83, 59, 105,
	32, 90, 48, -27, 38, 88, -27, 64, 56, 88,
	43, 78, -71, -72, 43, -72, 103, 43, 24, 75,
	-71, 9, 64, -20, -71, 23, 88, 77, 76, -33,
	25, 78, 27, 28, 26, 79, 80, 81, 82, 83,
	84, 85, 86, 87, 56, 57, 58, 51, 52, 53,
	54, -31, -36, -31, -3, -38, -36, -36, 55, 55,
	55, -42, 55, 55, -48, -36, -58, 38, 55, -62,
	43, -30, 10, -63, -36, -71, -72, 24, -70, 107,
	-67, 98, 96, 37, 97, 13, 43, 43, 43, -72,
	-23, -24, -26, 55, 43, -42, -19, -71, 84, -31,
	-31, -36, -37, 55, -42, 47, 25, 27, 28, -36,
	-36, 22, 29, 78, 41, 40, -36, -36, -36, -36,
	-36, -36, -36, -36, 49, 111, 111, 64, 111, -36,
	111, -18, 22, -18, -35, -46, -47, 91, -34, 32,
	-3, -62, -59, -44, -30, -52, 13, -31, 75, -71,
	-72, -68, 103, -30, 64, -25, 65, 66, 67, 68,
	69, 71, 72, -21, 43, 23, -24, 88, -38, -37,
	-36, -36, 77, 9, 29, 50, -36, 111, -18, 111,
	64, -49, -47, 93, -31, -60, 34, -39, -40, -61,
	75, 111, 64, -52, -56, 18, 19, 14, 43, 43,
	-50, 11, -24, -24, 65, 70, 65, 70, 65, 65,
	65, -28, 73, 104, 74, 43, 111, 43, 111, 77,
	-36, 41, -36, 111, -35, 94, -36, 92, -61, -18,
	64, 35, -44, -56, -36, -36, -53, -54, -36, -72,
	-51, 12, 14, 75, 65, 65, 101, 101, 101, -36,
	111, -36, -40, 36, 19, 18, 64, -55, 30, 31,
	-52, -31, -38, -31, 55, 55, 55, 7, -36, -36,
	-54, -74, 15, -74, -56, -29, -71, -29, -29, -62,
	16, 17, -57, 20, 39, 111, 64, 111, 111, 7,
	25, -71, -71, -71,
}
var yyDef = [...]int{

	0, -2, 1, 2, 3, 4, 5, 6, 7, 8,
	9, 10, 11, 12, 34, 34, 34, 34, 34, 209,
	200, 0, 0, 0, 214, 214, 214, 0, 38, 40,
	41, 42, 43, 36, 0, 0, 0, 0, 198, 0,
	0, 210, 0, 0, 201, 0, 196, 0, 196, 0,
	31, 32, 33, 14, 39, 0, 44, 35, 0, 0,
	76, 0, 19, 193, 0, 149, 213, 0, 0, 0,
	214, 213, 0, 214, 0, 0, 0, 0, 0, 30,
	0, 45, 47, 52, 213, 50, 51, 86, 0, 0,
	118, 119, 120, 0, 149, 0, 135, 0, 0, 151,
	152, 153, 154, 155, 156, 192, 138, 139, 140, 136,
	137, 142, 37, 179, 0, 0, 84, 0, 0, 0,
	214, 0, 211, 22, 0, 25, 0, 27, 197, 0,
	214, 0, 0, 48, 53, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 105, 106, 107, 108, 109, 110,
	111, 89, 0, 0, 0, 0, 116, 130, 0, 0,
	0, 103, 0, 0, 0, 143, 0, 0, 0, 84,
	77, 161, 0, 194, 195, 150, 20, 199, 0, 0,
	214, 207, 202, 203, 204, 205, 206, 26, 28, 29,
	84, 55, 61, 0, 73, 75, 46, 54, 49, 87,
	88, 91, 92, 0, 113, 114, 0, 0, 0, 94,
	0, 0, 99, 0, 101, 102, 121, 122, 123, 124,
	125, 126, 127, 128, 0, 90, 115, 0, 191, 116,
	131, 0, 0, 0, 0, 147, 144, 0, 183, 0,
	188, 185, 0, 181, 161, 172, 0, 85, 0, 212,
	23, 0, 208, 157, 0, 0, 64, 65, 0, 0,
	0, 0, 0, 78, 62, 0, 0, 0, 0, 93,
	95, 0, 0, 0, 100, 0, 117, 132, 0, 134,
	0, 0, 145, 0, 0, 185, 0, 187, 189, 16,
	0, 180, 0, 172, 18, 0, 0, 0, 214, 24,
	159, 0, 56, 59, 66, 0, 68, 0, 70, 71,
	72, 57, 0, 0, 0, 63, 58, 74, 112, 0,
	96, 98, 129, 133, 0, 141, 148, 0, 15, 184,
	0, 0, 182, 17, 175, 0, 162, 163, 166, 21,
	161, 0, 0, 0, 67, 69, 0, 0, 0, 97,
	104, 146, 190, 0, 0, 0, 0, 165, 169, 169,
	172, 160, 158, 60, 0, 0, 0, 0, 173, 174,
	164, 167, 0, 168, 176, 0, 82, 0, 0, 186,
	170, 171, 13, 0, 0, 79, 0, 80, 81, 177,
	0, 83, 0, 178,
}
var yyTok1 = [...]int{

	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 86, 79, 3,
	55, 111, 84, 82, 64, 83, 88, 85, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	57, 56, 58, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 81, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 80, 3, 59,
}
var yyTok2 = [...]int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 60, 61, 62, 63, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
	78, 87, 89, 90, 91, 92, 93, 94, 95, 96,
	97, 98, 99, 100, 101, 102, 103, 104, 105, 106,
	107, 108, 109, 110,
}
var yyTok3 = [...]int{
	0,
}

var yyErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	yyDebug        = 0
	yyErrorVerbose = false
)

type yyLexer interface {
	Lex(lval *yySymType) int
	Error(s string)
}

type yyParser interface {
	Parse(yyLexer) int
	Lookahead() int
}

type yyParserImpl struct {
	lookahead func() int
}

func (p *yyParserImpl) Lookahead() int {
	return p.lookahead()
}

func yyNewParser() yyParser {
	p := &yyParserImpl{
		lookahead: func() int { return -1 },
	}
	return p
}

const yyFlag = -1000

func yyTokname(c int) string {
	if c >= 1 && c-1 < len(yyToknames) {
		if yyToknames[c-1] != "" {
			return yyToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func yyStatname(s int) string {
	if s >= 0 && s < len(yyStatenames) {
		if yyStatenames[s] != "" {
			return yyStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func yyErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !yyErrorVerbose {
		return "syntax error"
	}

	for _, e := range yyErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + yyTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := yyPact[state]
	for tok := TOKSTART; tok-1 < len(yyToknames); tok++ {
		if n := base + tok; n >= 0 && n < yyLast && yyChk[yyAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if yyDef[state] == -2 {
		i := 0
		for yyExca[i] != -1 || yyExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; yyExca[i] >= 0; i += 2 {
			tok := yyExca[i]
			if tok < TOKSTART || yyExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if yyExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += yyTokname(tok)
	}
	return res
}

func yylex1(lex yyLexer, lval *yySymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = yyTok1[0]
		goto out
	}
	if char < len(yyTok1) {
		token = yyTok1[char]
		goto out
	}
	if char >= yyPrivate {
		if char < yyPrivate+len(yyTok2) {
			token = yyTok2[char-yyPrivate]
			goto out
		}
	}
	for i := 0; i < len(yyTok3); i += 2 {
		token = yyTok3[i+0]
		if token == char {
			token = yyTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = yyTok2[1] /* unknown char */
	}
	if yyDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", yyTokname(token), uint(char))
	}
	return char, token
}

func yyParse(yylex yyLexer) int {
	return yyNewParser().Parse(yylex)
}

func (yyrcvr *yyParserImpl) Parse(yylex yyLexer) int {
	var yyn int
	var yylval yySymType
	var yyVAL yySymType
	var yyDollar []yySymType
	_ = yyDollar // silence set and not used
	yyS := make([]yySymType, yyMaxDepth)

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	yystate := 0
	yychar := -1
	yytoken := -1 // yychar translated into internal numbering
	yyrcvr.lookahead = func() int { return yychar }
	defer func() {
		// Make sure we report no lookahead when not parsing.
		yystate = -1
		yychar = -1
		yytoken = -1
	}()
	yyp := -1
	goto yystack

ret0:
	return 0

ret1:
	return 1

yystack:
	/* put a state and value onto the stack */
	if yyDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", yyTokname(yytoken), yyStatname(yystate))
	}

	yyp++
	if yyp >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyS[yyp] = yyVAL
	yyS[yyp].yys = yystate

yynewstate:
	yyn = yyPact[yystate]
	if yyn <= yyFlag {
		goto yydefault /* simple state */
	}
	if yychar < 0 {
		yychar, yytoken = yylex1(yylex, &yylval)
	}
	yyn += yytoken
	if yyn < 0 || yyn >= yyLast {
		goto yydefault
	}
	yyn = yyAct[yyn]
	if yyChk[yyn] == yytoken { /* valid shift */
		yychar = -1
		yytoken = -1
		yyVAL = yylval
		yystate = yyn
		if Errflag > 0 {
			Errflag--
		}
		goto yystack
	}

yydefault:
	/* default state action */
	yyn = yyDef[yystate]
	if yyn == -2 {
		if yychar < 0 {
			yychar, yytoken = yylex1(yylex, &yylval)
		}

		/* look through exception table */
		xi := 0
		for {
			if yyExca[xi+0] == -1 && yyExca[xi+1] == yystate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			yyn = yyExca[xi+0]
			if yyn < 0 || yyn == yytoken {
				break
			}
		}
		yyn = yyExca[xi+1]
		if yyn < 0 {
			goto ret0
		}
	}
	if yyn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			yylex.Error(yyErrorMessage(yystate, yytoken))
			Nerrs++
			if yyDebug >= 1 {
				__yyfmt__.Printf("%s", yyStatname(yystate))
				__yyfmt__.Printf(" saw %s\n", yyTokname(yytoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for yyp >= 0 {
				yyn = yyPact[yyS[yyp].yys] + yyErrCode
				if yyn >= 0 && yyn < yyLast {
					yystate = yyAct[yyn] /* simulate a shift of "error" */
					if yyChk[yystate] == yyErrCode {
						goto yystack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if yyDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", yyS[yyp].yys)
				}
				yyp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if yyDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", yyTokname(yytoken))
			}
			if yytoken == yyEofCode {
				goto ret1
			}
			yychar = -1
			yytoken = -1
			goto yynewstate /* try again in the same state */
		}
	}

	/* reduction by production yyn */
	if yyDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", yyn, yyStatname(yystate))
	}

	yynt := yyn
	yypt := yyp
	_ = yypt // guard against "declared and not used"

	yyp -= yyR2[yyn]
	// yyp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if yyp+1 >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyVAL = yyS[yyp+1]

	/* consult goto table to find next state */
	yyn = yyR1[yyn]
	yyg := yyPgo[yyn]
	yyj := yyg + yyS[yyp].yys + 1

	if yyj >= yyLast {
		yystate = yyAct[yyg]
	} else {
		yystate = yyAct[yyj]
		if yyChk[yystate] != -yyn {
			yystate = yyAct[yyg]
		}
	}
	// dummy call; replaced with literal code
	switch yynt {

	case 1:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:153
		{
			SetParseTree(yylex, yyDollar[1].statement)
		}
	case 2:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:159
		{
			yyVAL.statement = yyDollar[1].selStmt
		}
	case 13:
		yyDollar = yyS[yypt-12 : yypt+1]
		//line sql.y:175
		{
			yyVAL.selStmt = &Select{Comments: Comments(yyDollar[2].bytes2), Distinct: yyDollar[3].str, SelectExprs: yyDollar[4].selectExprs, From: yyDollar[6].tableExprs, Where: NewWhere(AST_WHERE, yyDollar[7].boolExpr), GroupBy: GroupBy(yyDollar[8].valExprs), Having: NewWhere(AST_HAVING, yyDollar[9].boolExpr), OrderBy: yyDollar[10].orderBy, Limit: yyDollar[11].limit, Lock: yyDollar[12].str}
		}
	case 14:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:179
		{
			yyVAL.selStmt = &Union{Type: yyDollar[2].str, Left: yyDollar[1].selStmt, Right: yyDollar[3].selStmt}
		}
	case 15:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:185
		{
			// TODO(rhys): include returning_opt
			yyVAL.statement = &Insert{Comments: Comments(yyDollar[2].bytes2), Table: yyDollar[4].tableName, Columns: yyDollar[5].columns, Rows: yyDollar[6].insRows, OnDup: OnDup(yyDollar[8].updateExprs)}
		}
	case 16:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:190
		{
			cols := make(Columns, 0, len(yyDollar[6].updateExprs))
			vals := make(ValTuple, 0, len(yyDollar[6].updateExprs))
			for _, col := range yyDollar[6].updateExprs {
				cols = append(cols, &NonStarExpr{Expr: col.Name})
				vals = append(vals, col.Expr)
			}
			yyVAL.statement = &Insert{Comments: Comments(yyDollar[2].bytes2), Table: yyDollar[4].tableName, Columns: cols, Rows: Values{vals}, OnDup: OnDup(yyDollar[7].updateExprs)}
		}
	case 17:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:202
		{
			yyVAL.statement = &Update{Comments: Comments(yyDollar[2].bytes2), Table: yyDollar[3].tableName, Exprs: yyDollar[5].updateExprs, Where: NewWhere(AST_WHERE, yyDollar[6].boolExpr), OrderBy: yyDollar[7].orderBy, Limit: yyDollar[8].limit}
		}
	case 18:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:208
		{
			yyVAL.statement = &Delete{Comments: Comments(yyDollar[2].bytes2), Table: yyDollar[4].tableName, Where: NewWhere(AST_WHERE, yyDollar[5].boolExpr), OrderBy: yyDollar[6].orderBy, Limit: yyDollar[7].limit}
		}
	case 19:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:214
		{
			yyVAL.statement = &Set{Comments: Comments(yyDollar[2].bytes2), Exprs: yyDollar[3].updateExprs}
		}
	case 20:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:220
		{
			yyVAL.statement = &DDL{Action: AST_CREATE, NewName: yyDollar[4].bytes}
		}
	case 21:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:224
		{
			// Change this to an alter statement
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyDollar[7].bytes, NewName: yyDollar[7].bytes}
		}
	case 22:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:229
		{
			yyVAL.statement = &DDL{Action: AST_CREATE, NewName: yyDollar[3].bytes}
		}
	case 23:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:235
		{
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyDollar[4].bytes, NewName: yyDollar[4].bytes}
		}
	case 24:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:239
		{
			// Change this to a rename statement
			yyVAL.statement = &DDL{Action: AST_RENAME, Table: yyDollar[4].bytes, NewName: yyDollar[7].bytes}
		}
	case 25:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:244
		{
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyDollar[3].bytes, NewName: yyDollar[3].bytes}
		}
	case 26:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:250
		{
			yyVAL.statement = &DDL{Action: AST_RENAME, Table: yyDollar[3].bytes, NewName: yyDollar[5].bytes}
		}
	case 27:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:256
		{
			yyVAL.statement = &DDL{Action: AST_DROP, Table: yyDollar[4].bytes}
		}
	case 28:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:260
		{
			// Change this to an alter statement
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyDollar[5].bytes, NewName: yyDollar[5].bytes}
		}
	case 29:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:265
		{
			yyVAL.statement = &DDL{Action: AST_DROP, Table: yyDollar[4].bytes}
		}
	case 30:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:271
		{
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyDollar[3].bytes, NewName: yyDollar[3].bytes}
		}
	case 31:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:277
		{
			yyVAL.statement = &Other{}
		}
	case 32:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:281
		{
			yyVAL.statement = &Other{}
		}
	case 33:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:285
		{
			yyVAL.statement = &Other{}
		}
	case 34:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:290
		{
			SetAllowComments(yylex, true)
		}
	case 35:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:294
		{
			yyVAL.bytes2 = yyDollar[2].bytes2
			SetAllowComments(yylex, false)
		}
	case 36:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:300
		{
			yyVAL.bytes2 = nil
		}
	case 37:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:304
		{
			yyVAL.bytes2 = append(yyDollar[1].bytes2, yyDollar[2].bytes)
		}
	case 38:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:310
		{
			yyVAL.str = AST_UNION
		}
	case 39:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:314
		{
			yyVAL.str = AST_UNION_ALL
		}
	case 40:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:318
		{
			yyVAL.str = AST_SET_MINUS
		}
	case 41:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:322
		{
			yyVAL.str = AST_EXCEPT
		}
	case 42:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:326
		{
			yyVAL.str = AST_INTERSECT
		}
	case 43:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:331
		{
			yyVAL.str = ""
		}
	case 44:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:335
		{
			yyVAL.str = AST_DISTINCT
		}
	case 45:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:341
		{
			yyVAL.selectExprs = SelectExprs{yyDollar[1].selectExpr}
		}
	case 46:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:345
		{
			yyVAL.selectExprs = append(yyVAL.selectExprs, yyDollar[3].selectExpr)
		}
	case 47:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:351
		{
			yyVAL.selectExpr = &StarExpr{}
		}
	case 48:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:355
		{
			yyVAL.selectExpr = &NonStarExpr{Expr: yyDollar[1].expr, As: yyDollar[2].bytes}
		}
	case 49:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:359
		{
			yyVAL.selectExpr = &StarExpr{TableName: yyDollar[1].bytes}
		}
	case 50:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:365
		{
			yyVAL.expr = yyDollar[1].boolExpr
		}
	case 51:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:369
		{
			yyVAL.expr = yyDollar[1].valExpr
		}
	case 52:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:374
		{
			yyVAL.bytes = nil
		}
	case 53:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:378
		{
			yyVAL.bytes = yyDollar[1].bytes
		}
	case 54:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:382
		{
			yyVAL.bytes = yyDollar[2].bytes
		}
	case 55:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:388
		{
			yyVAL.tableExprs = TableExprs{yyDollar[1].tableExpr}
		}
	case 56:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:392
		{
			yyVAL.tableExprs = append(yyVAL.tableExprs, yyDollar[3].tableExpr)
		}
	case 57:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:398
		{
			yyVAL.tableExpr = &AliasedTableExpr{Expr: yyDollar[1].smTableExpr, As: yyDollar[2].bytes, Hints: yyDollar[3].indexHints}
		}
	case 58:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:402
		{
			yyVAL.tableExpr = &ParenTableExpr{Expr: yyDollar[2].tableExpr}
		}
	case 59:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:406
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr}
		}
	case 60:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:410
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr, On: yyDollar[5].boolExpr}
		}
	case 61:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:415
		{
			yyVAL.bytes = nil
		}
	case 62:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:419
		{
			yyVAL.bytes = yyDollar[1].bytes
		}
	case 63:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:423
		{
			yyVAL.bytes = yyDollar[2].bytes
		}
	case 64:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:429
		{
			yyVAL.str = AST_JOIN
		}
	case 65:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:433
		{
			yyVAL.str = AST_STRAIGHT_JOIN
		}
	case 66:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:437
		{
			yyVAL.str = AST_LEFT_JOIN
		}
	case 67:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:441
		{
			yyVAL.str = AST_LEFT_JOIN
		}
	case 68:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:445
		{
			yyVAL.str = AST_RIGHT_JOIN
		}
	case 69:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:449
		{
			yyVAL.str = AST_RIGHT_JOIN
		}
	case 70:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:453
		{
			yyVAL.str = AST_JOIN
		}
	case 71:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:457
		{
			yyVAL.str = AST_CROSS_JOIN
		}
	case 72:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:461
		{
			yyVAL.str = AST_NATURAL_JOIN
		}
	case 73:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:467
		{
			yyVAL.smTableExpr = &TableName{Name: yyDollar[1].bytes}
		}
	case 74:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:471
		{
			yyVAL.smTableExpr = &TableName{Qualifier: yyDollar[1].bytes, Name: yyDollar[3].bytes}
		}
	case 75:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:475
		{
			yyVAL.smTableExpr = yyDollar[1].subquery
		}
	case 76:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:481
		{
			yyVAL.tableName = &TableName{Name: yyDollar[1].bytes}
		}
	case 77:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:485
		{
			yyVAL.tableName = &TableName{Qualifier: yyDollar[1].bytes, Name: yyDollar[3].bytes}
		}
	case 78:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:490
		{
			yyVAL.indexHints = nil
		}
	case 79:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:494
		{
			yyVAL.indexHints = &IndexHints{Type: AST_USE, Indexes: yyDollar[4].bytes2}
		}
	case 80:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:498
		{
			yyVAL.indexHints = &IndexHints{Type: AST_IGNORE, Indexes: yyDollar[4].bytes2}
		}
	case 81:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:502
		{
			yyVAL.indexHints = &IndexHints{Type: AST_FORCE, Indexes: yyDollar[4].bytes2}
		}
	case 82:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:508
		{
			yyVAL.bytes2 = [][]byte{yyDollar[1].bytes}
		}
	case 83:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:512
		{
			yyVAL.bytes2 = append(yyDollar[1].bytes2, yyDollar[3].bytes)
		}
	case 84:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:517
		{
			yyVAL.boolExpr = nil
		}
	case 85:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:521
		{
			yyVAL.boolExpr = yyDollar[2].boolExpr
		}
	case 87:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:528
		{
			yyVAL.boolExpr = &AndExpr{Left: yyDollar[1].boolExpr, Right: yyDollar[3].boolExpr}
		}
	case 88:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:532
		{
			yyVAL.boolExpr = &OrExpr{Left: yyDollar[1].boolExpr, Right: yyDollar[3].boolExpr}
		}
	case 89:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:536
		{
			yyVAL.boolExpr = &NotExpr{Expr: yyDollar[2].boolExpr}
		}
	case 90:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:540
		{
			yyVAL.boolExpr = &ParenBoolExpr{Expr: yyDollar[2].boolExpr}
		}
	case 91:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:546
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyDollar[1].valExpr, Operator: yyDollar[2].str, Right: yyDollar[3].valExpr}
		}
	case 92:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:550
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyDollar[1].valExpr, Operator: AST_IN, Right: yyDollar[3].colTuple}
		}
	case 93:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:554
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyDollar[1].valExpr, Operator: AST_NOT_IN, Right: yyDollar[4].colTuple}
		}
	case 94:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:558
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyDollar[1].valExpr, Operator: AST_LIKE, Right: yyDollar[3].valExpr}
		}
	case 95:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:562
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyDollar[1].valExpr, Operator: AST_NOT_LIKE, Right: yyDollar[4].valExpr}
		}
	case 96:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:566
		{
			yyVAL.boolExpr = &RangeCond{Left: yyDollar[1].valExpr, Operator: AST_BETWEEN, From: yyDollar[3].valExpr, To: yyDollar[5].valExpr}
		}
	case 97:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:570
		{
			yyVAL.boolExpr = &RangeCond{Left: yyDollar[1].valExpr, Operator: AST_NOT_BETWEEN, From: yyDollar[4].valExpr, To: yyDollar[6].valExpr}
		}
	case 98:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:574
		{
			// TODO(rhys): custom type
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NULL, Expr: yyDollar[1].valExpr}
		}
	case 99:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:579
		{
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NULL, Expr: yyDollar[1].valExpr}
		}
	case 100:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:583
		{
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NOT_NULL, Expr: yyDollar[1].valExpr}
		}
	case 101:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:587
		{
			// TODO(rhys): custom type
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NULL, Expr: yyDollar[1].valExpr}
		}
	case 102:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:592
		{
			// TODO(rhys): custom type
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NULL, Expr: yyDollar[1].valExpr}
		}
	case 103:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:597
		{
			yyVAL.boolExpr = &ExistsExpr{Subquery: yyDollar[2].subquery}
		}
	case 104:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:601
		{
			yyVAL.boolExpr = &KeyrangeExpr{Start: yyDollar[3].valExpr, End: yyDollar[5].valExpr}
		}
	case 105:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:607
		{
			yyVAL.str = AST_EQ
		}
	case 106:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:611
		{
			yyVAL.str = AST_LT
		}
	case 107:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:615
		{
			yyVAL.str = AST_GT
		}
	case 108:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:619
		{
			yyVAL.str = AST_LE
		}
	case 109:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:623
		{
			yyVAL.str = AST_GE
		}
	case 110:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:627
		{
			yyVAL.str = AST_NE
		}
	case 111:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:631
		{
			yyVAL.str = AST_NSE
		}
	case 112:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:637
		{
			yyVAL.colTuple = ValTuple(yyDollar[2].valExprs)
		}
	case 113:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:641
		{
			yyVAL.colTuple = yyDollar[1].subquery
		}
	case 114:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:645
		{
			yyVAL.colTuple = ListArg(yyDollar[1].bytes)
		}
	case 115:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:651
		{
			yyVAL.subquery = &Subquery{yyDollar[2].selStmt}
		}
	case 116:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:657
		{
			yyVAL.valExprs = ValExprs{yyDollar[1].valExpr}
		}
	case 117:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:661
		{
			yyVAL.valExprs = append(yyDollar[1].valExprs, yyDollar[3].valExpr)
		}
	case 118:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:667
		{
			yyVAL.valExpr = yyDollar[1].valExpr
		}
	case 119:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:671
		{
			yyVAL.valExpr = yyDollar[1].colName
		}
	case 120:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:675
		{
			yyVAL.valExpr = yyDollar[1].rowTuple
		}
	case 121:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:679
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_BITAND, Right: yyDollar[3].valExpr}
		}
	case 122:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:683
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_BITOR, Right: yyDollar[3].valExpr}
		}
	case 123:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:687
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_BITXOR, Right: yyDollar[3].valExpr}
		}
	case 124:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:691
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_PLUS, Right: yyDollar[3].valExpr}
		}
	case 125:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:695
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_MINUS, Right: yyDollar[3].valExpr}
		}
	case 126:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:699
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_MULT, Right: yyDollar[3].valExpr}
		}
	case 127:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:703
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_DIV, Right: yyDollar[3].valExpr}
		}
	case 128:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:707
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_MOD, Right: yyDollar[3].valExpr}
		}
	case 129:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:711
		{
			// TODO(rhys): custom type
			yyVAL.valExpr = &BinaryExpr{Left: yyDollar[1].valExpr, Operator: AST_MOD, Right: yyDollar[5].valExpr}
		}
	case 130:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:716
		{
			if num, ok := yyDollar[2].valExpr.(NumVal); ok {
				switch yyDollar[1].byt {
				case '-':
					yyVAL.valExpr = append(NumVal("-"), num...)
				case '+':
					yyVAL.valExpr = num
				default:
					yyVAL.valExpr = &UnaryExpr{Operator: yyDollar[1].byt, Expr: yyDollar[2].valExpr}
				}
			} else {
				yyVAL.valExpr = &UnaryExpr{Operator: yyDollar[1].byt, Expr: yyDollar[2].valExpr}
			}
		}
	case 131:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:731
		{
			yyVAL.valExpr = &FuncExpr{Name: yyDollar[1].bytes}
		}
	case 132:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:735
		{
			yyVAL.valExpr = &FuncExpr{Name: yyDollar[1].bytes, Exprs: yyDollar[3].selectExprs}
		}
	case 133:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:739
		{
			yyVAL.valExpr = &FuncExpr{Name: yyDollar[1].bytes, Distinct: true, Exprs: yyDollar[4].selectExprs}
		}
	case 134:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:743
		{
			yyVAL.valExpr = &FuncExpr{Name: yyDollar[1].bytes, Exprs: yyDollar[3].selectExprs}
		}
	case 135:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:747
		{
			yyVAL.valExpr = yyDollar[1].caseExpr
		}
	case 136:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:753
		{
			yyVAL.bytes = IF_BYTES
		}
	case 137:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:757
		{
			yyVAL.bytes = VALUES_BYTES
		}
	case 138:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:763
		{
			yyVAL.byt = AST_UPLUS
		}
	case 139:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:767
		{
			yyVAL.byt = AST_UMINUS
		}
	case 140:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:771
		{
			yyVAL.byt = AST_TILDA
		}
	case 141:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:777
		{
			yyVAL.caseExpr = &CaseExpr{Expr: yyDollar[2].valExpr, Whens: yyDollar[3].whens, Else: yyDollar[4].valExpr}
		}
	case 142:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:782
		{
			yyVAL.valExpr = nil
		}
	case 143:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:786
		{
			yyVAL.valExpr = yyDollar[1].valExpr
		}
	case 144:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:792
		{
			yyVAL.whens = []*When{yyDollar[1].when}
		}
	case 145:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:796
		{
			yyVAL.whens = append(yyDollar[1].whens, yyDollar[2].when)
		}
	case 146:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:802
		{
			yyVAL.when = &When{Cond: yyDollar[2].boolExpr, Val: yyDollar[4].valExpr}
		}
	case 147:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:807
		{
			yyVAL.valExpr = nil
		}
	case 148:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:811
		{
			yyVAL.valExpr = yyDollar[2].valExpr
		}
	case 149:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:817
		{
			yyVAL.colName = &ColName{Name: yyDollar[1].bytes}
		}
	case 150:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:821
		{
			yyVAL.colName = &ColName{Qualifier: yyDollar[1].bytes, Name: yyDollar[3].bytes}
		}
	case 151:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:827
		{
			yyVAL.valExpr = StrVal(yyDollar[1].bytes)
		}
	case 152:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:831
		{
			yyVAL.valExpr = NumVal(yyDollar[1].bytes)
		}
	case 153:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:835
		{
			yyVAL.valExpr = ValArg(yyDollar[1].bytes)
		}
	case 154:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:839
		{
			yyVAL.valExpr = &NullVal{}
		}
	case 155:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:843
		{
			// TODO(rhys): custom type
			yyVAL.valExpr = &NullVal{}
		}
	case 156:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:848
		{
			// TODO(rhys): custom type
			yyVAL.valExpr = &NullVal{}
		}
	case 157:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:854
		{
			yyVAL.valExprs = nil
		}
	case 158:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:858
		{
			yyVAL.valExprs = yyDollar[3].valExprs
		}
	case 159:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:863
		{
			yyVAL.boolExpr = nil
		}
	case 160:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:867
		{
			yyVAL.boolExpr = yyDollar[2].boolExpr
		}
	case 161:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:872
		{
			yyVAL.orderBy = nil
		}
	case 162:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:876
		{
			yyVAL.orderBy = yyDollar[3].orderBy
		}
	case 163:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:882
		{
			yyVAL.orderBy = OrderBy{yyDollar[1].order}
		}
	case 164:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:886
		{
			yyVAL.orderBy = append(yyDollar[1].orderBy, yyDollar[3].order)
		}
	case 165:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:892
		{
			yyVAL.order = &Order{Expr: yyDollar[1].valExpr, Direction: yyDollar[2].str}
		}
	case 166:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:897
		{
			yyVAL.str = AST_ASC
		}
	case 167:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:901
		{
			// TODO(rhys): custom type
			yyVAL.str = AST_ASC
		}
	case 168:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:906
		{
			// TODO(rhys): custom type
			yyVAL.str = AST_DESC
		}
	case 172:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:916
		{
			yyVAL.limit = nil
		}
	case 173:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:920
		{
			yyVAL.limit = &Limit{Offset: yyDollar[4].valExpr, Rowcount: yyDollar[2].valExpr}
		}
	case 174:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:924
		{
			yyVAL.limit = &Limit{Offset: yyDollar[2].valExpr, Rowcount: yyDollar[4].valExpr}
		}
	case 175:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:928
		{
			yyVAL.limit = &Limit{Rowcount: yyDollar[2].valExpr}
		}
	case 176:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:933
		{
			yyVAL.str = ""
		}
	case 177:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:937
		{
			yyVAL.str = AST_FOR_UPDATE
		}
	case 178:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:941
		{
			if !bytes.Equal(yyDollar[3].bytes, SHARE) {
				yylex.Error("expecting share")
				return 1
			}
			if !bytes.Equal(yyDollar[4].bytes, MODE) {
				yylex.Error("expecting mode")
				return 1
			}
			yyVAL.str = AST_SHARE_MODE
		}
	case 179:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:954
		{
			yyVAL.columns = nil
		}
	case 180:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:958
		{
			yyVAL.columns = yyDollar[2].columns
		}
	case 181:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:964
		{
			yyVAL.columns = Columns{&NonStarExpr{Expr: yyDollar[1].colName}}
		}
	case 182:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:968
		{
			yyVAL.columns = append(yyVAL.columns, &NonStarExpr{Expr: yyDollar[3].colName})
		}
	case 183:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:973
		{
			yyVAL.selectExprs = nil
		}
	case 184:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:977
		{
			yyVAL.selectExprs = yyDollar[2].selectExprs
		}
	case 185:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:982
		{
			yyVAL.updateExprs = nil
		}
	case 186:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:986
		{
			yyVAL.updateExprs = yyDollar[5].updateExprs
		}
	case 187:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:992
		{
			yyVAL.insRows = yyDollar[2].values
		}
	case 188:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:996
		{
			yyVAL.insRows = yyDollar[1].selStmt
		}
	case 189:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1002
		{
			yyVAL.values = Values{yyDollar[1].rowTuple}
		}
	case 190:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1006
		{
			yyVAL.values = append(yyDollar[1].values, yyDollar[3].rowTuple)
		}
	case 191:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1012
		{
			yyVAL.rowTuple = ValTuple(yyDollar[2].valExprs)
		}
	case 192:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1016
		{
			yyVAL.rowTuple = yyDollar[1].subquery
		}
	case 193:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1022
		{
			yyVAL.updateExprs = UpdateExprs{yyDollar[1].updateExpr}
		}
	case 194:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1026
		{
			yyVAL.updateExprs = append(yyDollar[1].updateExprs, yyDollar[3].updateExpr)
		}
	case 195:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1032
		{
			yyVAL.updateExpr = &UpdateExpr{Name: yyDollar[1].colName, Expr: yyDollar[3].valExpr}
		}
	case 196:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1037
		{
			yyVAL.empty = struct{}{}
		}
	case 197:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1039
		{
			yyVAL.empty = struct{}{}
		}
	case 198:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1042
		{
			yyVAL.empty = struct{}{}
		}
	case 199:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1044
		{
			yyVAL.empty = struct{}{}
		}
	case 200:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1047
		{
			yyVAL.empty = struct{}{}
		}
	case 201:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1049
		{
			yyVAL.empty = struct{}{}
		}
	case 202:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1053
		{
			yyVAL.empty = struct{}{}
		}
	case 203:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1055
		{
			yyVAL.empty = struct{}{}
		}
	case 204:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1057
		{
			yyVAL.empty = struct{}{}
		}
	case 205:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1059
		{
			yyVAL.empty = struct{}{}
		}
	case 206:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1061
		{
			yyVAL.empty = struct{}{}
		}
	case 207:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1064
		{
			yyVAL.empty = struct{}{}
		}
	case 208:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1066
		{
			yyVAL.empty = struct{}{}
		}
	case 209:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1069
		{
			yyVAL.empty = struct{}{}
		}
	case 210:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1071
		{
			yyVAL.empty = struct{}{}
		}
	case 211:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1074
		{
			yyVAL.empty = struct{}{}
		}
	case 212:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1076
		{
			yyVAL.empty = struct{}{}
		}
	case 213:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1080
		{
			yyVAL.bytes = bytes.ToLower(yyDollar[1].bytes)
		}
	case 214:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1085
		{
			ForceEOF(yylex)
		}
	}
	goto yystack /* stack new state and value */
}
