// Code generated by protoc-gen-go.
// source: query.proto
// DO NOT EDIT!

/*
Package query is a generated protocol buffer package.

It is generated from these files:
	query.proto

It has these top-level messages:
	Target
	VTGateCallerID
	Value
	BindVariable
	BoundQuery
	Field
	Row
	QueryResult
	GetSessionIdRequest
	GetSessionIdResponse
	ExecuteRequest
	ExecuteResponse
	ExecuteBatchRequest
	ExecuteBatchResponse
	StreamExecuteRequest
	StreamExecuteResponse
	BeginRequest
	BeginResponse
	CommitRequest
	CommitResponse
	RollbackRequest
	RollbackResponse
	SplitQueryRequest
	QuerySplit
	SplitQueryResponse
	StreamHealthRequest
	RealtimeStats
	StreamHealthResponse
*/
package query

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import topodata "github.com/youtube/vitess/go/vt/proto/topodata"
import vtrpc "github.com/youtube/vitess/go/vt/proto/vtrpc"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.ProtoPackageIsVersion1

// Flag allows us to qualify types by their common properties.
type Flag int32

const (
	Flag_NONE       Flag = 0
	Flag_ISINTEGRAL Flag = 256
	Flag_ISUNSIGNED Flag = 512
	Flag_ISFLOAT    Flag = 1024
	Flag_ISQUOTED   Flag = 2048
	Flag_ISTEXT     Flag = 4096
	Flag_ISBINARY   Flag = 8192
)

var Flag_name = map[int32]string{
	0:    "NONE",
	256:  "ISINTEGRAL",
	512:  "ISUNSIGNED",
	1024: "ISFLOAT",
	2048: "ISQUOTED",
	4096: "ISTEXT",
	8192: "ISBINARY",
}
var Flag_value = map[string]int32{
	"NONE":       0,
	"ISINTEGRAL": 256,
	"ISUNSIGNED": 512,
	"ISFLOAT":    1024,
	"ISQUOTED":   2048,
	"ISTEXT":     4096,
	"ISBINARY":   8192,
}

func (x Flag) String() string {
	return proto.EnumName(Flag_name, int32(x))
}
func (Flag) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Type defines the various supported data types in bind vars
// and query results.
type Type int32

const (
	// NULL_TYPE specifies a NULL type.
	Type_NULL_TYPE Type = 0
	// INT8 specifies a TINYINT type.
	// Properties: 1, IsNumber.
	Type_INT8 Type = 257
	// UINT8 specifies a TINYINT UNSIGNED type.
	// Properties: 2, IsNumber, IsUnsigned.
	Type_UINT8 Type = 770
	// INT16 specifies a SMALLINT type.
	// Properties: 3, IsNumber.
	Type_INT16 Type = 259
	// UINT16 specifies a SMALLINT UNSIGNED type.
	// Properties: 4, IsNumber, IsUnsigned.
	Type_UINT16 Type = 772
	// INT24 specifies a MEDIUMINT type.
	// Properties: 5, IsNumber.
	Type_INT24 Type = 261
	// UINT24 specifies a MEDIUMINT UNSIGNED type.
	// Properties: 6, IsNumber, IsUnsigned.
	Type_UINT24 Type = 774
	// INT32 specifies a INTEGER type.
	// Properties: 7, IsNumber.
	Type_INT32 Type = 263
	// UINT32 specifies a INTEGER UNSIGNED type.
	// Properties: 8, IsNumber, IsUnsigned.
	Type_UINT32 Type = 776
	// INT64 specifies a BIGINT type.
	// Properties: 9, IsNumber.
	Type_INT64 Type = 265
	// UINT64 specifies a BIGINT UNSIGNED type.
	// Properties: 10, IsNumber, IsUnsigned.
	Type_UINT64 Type = 778
	// FLOAT32 specifies a FLOAT type.
	// Properties: 11, IsFloat.
	Type_FLOAT32 Type = 1035
	// FLOAT64 specifies a DOUBLE or REAL type.
	// Properties: 12, IsFloat.
	Type_FLOAT64 Type = 1036
	// TIMESTAMP specifies a TIMESTAMP type.
	// Properties: 13, IsQuoted.
	Type_TIMESTAMP Type = 2061
	// DATE specifies a DATE type.
	// Properties: 14, IsQuoted.
	Type_DATE Type = 2062
	// TIME specifies a TIME type.
	// Properties: 15, IsQuoted.
	Type_TIME Type = 2063
	// DATETIME specifies a DATETIME type.
	// Properties: 16, IsQuoted.
	Type_DATETIME Type = 2064
	// YEAR specifies a YEAR type.
	// Properties: 17, IsNumber, IsUnsigned.
	Type_YEAR Type = 785
	// DECIMAL specifies a DECIMAL or NUMERIC type.
	// Properties: 18, None.
	Type_DECIMAL Type = 18
	// TEXT specifies a TEXT type.
	// Properties: 19, IsQuoted, IsText.
	Type_TEXT Type = 6163
	// BLOB specifies a BLOB type.
	// Properties: 20, IsQuoted, IsBinary.
	Type_BLOB Type = 10260
	// VARCHAR specifies a VARCHAR type.
	// Properties: 21, IsQuoted, IsText.
	Type_VARCHAR Type = 6165
	// VARBINARY specifies a VARBINARY type.
	// Properties: 22, IsQuoted, IsBinary.
	Type_VARBINARY Type = 10262
	// CHAR specifies a CHAR type.
	// Properties: 23, IsQuoted, IsText.
	Type_CHAR Type = 6167
	// BINARY specifies a BINARY type.
	// Properties: 24, IsQuoted, IsBinary.
	Type_BINARY Type = 10264
	// BIT specifies a BIT type.
	// Properties: 25, IsQuoted.
	Type_BIT Type = 2073
	// ENUM specifies an ENUM type.
	// Properties: 26, IsQuoted.
	Type_ENUM Type = 2074
	// SET specifies a SET type.
	// Properties: 27, IsQuoted.
	Type_SET Type = 2075
	// TUPLE specifies a a tuple. This cannot
	// be returned in a QueryResult, but it can
	// be sent as a bind var.
	// Properties: 28, None.
	Type_TUPLE Type = 28
)

var Type_name = map[int32]string{
	0:     "NULL_TYPE",
	257:   "INT8",
	770:   "UINT8",
	259:   "INT16",
	772:   "UINT16",
	261:   "INT24",
	774:   "UINT24",
	263:   "INT32",
	776:   "UINT32",
	265:   "INT64",
	778:   "UINT64",
	1035:  "FLOAT32",
	1036:  "FLOAT64",
	2061:  "TIMESTAMP",
	2062:  "DATE",
	2063:  "TIME",
	2064:  "DATETIME",
	785:   "YEAR",
	18:    "DECIMAL",
	6163:  "TEXT",
	10260: "BLOB",
	6165:  "VARCHAR",
	10262: "VARBINARY",
	6167:  "CHAR",
	10264: "BINARY",
	2073:  "BIT",
	2074:  "ENUM",
	2075:  "SET",
	28:    "TUPLE",
}
var Type_value = map[string]int32{
	"NULL_TYPE": 0,
	"INT8":      257,
	"UINT8":     770,
	"INT16":     259,
	"UINT16":    772,
	"INT24":     261,
	"UINT24":    774,
	"INT32":     263,
	"UINT32":    776,
	"INT64":     265,
	"UINT64":    778,
	"FLOAT32":   1035,
	"FLOAT64":   1036,
	"TIMESTAMP": 2061,
	"DATE":      2062,
	"TIME":      2063,
	"DATETIME":  2064,
	"YEAR":      785,
	"DECIMAL":   18,
	"TEXT":      6163,
	"BLOB":      10260,
	"VARCHAR":   6165,
	"VARBINARY": 10262,
	"CHAR":      6167,
	"BINARY":    10264,
	"BIT":       2073,
	"ENUM":      2074,
	"SET":       2075,
	"TUPLE":     28,
}

func (x Type) String() string {
	return proto.EnumName(Type_name, int32(x))
}
func (Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type SplitQueryRequest_Algorithm int32

const (
	SplitQueryRequest_EQUAL_SPLITS SplitQueryRequest_Algorithm = 0
	SplitQueryRequest_FULL_SCAN    SplitQueryRequest_Algorithm = 1
)

var SplitQueryRequest_Algorithm_name = map[int32]string{
	0: "EQUAL_SPLITS",
	1: "FULL_SCAN",
}
var SplitQueryRequest_Algorithm_value = map[string]int32{
	"EQUAL_SPLITS": 0,
	"FULL_SCAN":    1,
}

func (x SplitQueryRequest_Algorithm) String() string {
	return proto.EnumName(SplitQueryRequest_Algorithm_name, int32(x))
}
func (SplitQueryRequest_Algorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{22, 0}
}

// Target describes what the client expects the tablet is.
// If the tablet does not match, an error is returned.
type Target struct {
	Keyspace   string              `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
	Shard      string              `protobuf:"bytes,2,opt,name=shard" json:"shard,omitempty"`
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
}

func (m *Target) Reset()                    { *m = Target{} }
func (m *Target) String() string            { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()               {}
func (*Target) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// VTGateCallerID is sent by VTGate to VTTablet to describe the
// caller. If possible, this information is secure. For instance,
// if using unique certificates that guarantee that VTGate->VTTablet
// traffic cannot be spoofed, then VTTablet can trust this information,
// and VTTablet will use it for tablet ACLs, for instance.
// Because of this security guarantee, this is different than the CallerID
// structure, which is not secure at all, because it is provided
// by the Vitess client.
type VTGateCallerID struct {
	Username string `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
}

func (m *VTGateCallerID) Reset()                    { *m = VTGateCallerID{} }
func (m *VTGateCallerID) String() string            { return proto.CompactTextString(m) }
func (*VTGateCallerID) ProtoMessage()               {}
func (*VTGateCallerID) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Value represents a typed value.
type Value struct {
	Type  Type   `protobuf:"varint,1,opt,name=type,enum=query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// BindVariable represents a single bind variable in a Query.
type BindVariable struct {
	Type  Type   `protobuf:"varint,1,opt,name=type,enum=query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// values are set if type is TUPLE.
	Values []*Value `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
}

func (m *BindVariable) Reset()                    { *m = BindVariable{} }
func (m *BindVariable) String() string            { return proto.CompactTextString(m) }
func (*BindVariable) ProtoMessage()               {}
func (*BindVariable) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *BindVariable) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// BoundQuery is a query with its bind variables
type BoundQuery struct {
	// sql is the SQL query to execute
	Sql string `protobuf:"bytes,1,opt,name=sql" json:"sql,omitempty"`
	// bind_variables is a map of all bind variables to expand in the query
	BindVariables map[string]*BindVariable `protobuf:"bytes,2,rep,name=bind_variables,json=bindVariables" json:"bind_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *BoundQuery) Reset()                    { *m = BoundQuery{} }
func (m *BoundQuery) String() string            { return proto.CompactTextString(m) }
func (*BoundQuery) ProtoMessage()               {}
func (*BoundQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *BoundQuery) GetBindVariables() map[string]*BindVariable {
	if m != nil {
		return m.BindVariables
	}
	return nil
}

// Field describes a single column returned by a query
type Field struct {
	// name of the field as returned by mysql C API
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// vitess-defined type. Conversion function is in sqltypes package.
	Type Type `protobuf:"varint,2,opt,name=type,enum=query.Type" json:"type,omitempty"`
}

func (m *Field) Reset()                    { *m = Field{} }
func (m *Field) String() string            { return proto.CompactTextString(m) }
func (*Field) ProtoMessage()               {}
func (*Field) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Row is a database row.
type Row struct {
	// lengths contains the length of each value in values.
	// A length of -1 means that the field is NULL. While
	// reading values, you have to accummulate the length
	// to know the offset where the next value begins in values.
	Lengths []int64 `protobuf:"zigzag64,1,rep,name=lengths" json:"lengths,omitempty"`
	// values contains a concatenation of all values in the row.
	Values []byte `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
}

func (m *Row) Reset()                    { *m = Row{} }
func (m *Row) String() string            { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()               {}
func (*Row) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// QueryResult is returned by Execute and ExecuteStream.
//
// As returned by Execute, len(fields) is always equal to len(row)
// (for each row in rows).
//
// As returned by StreamExecute, the first QueryResult has the fields
// set, and subsequent QueryResult have rows set. And as Execute,
// len(QueryResult[0].fields) is always equal to len(row) (for each
// row in rows for each QueryResult in QueryResult[1:]).
type QueryResult struct {
	Fields       []*Field `protobuf:"bytes,1,rep,name=fields" json:"fields,omitempty"`
	RowsAffected uint64   `protobuf:"varint,2,opt,name=rows_affected,json=rowsAffected" json:"rows_affected,omitempty"`
	InsertId     uint64   `protobuf:"varint,3,opt,name=insert_id,json=insertId" json:"insert_id,omitempty"`
	Rows         []*Row   `protobuf:"bytes,4,rep,name=rows" json:"rows,omitempty"`
}

func (m *QueryResult) Reset()                    { *m = QueryResult{} }
func (m *QueryResult) String() string            { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()               {}
func (*QueryResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *QueryResult) GetFields() []*Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *QueryResult) GetRows() []*Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

// GetSessionIdRequest is the payload to GetSessionId
type GetSessionIdRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Keyspace          string          `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
	Shard             string          `protobuf:"bytes,4,opt,name=shard" json:"shard,omitempty"`
}

func (m *GetSessionIdRequest) Reset()                    { *m = GetSessionIdRequest{} }
func (m *GetSessionIdRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSessionIdRequest) ProtoMessage()               {}
func (*GetSessionIdRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *GetSessionIdRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *GetSessionIdRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

// GetSessionIdResponse is the returned value from GetSessionId
type GetSessionIdResponse struct {
	SessionId int64 `protobuf:"varint,1,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
}

func (m *GetSessionIdResponse) Reset()                    { *m = GetSessionIdResponse{} }
func (m *GetSessionIdResponse) String() string            { return proto.CompactTextString(m) }
func (*GetSessionIdResponse) ProtoMessage()               {}
func (*GetSessionIdResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// ExecuteRequest is the payload to Execute
type ExecuteRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	TransactionId     int64           `protobuf:"varint,5,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	SessionId         int64           `protobuf:"varint,6,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
}

func (m *ExecuteRequest) Reset()                    { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()               {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

// ExecuteResponse is the returned value from Execute
type ExecuteResponse struct {
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteResponse) Reset()                    { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteResponse) ProtoMessage()               {}
func (*ExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteBatchRequest is the payload to ExecuteBatch
type ExecuteBatchRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Queries           []*BoundQuery   `protobuf:"bytes,4,rep,name=queries" json:"queries,omitempty"`
	AsTransaction     bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	TransactionId     int64           `protobuf:"varint,6,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	SessionId         int64           `protobuf:"varint,7,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
}

func (m *ExecuteBatchRequest) Reset()                    { *m = ExecuteBatchRequest{} }
func (m *ExecuteBatchRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchRequest) ProtoMessage()               {}
func (*ExecuteBatchRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecuteBatchRequest) GetQueries() []*BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

// ExecuteBatchResponse is the returned value from ExecuteBatch
type ExecuteBatchResponse struct {
	Results []*QueryResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
}

func (m *ExecuteBatchResponse) Reset()                    { *m = ExecuteBatchResponse{} }
func (m *ExecuteBatchResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchResponse) ProtoMessage()               {}
func (*ExecuteBatchResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ExecuteBatchResponse) GetResults() []*QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// StreamExecuteRequest is the payload to StreamExecute
type StreamExecuteRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	SessionId         int64           `protobuf:"varint,5,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
}

func (m *StreamExecuteRequest) Reset()                    { *m = StreamExecuteRequest{} }
func (m *StreamExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteRequest) ProtoMessage()               {}
func (*StreamExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *StreamExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StreamExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

// StreamExecuteResponse is the returned value from StreamExecute
type StreamExecuteResponse struct {
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *StreamExecuteResponse) Reset()                    { *m = StreamExecuteResponse{} }
func (m *StreamExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteResponse) ProtoMessage()               {}
func (*StreamExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *StreamExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// BeginRequest is the payload to Begin
type BeginRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	SessionId         int64           `protobuf:"varint,4,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
}

func (m *BeginRequest) Reset()                    { *m = BeginRequest{} }
func (m *BeginRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginRequest) ProtoMessage()               {}
func (*BeginRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *BeginRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

// BeginResponse is the returned value from Begin
type BeginResponse struct {
	TransactionId int64 `protobuf:"varint,1,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *BeginResponse) Reset()                    { *m = BeginResponse{} }
func (m *BeginResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginResponse) ProtoMessage()               {}
func (*BeginResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

// CommitRequest is the payload to Commit
type CommitRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	SessionId         int64           `protobuf:"varint,5,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
}

func (m *CommitRequest) Reset()                    { *m = CommitRequest{} }
func (m *CommitRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()               {}
func (*CommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *CommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CommitRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

// CommitResponse is the returned value from Commit
type CommitResponse struct {
}

func (m *CommitResponse) Reset()                    { *m = CommitResponse{} }
func (m *CommitResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()               {}
func (*CommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

// RollbackRequest is the payload to Rollback
type RollbackRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	SessionId         int64           `protobuf:"varint,5,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
}

func (m *RollbackRequest) Reset()                    { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()               {}
func (*RollbackRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *RollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *RollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *RollbackRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

// RollbackResponse is the returned value from Rollback
type RollbackResponse struct {
}

func (m *RollbackResponse) Reset()                    { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string            { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()               {}
func (*RollbackResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

// SplitQueryRequest is the payload for SplitQuery sent by VTGate to a VTTablet.
// See vtgate.SplitQueryRequest for more details.
type SplitQueryRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	SplitColumn       []string        `protobuf:"bytes,5,rep,name=split_column,json=splitColumn" json:"split_column,omitempty"`
	// Exactly one of the following must be nonzero.
	SplitCount          int64                       `protobuf:"varint,6,opt,name=split_count,json=splitCount" json:"split_count,omitempty"`
	NumRowsPerQueryPart int64                       `protobuf:"varint,8,opt,name=num_rows_per_query_part,json=numRowsPerQueryPart" json:"num_rows_per_query_part,omitempty"`
	SessionId           int64                       `protobuf:"varint,7,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
	Algorithm           SplitQueryRequest_Algorithm `protobuf:"varint,9,opt,name=algorithm,enum=query.SplitQueryRequest_Algorithm" json:"algorithm,omitempty"`
	// Whether to use the new split-query code
	// that supports multiple split-columns and
	// the FULL_SCAN algorithm.
	// This is a temporary field which aids
	// in the migration of SplitQuery to the new
	// code.
	// TODO(erez): Remove this field after the migration
	// to the SplitQuery version 2.
	UseSplitQueryV2 bool `protobuf:"varint,10,opt,name=use_split_query_v2,json=useSplitQueryV2" json:"use_split_query_v2,omitempty"`
}

func (m *SplitQueryRequest) Reset()                    { *m = SplitQueryRequest{} }
func (m *SplitQueryRequest) String() string            { return proto.CompactTextString(m) }
func (*SplitQueryRequest) ProtoMessage()               {}
func (*SplitQueryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *SplitQueryRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SplitQueryRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

// QuerySplit represents one query to execute on the tablet
type QuerySplit struct {
	// query is the query to execute
	Query *BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// row_count is the approximate row count the query will return
	RowCount int64 `protobuf:"varint,2,opt,name=row_count,json=rowCount" json:"row_count,omitempty"`
}

func (m *QuerySplit) Reset()                    { *m = QuerySplit{} }
func (m *QuerySplit) String() string            { return proto.CompactTextString(m) }
func (*QuerySplit) ProtoMessage()               {}
func (*QuerySplit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *QuerySplit) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

// SplitQueryResponse is returned by SplitQuery and represents all the queries
// to execute in order to get the entire data set.
type SplitQueryResponse struct {
	Queries []*QuerySplit `protobuf:"bytes,1,rep,name=queries" json:"queries,omitempty"`
}

func (m *SplitQueryResponse) Reset()                    { *m = SplitQueryResponse{} }
func (m *SplitQueryResponse) String() string            { return proto.CompactTextString(m) }
func (*SplitQueryResponse) ProtoMessage()               {}
func (*SplitQueryResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *SplitQueryResponse) GetQueries() []*QuerySplit {
	if m != nil {
		return m.Queries
	}
	return nil
}

// StreamHealthRequest is the payload for StreamHealth
type StreamHealthRequest struct {
}

func (m *StreamHealthRequest) Reset()                    { *m = StreamHealthRequest{} }
func (m *StreamHealthRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamHealthRequest) ProtoMessage()               {}
func (*StreamHealthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

// RealtimeStats contains information about the tablet status
type RealtimeStats struct {
	// health_error is the last error we got from health check,
	// or empty is the server is healthy. This is used for subset selection,
	// we do not send queries to servers that are not healthy.
	HealthError string `protobuf:"bytes,1,opt,name=health_error,json=healthError" json:"health_error,omitempty"`
	// seconds_behind_master is populated for slaves only. It indicates
	// how far behind on (MySQL) replication a slave currently is.  It is used
	// by clients for subset selection (so we don't try to send traffic
	// to tablets that are too far behind).
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// TODO(mberlin): Let's switch it to int64 instead?
	SecondsBehindMaster uint32 `protobuf:"varint,2,opt,name=seconds_behind_master,json=secondsBehindMaster" json:"seconds_behind_master,omitempty"`
	// bin_log_players_count is the number of currently running binlog players.
	// if the value is 0, it means that filtered replication is currently not
	// running on the tablet. If >0, filtered replication is running.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	BinlogPlayersCount int32 `protobuf:"varint,3,opt,name=binlog_players_count,json=binlogPlayersCount" json:"binlog_players_count,omitempty"`
	// seconds_behind_master_filtered_replication is populated for the receiving
	// master of an ongoing filtered replication only.
	// It specifies how far the receiving master lags behind the sending master.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// NOTE: This field must not be evaluated if "bin_log_players_count" is 0.
	SecondsBehindMasterFilteredReplication int64 `protobuf:"varint,4,opt,name=seconds_behind_master_filtered_replication,json=secondsBehindMasterFilteredReplication" json:"seconds_behind_master_filtered_replication,omitempty"`
	// cpu_usage is used for load-based balancing
	CpuUsage float64 `protobuf:"fixed64,5,opt,name=cpu_usage,json=cpuUsage" json:"cpu_usage,omitempty"`
	// qps is the average QPS (queries per second) rate in the last XX seconds
	// where XX is usually 60 (See query_service_stats.go).
	Qps float64 `protobuf:"fixed64,6,opt,name=qps" json:"qps,omitempty"`
}

func (m *RealtimeStats) Reset()                    { *m = RealtimeStats{} }
func (m *RealtimeStats) String() string            { return proto.CompactTextString(m) }
func (*RealtimeStats) ProtoMessage()               {}
func (*RealtimeStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

// StreamHealthResponse is streamed by StreamHealth on a regular basis
type StreamHealthResponse struct {
	// target is the current server type. Only queries with that exact Target
	// record will be accepted.
	Target *Target `protobuf:"bytes,1,opt,name=target" json:"target,omitempty"`
	// serving is true iff the tablet is serving. A tablet may not be serving
	// if filtered replication is enabled on a master for instance,
	// or if a replica should not be used because the keyspace is being resharded.
	Serving bool `protobuf:"varint,2,opt,name=serving" json:"serving,omitempty"`
	// tablet_externally_reparented_timestamp contains the last time
	// tabletmanager.TabletExternallyReparented was called on this tablet,
	// or 0 if it was never called. This is meant to differentiate two tablets
	// that report a target.TabletType of MASTER, only the one with the latest
	// timestamp should be trusted.
	TabletExternallyReparentedTimestamp int64 `protobuf:"varint,3,opt,name=tablet_externally_reparented_timestamp,json=tabletExternallyReparentedTimestamp" json:"tablet_externally_reparented_timestamp,omitempty"`
	// realtime_stats contains information about the tablet status
	RealtimeStats *RealtimeStats `protobuf:"bytes,4,opt,name=realtime_stats,json=realtimeStats" json:"realtime_stats,omitempty"`
}

func (m *StreamHealthResponse) Reset()                    { *m = StreamHealthResponse{} }
func (m *StreamHealthResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamHealthResponse) ProtoMessage()               {}
func (*StreamHealthResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *StreamHealthResponse) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StreamHealthResponse) GetRealtimeStats() *RealtimeStats {
	if m != nil {
		return m.RealtimeStats
	}
	return nil
}

func init() {
	proto.RegisterType((*Target)(nil), "query.Target")
	proto.RegisterType((*VTGateCallerID)(nil), "query.VTGateCallerID")
	proto.RegisterType((*Value)(nil), "query.Value")
	proto.RegisterType((*BindVariable)(nil), "query.BindVariable")
	proto.RegisterType((*BoundQuery)(nil), "query.BoundQuery")
	proto.RegisterType((*Field)(nil), "query.Field")
	proto.RegisterType((*Row)(nil), "query.Row")
	proto.RegisterType((*QueryResult)(nil), "query.QueryResult")
	proto.RegisterType((*GetSessionIdRequest)(nil), "query.GetSessionIdRequest")
	proto.RegisterType((*GetSessionIdResponse)(nil), "query.GetSessionIdResponse")
	proto.RegisterType((*ExecuteRequest)(nil), "query.ExecuteRequest")
	proto.RegisterType((*ExecuteResponse)(nil), "query.ExecuteResponse")
	proto.RegisterType((*ExecuteBatchRequest)(nil), "query.ExecuteBatchRequest")
	proto.RegisterType((*ExecuteBatchResponse)(nil), "query.ExecuteBatchResponse")
	proto.RegisterType((*StreamExecuteRequest)(nil), "query.StreamExecuteRequest")
	proto.RegisterType((*StreamExecuteResponse)(nil), "query.StreamExecuteResponse")
	proto.RegisterType((*BeginRequest)(nil), "query.BeginRequest")
	proto.RegisterType((*BeginResponse)(nil), "query.BeginResponse")
	proto.RegisterType((*CommitRequest)(nil), "query.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "query.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "query.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "query.RollbackResponse")
	proto.RegisterType((*SplitQueryRequest)(nil), "query.SplitQueryRequest")
	proto.RegisterType((*QuerySplit)(nil), "query.QuerySplit")
	proto.RegisterType((*SplitQueryResponse)(nil), "query.SplitQueryResponse")
	proto.RegisterType((*StreamHealthRequest)(nil), "query.StreamHealthRequest")
	proto.RegisterType((*RealtimeStats)(nil), "query.RealtimeStats")
	proto.RegisterType((*StreamHealthResponse)(nil), "query.StreamHealthResponse")
	proto.RegisterEnum("query.Flag", Flag_name, Flag_value)
	proto.RegisterEnum("query.Type", Type_name, Type_value)
	proto.RegisterEnum("query.SplitQueryRequest_Algorithm", SplitQueryRequest_Algorithm_name, SplitQueryRequest_Algorithm_value)
}

var fileDescriptor0 = []byte{
	// 1641 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xe4, 0x58, 0x49, 0x73, 0xdb, 0xc6,
	0x12, 0x7e, 0xe0, 0x26, 0xb2, 0x29, 0x52, 0xd0, 0x50, 0x7a, 0x8f, 0xa5, 0xb7, 0xf9, 0xc1, 0x7e,
	0x8e, 0xa3, 0xb8, 0x58, 0x0a, 0xbd, 0xc4, 0x95, 0xd5, 0xa4, 0x04, 0xc9, 0xac, 0x48, 0x14, 0x3d,
	0x04, 0x55, 0x71, 0x2e, 0x28, 0x88, 0x1c, 0x51, 0x28, 0x81, 0x04, 0x05, 0x0c, 0x65, 0xeb, 0xa6,
	0x24, 0x8e, 0xb3, 0x3a, 0x4b, 0x25, 0xce, 0x7a, 0x4a, 0xe5, 0x9e, 0x1f, 0x91, 0x3f, 0x90, 0x3f,
	0x90, 0xca, 0x3d, 0xa7, 0xfc, 0x85, 0xcc, 0x0c, 0x06, 0x20, 0xb5, 0x38, 0xaa, 0xf2, 0x29, 0x8e,
	0x4f, 0x9c, 0xee, 0xaf, 0x67, 0x7a, 0xfa, 0xeb, 0x6e, 0xcc, 0x0c, 0x21, 0xbb, 0x3b, 0x24, 0xde,
	0x7e, 0x69, 0xe0, 0xb9, 0xd4, 0x45, 0x49, 0x21, 0xcc, 0xe5, 0xa9, 0x3b, 0x70, 0x3b, 0x16, 0xb5,
	0x02, 0xf5, 0x5c, 0x76, 0x8f, 0x7a, 0x83, 0x76, 0x20, 0x68, 0xbb, 0x90, 0x32, 0x2c, 0xaf, 0x4b,
	0x28, 0x9a, 0x83, 0xf4, 0x0e, 0xd9, 0xf7, 0x07, 0x56, 0x9b, 0x14, 0x95, 0x33, 0xca, 0x85, 0x0c,
	0x8e, 0x64, 0x34, 0x03, 0x49, 0x7f, 0xdb, 0xf2, 0x3a, 0xc5, 0x98, 0x00, 0x02, 0x01, 0x5d, 0x81,
	0x2c, 0xb5, 0x36, 0x1d, 0x42, 0x4d, 0xba, 0x3f, 0x20, 0xc5, 0x38, 0xc3, 0xf2, 0xe5, 0x99, 0x52,
	0xe4, 0xce, 0x10, 0xa0, 0xc1, 0x30, 0x0c, 0x34, 0x1a, 0x6b, 0x17, 0x21, 0xbf, 0x61, 0xac, 0x58,
	0x94, 0x2c, 0x5a, 0x8e, 0x43, 0xbc, 0xda, 0x12, 0x77, 0x3d, 0xf4, 0x89, 0xd7, 0xb7, 0x7a, 0x91,
	0xeb, 0x50, 0xd6, 0x5e, 0x86, 0xe4, 0x86, 0xe5, 0x0c, 0x09, 0xfa, 0x2f, 0x24, 0x84, 0x1b, 0x45,
	0xb8, 0xc9, 0x96, 0x82, 0x48, 0xc5, 0xea, 0x02, 0xe0, 0x9b, 0xdc, 0xe3, 0x96, 0x62, 0x93, 0x93,
	0x38, 0x10, 0xb4, 0x1d, 0x98, 0xac, 0xda, 0xfd, 0xce, 0x86, 0xe5, 0xd9, 0x7c, 0x0b, 0x8f, 0xb8,
	0x0c, 0x3a, 0x07, 0x29, 0x31, 0xf0, 0x59, 0x98, 0xf1, 0x0b, 0xd9, 0xf2, 0xa4, 0x9c, 0x28, 0xf6,
	0x86, 0x25, 0xa6, 0xfd, 0xa8, 0x00, 0x54, 0xdd, 0x61, 0xbf, 0x73, 0x93, 0x83, 0x48, 0x85, 0xb8,
	0xbf, 0xeb, 0xc8, 0x90, 0xf8, 0x10, 0xbd, 0x0a, 0xf9, 0x4d, 0xb6, 0x1b, 0x73, 0x4f, 0x6e, 0xc7,
	0x67, 0x5e, 0xf8, 0x72, 0xe7, 0xe4, 0x72, 0xa3, 0xc9, 0xa5, 0xf1, 0x5d, 0xfb, 0x7a, 0x9f, 0x7a,
	0xfb, 0x38, 0xb7, 0x39, 0xae, 0x9b, 0x6b, 0x01, 0x3a, 0x6e, 0xc4, 0x9d, 0xb2, 0xbc, 0x85, 0x4e,
	0xd9, 0x10, 0x3d, 0x3d, 0x1e, 0x51, 0xb6, 0x5c, 0x08, 0x7d, 0x8d, 0xcd, 0x95, 0x61, 0x3e, 0x1f,
	0xbb, 0xa6, 0x68, 0x2f, 0x42, 0x72, 0xd9, 0x26, 0x4e, 0x07, 0x21, 0x48, 0x8c, 0xa5, 0x44, 0x8c,
	0x23, 0xfa, 0x62, 0x0f, 0xa1, 0x4f, 0x7b, 0x0e, 0xe2, 0xd8, 0xbd, 0x8d, 0x8a, 0x30, 0xe1, 0x90,
	0x7e, 0x97, 0x6e, 0xfb, 0x6c, 0x7a, 0xfc, 0x02, 0xc2, 0xa1, 0x88, 0xfe, 0x1e, 0x31, 0x19, 0x10,
	0x1c, 0x72, 0xf7, 0x40, 0x81, 0xac, 0x88, 0x1c, 0x13, 0x7f, 0xe8, 0x50, 0xce, 0xf8, 0x16, 0xdf,
	0x46, 0xb0, 0xc0, 0x88, 0x71, 0xb1, 0x37, 0x2c, 0x31, 0x74, 0x16, 0x72, 0x9e, 0x7b, 0xdb, 0x37,
	0xad, 0xad, 0x2d, 0xd2, 0xa6, 0x24, 0xa8, 0xd0, 0x04, 0x9e, 0xe4, 0xca, 0x8a, 0xd4, 0xa1, 0x7f,
	0x42, 0xc6, 0xee, 0xb3, 0x82, 0xa2, 0xa6, 0xdd, 0x11, 0x65, 0x9a, 0xc0, 0xe9, 0x40, 0x51, 0xeb,
	0xa0, 0xff, 0x40, 0x82, 0x1b, 0x17, 0x13, 0xc2, 0x0b, 0x48, 0x2f, 0x2c, 0x06, 0x2c, 0xf4, 0xda,
	0x4f, 0x0a, 0x14, 0x56, 0x08, 0x6d, 0x12, 0xdf, 0xb7, 0xdd, 0x7e, 0xad, 0x83, 0x09, 0xb3, 0xf0,
	0x29, 0x7a, 0x05, 0x0a, 0x44, 0x38, 0xb0, 0xf7, 0x88, 0xd9, 0x16, 0xa5, 0xcc, 0x97, 0x57, 0x04,
	0xc7, 0x53, 0xa5, 0xa0, 0xc9, 0xc2, 0x12, 0xc7, 0xd3, 0x91, 0xad, 0x54, 0x75, 0x90, 0x0e, 0x05,
	0xbb, 0xd7, 0x23, 0x1d, 0x9b, 0xb5, 0xc2, 0xd8, 0x02, 0x41, 0x92, 0x66, 0xc3, 0xfa, 0x3a, 0xd4,
	0x29, 0x78, 0x3a, 0x9a, 0x11, 0x2d, 0x33, 0xde, 0xb7, 0xf1, 0x87, 0xf5, 0x6d, 0x62, 0xac, 0x6f,
	0xb5, 0x2b, 0x30, 0x73, 0x38, 0x20, 0x7f, 0xe0, 0x32, 0x36, 0xd0, 0xbf, 0x01, 0xfc, 0x40, 0x19,
	0x06, 0x12, 0xc7, 0x19, 0x3f, 0x34, 0xd3, 0x7e, 0x88, 0x41, 0x5e, 0xbf, 0x43, 0xda, 0x43, 0x4a,
	0xfe, 0x6c, 0x1c, 0xfc, 0x1f, 0x52, 0x54, 0x7c, 0xc5, 0x04, 0x03, 0xd9, 0x72, 0x2e, 0xac, 0x4b,
	0xa1, 0xc4, 0x12, 0x44, 0x4f, 0x41, 0xf0, 0x49, 0x14, 0x74, 0x64, 0xcb, 0xd3, 0xc7, 0x9a, 0x0e,
	0x07, 0x38, 0x5b, 0x2f, 0x4f, 0x3d, 0xab, 0xef, 0x5b, 0x6c, 0xb7, 0x01, 0x1b, 0x49, 0xc1, 0x46,
	0x6e, 0x4c, 0xcb, 0xdc, 0x1e, 0x26, 0x2c, 0x75, 0x94, 0xb0, 0x97, 0x60, 0x2a, 0xe2, 0x4b, 0x52,
	0x3c, 0x0f, 0x29, 0x4f, 0x94, 0xb7, 0xe4, 0x08, 0xc9, 0x2d, 0x8c, 0x15, 0x3e, 0x96, 0x16, 0xda,
	0x2f, 0x31, 0x28, 0xc8, 0xf9, 0x55, 0x8b, 0xb6, 0xb7, 0x1f, 0x53, 0xd2, 0x9f, 0x81, 0x09, 0xae,
	0xb7, 0x49, 0xd8, 0x62, 0x27, 0xd0, 0x1e, 0x5a, 0x70, 0xe2, 0x2d, 0xdf, 0x1c, 0x63, 0x59, 0x10,
	0x9f, 0xc6, 0x39, 0xcb, 0x37, 0x46, 0xca, 0x13, 0xf2, 0x93, 0x3a, 0x3d, 0x3f, 0x13, 0x47, 0xf3,
	0xb3, 0x04, 0x33, 0x87, 0xf9, 0x95, 0x49, 0xba, 0x08, 0x13, 0x41, 0x0a, 0xc2, 0x4f, 0xcf, 0x49,
	0x59, 0x0a, 0x4d, 0xb4, 0xfb, 0x31, 0x98, 0x69, 0x52, 0x8f, 0x58, 0xbd, 0x27, 0xa4, 0x39, 0x0e,
	0xb3, 0x9a, 0x3c, 0xca, 0xea, 0x22, 0xcc, 0x1e, 0xa1, 0xe3, 0x11, 0x6a, 0xff, 0x67, 0x85, 0x1d,
	0xdb, 0xa4, 0x6b, 0xf7, 0x1f, 0x53, 0x32, 0x0f, 0x73, 0x94, 0x38, 0xca, 0xd1, 0x55, 0xc8, 0xc9,
	0xe8, 0x24, 0x37, 0xc7, 0x0b, 0x5a, 0x39, 0xa1, 0xa0, 0xb5, 0xbb, 0x31, 0xc8, 0x2d, 0xba, 0xbd,
	0x9e, 0x4d, 0x1f, 0x53, 0x5e, 0x8e, 0xc7, 0x99, 0x38, 0xbd, 0x71, 0x8f, 0x95, 0x98, 0x0a, 0xf9,
	0x90, 0x85, 0x80, 0x3f, 0xed, 0x5e, 0x0c, 0xa6, 0xb0, 0xeb, 0x38, 0x9b, 0x56, 0x7b, 0xe7, 0x89,
	0xa6, 0x06, 0x81, 0x3a, 0xe2, 0x41, 0x92, 0xf3, 0x5d, 0x02, 0xa6, 0x9b, 0x03, 0xc7, 0xa6, 0xb2,
	0xd3, 0xfe, 0xda, 0x9f, 0xa7, 0xff, 0xc1, 0xa4, 0xcf, 0x83, 0x35, 0xdb, 0xae, 0x33, 0xec, 0xf1,
	0x03, 0x24, 0xce, 0xae, 0x3e, 0x59, 0xa1, 0x5b, 0x14, 0x2a, 0x76, 0x89, 0xcd, 0x86, 0x26, 0xc3,
	0x3e, 0x95, 0x67, 0x07, 0x48, 0x0b, 0xa6, 0x41, 0x97, 0xe1, 0x1f, 0xfd, 0x61, 0xcf, 0x14, 0x37,
	0xcb, 0x01, 0x0b, 0x4b, 0xac, 0x6c, 0x0e, 0x2c, 0x8f, 0x16, 0xd3, 0xc2, 0xb8, 0xc0, 0x60, 0x76,
	0x45, 0xf4, 0x1b, 0xc4, 0x13, 0xce, 0x1b, 0x0c, 0x3a, 0xe5, 0xb8, 0x41, 0xd7, 0x21, 0x63, 0x39,
	0x5d, 0xd7, 0xb3, 0xe9, 0x76, 0xaf, 0x98, 0x11, 0xf7, 0x67, 0x4d, 0x46, 0x71, 0x2c, 0x3b, 0xa5,
	0x4a, 0x68, 0x89, 0x47, 0x93, 0xd8, 0x51, 0x8a, 0xd8, 0xbb, 0xc8, 0x0c, 0xf6, 0x1e, 0xec, 0x69,
	0xaf, 0x5c, 0x04, 0x71, 0x42, 0x4e, 0x31, 0x64, 0xb4, 0xcc, 0x46, 0x99, 0x3d, 0xb3, 0x32, 0xd1,
	0x22, 0xec, 0x51, 0x30, 0xa9, 0xdf, 0x6c, 0x55, 0x56, 0xcd, 0x66, 0x63, 0xb5, 0x66, 0x34, 0xd5,
	0xbf, 0xa1, 0x1c, 0x64, 0x96, 0x5b, 0xab, 0x4c, 0xb1, 0x58, 0xa9, 0xab, 0x8a, 0x86, 0x01, 0xc4,
	0x44, 0xb1, 0xc4, 0x88, 0x6c, 0xe5, 0x14, 0xb2, 0xd9, 0xcd, 0x9a, 0x91, 0x24, 0x79, 0x8c, 0x89,
	0x88, 0xd3, 0x4c, 0x21, 0x58, 0xd4, 0x2a, 0x80, 0xc6, 0x03, 0x93, 0x9f, 0xba, 0xb1, 0xfb, 0x80,
	0x72, 0xe8, 0x3e, 0x30, 0xf2, 0x1f, 0xdd, 0x07, 0xb4, 0x59, 0x28, 0x04, 0x87, 0xc9, 0x0d, 0x62,
	0x39, 0x34, 0xbc, 0x02, 0x69, 0xdf, 0xb3, 0xef, 0x20, 0xe6, 0x1a, 0xbb, 0x47, 0x9a, 0xd4, 0xa2,
	0x3e, 0xcf, 0xfa, 0xb6, 0x30, 0x31, 0x89, 0xe7, 0xb9, 0x9e, 0x7c, 0xb3, 0x64, 0x03, 0x9d, 0xce,
	0x55, 0xa8, 0x0c, 0xb3, 0x3e, 0x69, 0xbb, 0xfd, 0x8e, 0x6f, 0x6e, 0x92, 0x6d, 0xfe, 0x0a, 0xeb,
	0x59, 0x3e, 0x25, 0x9e, 0xd8, 0x77, 0x0e, 0x17, 0x24, 0x58, 0x15, 0xd8, 0x9a, 0x80, 0xd0, 0x02,
	0xcc, 0xb0, 0x37, 0x97, 0xe3, 0x76, 0xcd, 0x81, 0x63, 0xed, 0x13, 0xcf, 0x97, 0xa1, 0xf2, 0x52,
	0x4d, 0x62, 0x14, 0x60, 0x8d, 0x00, 0x0a, 0x4a, 0xe7, 0x75, 0x98, 0x3f, 0xd1, 0x8b, 0xb9, 0x65,
	0x3b, 0xec, 0x87, 0x74, 0x4c, 0x8f, 0xb0, 0x18, 0xdb, 0x96, 0xb8, 0xdd, 0x04, 0x2d, 0x7e, 0xfe,
	0x04, 0xd7, 0xcb, 0xd2, 0x1c, 0x8f, 0xac, 0x39, 0xdb, 0xed, 0xc1, 0xd0, 0x1c, 0xfa, 0x56, 0x97,
	0x88, 0xd6, 0x57, 0x70, 0x9a, 0x29, 0x5a, 0x5c, 0xe6, 0xef, 0xbe, 0xdd, 0x81, 0x2f, 0x8a, 0x59,
	0xc1, 0x7c, 0xa8, 0xfd, 0xaa, 0x84, 0x37, 0x93, 0x90, 0xbd, 0xe8, 0xb4, 0x09, 0x5b, 0x4e, 0xf9,
	0xa3, 0x96, 0x63, 0x6f, 0x38, 0xf6, 0x46, 0xda, 0xb3, 0xfb, 0x5d, 0x41, 0x51, 0x1a, 0x87, 0x22,
	0x6a, 0xc2, 0x79, 0xf9, 0xf2, 0x27, 0x77, 0x28, 0x7f, 0xa8, 0x3b, 0xce, 0x3e, 0x8f, 0xcb, 0xf2,
	0x48, 0x9f, 0x3d, 0xb8, 0x4c, 0x9e, 0x17, 0x9f, 0x5a, 0xbd, 0x81, 0x20, 0x2a, 0x8e, 0xcf, 0x06,
	0xd6, 0x7a, 0x64, 0x8c, 0x23, 0x5b, 0x23, 0x34, 0x45, 0x2f, 0x40, 0xde, 0x93, 0x39, 0x35, 0x7d,
	0x9e, 0x54, 0xd9, 0xea, 0x33, 0xe1, 0x93, 0x6c, 0x3c, 0xe1, 0x38, 0xe7, 0x8d, 0x8b, 0xf3, 0x3b,
	0x90, 0x58, 0x76, 0xac, 0x2e, 0x4a, 0x43, 0xa2, 0xbe, 0x5e, 0xd7, 0x59, 0x81, 0x4f, 0x01, 0xd4,
	0x9a, 0xb5, 0xba, 0xa1, 0xaf, 0xe0, 0xca, 0xaa, 0x7a, 0x10, 0x0b, 0x14, 0xad, 0x7a, 0xb3, 0xb6,
	0x52, 0xd7, 0x97, 0xd4, 0x83, 0x04, 0x9a, 0x84, 0x89, 0x5a, 0x73, 0x79, 0x75, 0xbd, 0x62, 0xa8,
	0x07, 0x69, 0xd6, 0x10, 0xe9, 0x5a, 0xf3, 0x66, 0x6b, 0xdd, 0xe0, 0xa0, 0x8a, 0xb2, 0x90, 0xaa,
	0x35, 0x0d, 0xfd, 0x35, 0x86, 0x9d, 0x09, 0xb0, 0x6a, 0xad, 0x5e, 0xc1, 0xb7, 0xd4, 0x83, 0xeb,
	0xf3, 0xbf, 0xc5, 0x20, 0xc1, 0x9f, 0xbc, 0xbc, 0x89, 0xea, 0xbc, 0x89, 0x8c, 0x5b, 0x0d, 0xee,
	0x32, 0x03, 0x09, 0xe6, 0xf0, 0x9a, 0xfa, 0x46, 0x0c, 0x01, 0x24, 0x5b, 0x62, 0xfc, 0x66, 0x8a,
	0x8f, 0xd9, 0xf0, 0xd9, 0xab, 0xea, 0x5b, 0x31, 0xbe, 0x6c, 0x2b, 0x10, 0xee, 0x86, 0x40, 0xf9,
	0xb2, 0xfa, 0x76, 0x04, 0x30, 0xe1, 0x5e, 0x08, 0x5c, 0x2a, 0xab, 0xef, 0x44, 0x00, 0x13, 0xde,
	0x0d, 0x81, 0xab, 0x97, 0xd5, 0xf7, 0x22, 0x80, 0x09, 0xef, 0xa7, 0x78, 0x2c, 0x22, 0x12, 0x66,
	0xf6, 0x41, 0x3a, 0x92, 0x18, 0xf6, 0x61, 0x1a, 0xe5, 0x21, 0x63, 0xd4, 0xd6, 0xf4, 0xa6, 0x51,
	0x59, 0x6b, 0xa8, 0xf7, 0x55, 0xbe, 0xcd, 0xa5, 0x8a, 0xa1, 0xab, 0x1f, 0x89, 0x21, 0x87, 0xd4,
	0x8f, 0x55, 0x1e, 0x23, 0xd7, 0x0a, 0xf1, 0x13, 0x81, 0xdc, 0xd2, 0x2b, 0x58, 0xfd, 0x34, 0xc5,
	0x1c, 0x4d, 0x2c, 0xe9, 0x8b, 0xb5, 0x35, 0x46, 0x23, 0x12, 0x33, 0x38, 0x2b, 0x9f, 0x2d, 0xf0,
	0x61, 0x75, 0x75, 0xbd, 0xaa, 0x7e, 0xde, 0xe0, 0x0e, 0x37, 0x2a, 0x78, 0xf1, 0x06, 0x9b, 0xf0,
	0x60, 0x81, 0x3b, 0x64, 0x92, 0xe4, 0xeb, 0x8b, 0x06, 0x37, 0x14, 0xd0, 0x97, 0x0b, 0x7c, 0xd3,
	0x52, 0xff, 0x55, 0x83, 0x25, 0x2b, 0x5e, 0xad, 0x19, 0xea, 0xd7, 0xc2, 0x9b, 0x5e, 0x6f, 0xad,
	0xa9, 0xdf, 0xa8, 0x5c, 0xd9, 0xd4, 0x0d, 0xf5, 0x5b, 0xae, 0x4c, 0x1a, 0xad, 0xc6, 0xaa, 0xae,
	0xfe, 0xab, 0x3a, 0x07, 0xc5, 0xb6, 0xdb, 0x2b, 0xed, 0xbb, 0x43, 0x3a, 0xdc, 0x24, 0xa5, 0x3d,
	0x9b, 0xb2, 0xcf, 0x6a, 0xf0, 0x17, 0xd6, 0x66, 0x4a, 0xfc, 0x5c, 0xfa, 0x3d, 0x00, 0x00, 0xff,
	0xff, 0xa4, 0xf3, 0x84, 0xc5, 0xfc, 0x12, 0x00, 0x00,
}
