package main

import (
	"log"
	"strconv"
	"time"
)

var WorkQueue = make(chan WorkRequest, 1000)

func checkForNewWork() {
	for {
		select {
		case recieveWork := <-WorkQueue:
			currentCaseID, err := strconv.Atoi(recieveWork.CaseID)
			if err != nil {
				log.Fatalf("Unable to convert work case ID to int: %s", recieveWork.CaseID)
			}
			if lastUpdatedCase < currentCaseID {
				lastUpdatedCase = currentCaseID
				log.Printf("Setting last updated case to: %d", currentCaseID)
			}
			if numInSlice(currentCaseID, checkedCasesIDs) {
				continue
			}
			checkedCasesIDs = append(checkedCasesIDs, currentCaseID)

			log.Printf("Received new case to process. CaseID: %s Type: %s", recieveWork.CaseID, recieveWork.CaseType)
			if recieveWork.CaseType == "desk_case" {
				go func() {
					if err := getDeskCase(recieveWork.CaseID); err != nil {
						log.Printf("Error getting desk case: %v", err)
					}
				}()
			}
			if recieveWork.CaseType == "set_language" {
				go func() {
					if err := setCaseLanguage(recieveWork.CaseID, recieveWork.CaseLanguage); err != nil {
						log.Printf("Error setting case language: %v", err)
					}
				}()
			}
			if recieveWork.CaseType == "post_labels" {
				go func() {
					if err := updateLabels(recieveWork.CaseID, recieveWork.CaseLabels.Labels, recieveWork.CaseLabels.Priority); err != nil {
						log.Printf("Error updating labels: %v", err)
					}
				}()
			}
			if recieveWork.CaseType == "post_note" {
				go func() {
					if err := postNote(recieveWork.CaseID, recieveWork.CaseNote.Body); err != nil {
						log.Printf("Error posting note: %v", err)
					}
				}()
			}
			if recieveWork.CaseType == "desk_search" {
				go func() {
					if err := getNewCases(recieveWork.Self); err != nil {
						log.Printf("Error getting new cases: %v", err)
					}
				}()
			}
		}
		time.Sleep(600 * time.Millisecond)
	}
}
