package main

import (
	"encoding/json"
	"errors"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"regexp"
	"time"

	"code.justin.tv/xangold/httpclient"
)

type UserProperties struct {
	ID       int    `json:"id"`
	Language string `json:"language"`
}

//Takes a username, and determines what language they have
func getAdminData(username string) (string, error) {
	VALID_USERNAME_REGEX := "[A-Za-z0-9_]{3,25}"
	r, err := regexp.Compile(VALID_USERNAME_REGEX)
	if err != nil {
		errStr := "Error: Invalid regex"
		log.Println(errStr, err)
		return "EN", errors.New(errStr)
	}
	if r.MatchString(username) != true {
		errStr := "Error: Invalid username"
		log.Println(errStr, err)
		return "EN", errors.New(errStr)
	}
	userID, err := getUserID(username)
	if err != nil {
		return "", err
	}

	fetchURL := fmt.Sprintf("%s/%d", userServiceHost, userID)
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return "", err
	}
	resp, err := client.Do(req)
	if err != nil {
		return "", err
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return "", err
	}
	if resp.StatusCode != http.StatusOK {
		return "", fmt.Errorf("bad status code in users service %d for user_id %d", resp.StatusCode, userID)
	}
	var data UserProperties
	err = json.Unmarshal(body, &data)
	if err != nil {
		return "", err
	}

	return data.Language, nil
}

type KrakenUser struct {
	ID int `json:"_id"`
}

func getUserID(username string) (int, error) {
	fetchURL := fmt.Sprintf("https://api.twitch.tv/kraken/users/%s/?client_id=22mh4r3t9ovb3nugu3oycdbp4o87l2q", username)
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return 0, err
	}
	resp, err := client.Do(req)
	if err != nil {
		return 0, err
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return 0, err
	}
	if resp.StatusCode != http.StatusOK {
		return 0, fmt.Errorf("bad status code in kraken %d for username %s", resp.StatusCode, username)
	}
	var data KrakenUser
	err = json.Unmarshal(body, &data)
	if err != nil {
		return 0, err
	}

	return data.ID, nil
}
