package main

import (
	"crypto/tls"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"time"

	"code.justin.tv/xangold/httpclient"
)

//start and end are 2014-10-16
func getConcurrents(channel string, startDay string, endDay string) (float64, error) {
	concurrents := 0.0
	cert, err := tls.LoadX509KeyPair("xangold-client.crt", "xangold-client.key")
	if err != nil {
		return concurrents, err
	}

	tr := &http.Transport{
		TLSClientConfig: &tls.Config{
			Certificates:       []tls.Certificate{cert},
			InsecureSkipVerify: true,
			ClientAuth:         tls.RequireAnyClientCert,
		},
	}

	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	client.Transport = tr

	dashboardURL := fmt.Sprintf("http://almanac.sci.justin.tv/v1/stats?channel=%s&end_date=%s&metrics=avg_concurrents&resolution=day&start_date=%s", channel, endDay, startDay)
	req, err := http.NewRequest("GET", dashboardURL, nil)
	if err != nil {
		return concurrents, err
	}
	resp, err := client.Do(req)
	if err != nil {
		return concurrents, err
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return concurrents, err
	}

	var data ShirleyData
	err = json.Unmarshal(body, &data)
	minutesBroadcast := 0
	for i, _ := range data.Series.Data {
		if len(data.Series.Data) < 2 {
			return concurrents, fmt.Errorf("Not enough values in concurrents: %d", len(data.Series.Data))
		}
		if v, ok := data.Series.Data[i].([]interface{})[1].(float64); ok {
			if v != 0 {
				concurrents = concurrents + v
				minutesBroadcast++
			}
		}
	}
	return concurrents / float64(minutesBroadcast), nil
}
