package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"strconv"
	"strings"
)

// Get a single desk case from desk.com and determine the properties such that we can parse it correctly
func getDeskCase(caseID string) error {
	client := &http.Client{Transport: tr}
	fetchURL := "https://help.twitch.tv/api/v2/cases/" + caseID
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return err
	}

	header, err := GetOAuthHeader(req)
	if err != nil {
		return err
	}

	req.Header.Add("Authorization", header)
	resp, err := client.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return err
	}

	var data CaseEntry
	if err := json.Unmarshal(body, &data); err != nil {
		return err
	}
	AssignedGroup := 214901
	links := strings.Split(data.Links.AssignedGroup.Href, "/")
	AssignedGroup, err = strconv.Atoi(links[len(links)-1])
	if err != nil {
		log.Println("Error converting AssignedGroup to int")
		AssignedGroup = 214901
	}
	links = strings.Split(data.Links.Customer.Href, "/")
	Customer := links[len(links)-1]
	switch AssignedGroup {
	case 214901:
		log.Println("General Case: ", caseID, Customer)
		message, err := getDeskMessage(caseID)
		if err != nil {
			return err
		}
		email, firstName, err := getCaseCustomer(Customer)
		if err != nil {
			return err
		}
		if err := parseGeneralCase(caseID, message, email, firstName); err != nil {
			return err
		}
	case 384051:
		log.Println("General2 Case: ", caseID, Customer)
		message, err := getDeskMessage(caseID)
		if err != nil {
			return err
		}
		email, firstName, err := getCaseCustomer(Customer)
		if err != nil {
			return err
		}
		if err := parseGeneralCase(caseID, message, email, firstName); err != nil {
			return err
		}
	case 626992:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 562919:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 497680:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 557236:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 557589:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 557845:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 557848:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 562918:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 563601:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 566216:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 567026:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 570688:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 570690:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 574055:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 594783:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 93815:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 643425:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 643426:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 643427:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 643027:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 643428:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 643429:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 645542:
		return parsePartnerAppsCaseHelper(caseID, Customer)
	case 201886:
		log.Println("Purchase Support Case: ", caseID, " doing nothing")
	case 396524:
		log.Println("Abuse Case: ", caseID, " doing nothing")
	default:
		return fmt.Errorf("Invalid case type. CaseID: %s AssignedGroup: %d", caseID, AssignedGroup)
	}
	return nil
}

func parsePartnerAppsCaseHelper(caseID, Customer string) error {
	log.Println("Partner Apps case", caseID)
	email, firstName, err := getCaseCustomer(Customer)
	if err != nil {
		return err
	}
	message, err := getDeskMessage(caseID)
	if err != nil {
		return err
	}
	err = parsePartnerAppsCase(caseID, message, email, firstName)
	if err != nil {
		return err
	}
	return nil
}
