package main

import (
	"encoding/json"
	"log"
	"time"
)

// minutes broadcast last 60 days, average real viewership, chat lines per min, err
func getMixpanelStats(channel string) (int, float64, float64, error) {
	//MINUTES BROADCAST
	m := make(map[string]string)
	oldTime := time.Unix(time.Now().Unix()-5184000, 0)
	m["to_date"] = time.Now().Format("2006-01-02")
	m["from_date"] = oldTime.Format("2006-01-02")
	m["where"] = "string(properties[\"channel\"]) == \"" + channel + "\""

	m["event"] = "minute_broadcast"
	data, err := mp.makeRequest("segmentation", m)
	if err != nil {
		return 0, 0, 0, err
	}

	var mpBroadcast MPData
	err = json.Unmarshal(data, &mpBroadcast)
	if err != nil {
		return 0, 0, 0, err
	}

	minutesBroadcast := 0
	for _, value := range mpBroadcast.Data.Values["minute_broadcast"] {
		minutesBroadcast = minutesBroadcast + int(value)
	}

	//MINUTES WATCHED
	m = make(map[string]string)
	oldTime = time.Unix(time.Now().Unix()-5184000, 0)
	m["to_date"] = time.Now().Format("2006-01-02")
	m["from_date"] = oldTime.Format("2006-01-02")
	m["where"] = "string(properties[\"channel\"]) == \"" + channel + "\""

	m["event"] = "minute-watched"
	data, err = mp.makeRequest("segmentation", m)
	if err != nil {
		return 0, 0, 0, err
	}
	var mpWatched MPData
	err = json.Unmarshal(data, &mpWatched)
	if err != nil {
		return 0, 0, 0, err
	}
	minutesWatched := 0
	for _, value := range mpWatched.Data.Values["minute-watched"] {
		minutesWatched = minutesWatched + int(value)
	}

	//CHAT
	m = make(map[string]string)
	oldTime = time.Unix(time.Now().Unix()-5184000, 0)
	m["to_date"] = time.Now().Format("2006-01-02")
	m["from_date"] = oldTime.Format("2006-01-02")
	m["where"] = "string(properties[\"channel\"]) == \"" + channel + "\""

	m["event"] = "chat"
	data, err = mp.makeRequest("segmentation", m)
	if err != nil {
		return 0, 0, 0, err
	}

	var mpChat MPData
	err = json.Unmarshal(data, &mpChat)
	if err != nil {
		return 0, 0, 0, err
	}
	chatLines := 0
	for _, value := range mpChat.Data.Values["chat"] {
		chatLines = chatLines + int(value)
	}
	if minutesBroadcast == 0 {
		errStr := "No minutes broadcast"
		log.Println(errStr, err)
		return 0, 0, 0, nil
	}

	return minutesBroadcast, (float64(minutesWatched) / (float64(minutesBroadcast))), (float64(chatLines) / (float64(minutesBroadcast))), nil
}
