package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"time"

	"code.justin.tv/xangold/httpclient"
)

const (
	youtubeAPIKey = "AIzaSyASHG70aIakgmJV7_vK7_VNoTsiyqUsalE"
)

func getYoutubeSubscribers(username string) (string, error) {
	fetchURL := fmt.Sprintf("https://www.googleapis.com/youtube/v3/channels?part=statistics&forUsername=%s&key=%s", username, youtubeAPIKey)
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return "", err
	}
	resp, err := client.Do(req)
	if err != nil {
		return "", err
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return "", err
	}
	var data YoutubeData
	err = json.Unmarshal(body, &data)
	if err != nil {
		return "", err
	}
	if len(data.Items) == 0 {
		return "", fmt.Errorf("No items in youtube data")
	}
	return data.Items[0].Statistics.SubscriberCount, nil
}
