package main

import (
	"database/sql"
	"log"
	"net/http"
	_ "net/http/pprof"
	"strings"
	"sync"

	_ "github.com/lib/pq"

	multiconfig "code.justin.tv/marketing/go-multiconfig"
)

var (
	tr              = &http.Transport{}
	wg              = sync.WaitGroup{}
	mp              *Mixpanel
	deskDB          *sql.DB
	siteDB          *sql.DB
	classifyNew     = 0
	lastUpdatedCase int
	autoTag         = 0
	caseTypes       string
	pgPort          string
	pgHost          string
	pgDB            string
	pgUser          string
	pgPass          string
	MixpanelKey     string
	MixpanelSecret  string

	// TODO (aaron): remove these.
	DeskPassword string
	deskDBHost   string
	deskDBPass   string
	deskDBUser   string

	userServiceHost = "http://users-service.prod.us-west2.twitch.tv/users"
)

func main() {

	log.Println("Successfully started up")
	go func() {
		log.Println(http.ListenAndServe("localhost:6060", nil))
	}()

	log.SetFlags(log.Lshortfile | log.Ldate | log.Ltime)
	conf := multiconfig.NewConfig()
	conf.IntVar(&autoTag, "autoTag", 0, "0 to skip autotagging, 1 to autoTag")
	conf.IntVar(&classifyNew, "classifyNew", 0, "0 to skip rebuilding classifications, 1 to re-build index")
	conf.StringVar(&caseTypes, "caseTypes", "Employee%20referral%20partner%20apps%2CPurchase%20Support%2CContent%20Appeals%2CNetDev%2CPartner%20Applications%2CTwitch%20Turbo%2CYouTube%20Exporter%2CPaid%20Users%2CExecutive%20Escalations%2CLogin%20Issues%2CJTV%20-%3E%20Twitch%2CPromotion%2CSuspension%20Appeals%2CGeneral%20Support", "string of case types variables")
	conf.StringVar(&pgHost, "pgHost", "127.0.0.1", "Where the postgres database is located")
	conf.StringVar(&pgDB, "pgDB", "desktagger_justintv_prod", "What database we connect to")
	conf.StringVar(&pgUser, "pgUser", "desktagger_01", "pgsql username")
	conf.StringVar(&pgPort, "pgPort", "12006", "PG port")
	conf.StringVar(&pgPass, "pgPass", "DBPASSWORD", "pgsql password")
	conf.StringVar(&DeskPassword, "DeskPassword", "DESKPASS", "desk.com password")
	conf.StringVar(&deskDBHost, "deskDBHost", "classifier db host", "classifier db host")
	conf.StringVar(&deskDBUser, "deskDBUser", "classifier db user", "classifier db user")
	conf.StringVar(&deskDBPass, "deskDBPass", "classifier db pass", "classifier db pass")
	conf.StringVar(&MixpanelKey, "MixpanelKey", "Mixpanel client Key", "mixpanel client key")
	conf.StringVar(&MixpanelSecret, "MixpanelSecret", "Mixpanel client secret", "mixpanel client secret")
	err := conf.Parse()
	if err != nil {
		log.Fatalln("Error getting the config data")
		return
	}
	wg.Add(1)

	mp = NewMixpanel(MixpanelKey, MixpanelSecret)
	var getLastError error
	lastUpdatedCase, getLastError = getLast()
	if getLastError != nil {
		log.Fatalf("Unable to get last case: %v", getLastError)
	}
	log.Printf("Initial last case is set to %d", lastUpdatedCase)

	go checkForNewWork()

	siteDBConnectionString := strings.Join([]string{"host=", "sitedb-replica-internal.prod.us-west2.justin.tv", " port=", "12006", " user=", "desktagger_01", " password=", pgPass, " dbname=", "desktagger_justintv_prod", " sslmode=disable", " binary_parameters=yes"}, "")
	siteDB, err = sql.Open("postgres", siteDBConnectionString)
	if err != nil {
		log.Fatalf("Unable to access siteDB database: %s", err.Error())
	}

	defer siteDB.Close()

	siteDB.SetMaxIdleConns(5)
	siteDB.SetMaxOpenConns(5)

	go checkForNew()

	wg.Wait()

}

func numInSlice(a int, list []int) bool {
	for _, b := range list {
		if b == a {
			return true
		}
	}
	return false
}

func stringInSlice(a string, list []string) bool {
	for _, b := range list {
		if b == a {
			return true
		}
	}
	return false
}
