package main

import (
	"github.com/jbrukh/bayesian"
)

type DeskMessage struct {
	Body    string `json:"body"`
	From    string `json:"from"`
	Subject string `json:"subject"`
}

type BayLife struct {
	Index int
	Class bayesian.Class
}

type CaseEntry struct {
	Blurb string `json:"blurb"`
	Links struct {
		AssignedGroup struct {
			Class string `json:"class"`
			Href  string `json:"href"`
		} `json:"assigned_group"`
		Customer struct {
			Class string `json:"class"`
			Href  string `json:"href"`
		} `json:"customer"`
	} `json:"_links"`
	Status  string `json:"status"`
	Subject string `json:"subject"`
}

type DeskCustomer struct {
	FirstName string `json:"first_name"`
	Emails    []struct {
		Type  string `json:"type"`
		Value string `json:"value"`
	} `json:"emails"`
}
type WorkRequest struct {
	CaseType     string
	CaseID       string
	CaseUpdate   string
	CaseLanguage string
	CaseLabels   *LabelPayload
	CaseNote     *NotePayload
	Self         string
}
type MPData struct {
	Data struct {
		Series []string `json:"series"`
		Values map[string]map[string]int64
	} `json:"data"`
	LegendSize int64 `json:"legend_size"`
}

type ShirleyData struct {
	Request struct {
		Channels   []string `json:"channels"`
		EndDate    string   `json:"end_date"`
		Metrics    []string `json:"metrics"`
		Resolution string   `json:"resolution"`
		StartDate  string   `json:"start_date"`
	} `json:"request"`
	Series struct {
		Columns []string      `json:"columns"`
		Data    []interface{} `json:"data"`
	} `json:"series"`
}

type PurchaseProfiles []struct {
	// CancelDatetime     interface{} `json:"cancel_datetime"`
	// CancelReason       interface{} `json:"cancel_reason"`
	// CreatedOn  string      `json:"created_on"`
	// DiscountId interface{} `json:"discount_id"`
	// DoNotRenewDatetime interface{} `json:"do_not_renew_datetime"`
	// ExpectedRecurDate  interface{} `json:"expected_recur_date"`
	// ExtPurchaserId     interface{} `json:"ext_purchaser_id"`
	// ExtSubscriptionId  interface{} `json:"ext_subscription_id"`
	Id int64 `json:"id"`
	// PaymentProvider  string `json:"payment_provider"`
	// ProductType      string `json:"product_type"`
	// PurchasableId    int64  `json:"purchasable_id"`
	// PurchaseDatetime string `json:"purchase_datetime"`
	// PurchaserEmail   string `json:"purchaser_email"`
	// PurchaserId      int64  `json:"purchaser_id"`
	//PurchaserName      interface{} `json:"purchaser_name"`
	// Recurring bool   `json:"recurring"`
	State string `json:"state"`
	//Test               interface{} `json:"test"`
	// UpdatedOn string `json:"updated_on"`
}

type AdminUserData struct {
	// AbuseReported              interface{} `json:"abuse_reported"`
	BroadcastCount          interface{} `json:"broadcast_count"`
	BroadcasterLanguage     interface{} `json:"broadcaster_language"`
	CommentsCount           int64       `json:"comments_count"`
	DmcaViolation           interface{} `json:"dmca_violation"`
	FansCount               int64       `json:"fans_count"`
	Id                      int64       `json:"id"`
	Login                   string      `json:"login"`
	SubscriptionsCount      int64       `json:"subscriptions_count"`
	TermsOfServiceViolation interface{} `json:"terms_of_service_violation"`
	ViewsCount              int64       `json:"views_count"`
}

type AdminSearchData []struct {
	BroadcastCount          interface{} `json:"broadcast_count"`
	BroadcasterLanguage     interface{} `json:"broadcaster_language"`
	CommentsCount           int64       `json:"comments_count"`
	DmcaViolation           interface{} `json:"dmca_violation"`
	FansCount               int64       `json:"fans_count"`
	Id                      int64       `json:"id"`
	Login                   string      `json:"login"`
	SubscriptionsCount      int64       `json:"subscriptions_count"`
	TermsOfServiceViolation interface{} `json:"terms_of_service_violation"`
	ViewsCount              int64       `json:"views_count"`
}

type YoutubeData struct {
	Etag  string `json:"etag"`
	Items []struct {
		Statistics struct {
			SubscriberCount string `json:"subscriberCount"`
			VideoCount      string `json:"videoCount"`
			ViewCount       string `json:"viewCount"`
		} `json:"statistics"`
	} `json:"items"`
}

type LabelPayload struct {
	Label_action string
	Labels       []string
	Priority     string
}

type LanguagePayload struct {
	Language string
}
type NotePayload struct {
	Body string
}

type TwitchChannelAPI struct {
	// BroadcasterSoftware   string      `json:"broadcaster_software"`
	// ComscoreC6            interface{} `json:"comscore_c6"`
	// ComscoreId            interface{} `json:"comscore_id"`
	// DisplayName           string      `json:"display_name"`
	// FightAdBlock          bool        `json:"fight_ad_block"`
	// Game                  interface{} `json:"game"`
	// HideAdsForSubscribers bool        `json:"hide_ads_for_subscribers"`
	// Id                    int64       `json:"_id"`
	// LiverailId            int64       `json:"liverail_id"`
	// Name                  string      `json:"name"`
	Partner bool `json:"partner"`
	// Postrolls             bool        `json:"postrolls"`
	// Ppv                   bool        `json:"ppv"`
	// Prerolls              bool        `json:"prerolls"`
	// ProductPath           string      `json:"product_path"`
	// Status                string      `json:"status"`
	// SteamId               string      `json:"steam_id"`
	// TwitchLiverailId      int64       `json:"twitch_liverail_id"`
	// VideoBanner           string      `json:"video_banner"`
}

type KrakenChannel struct {
	Views int
}
type DeskCases struct {
	Embedded struct {
		Entries []struct {
			Id int64 `json:"id"`
		} `json:"entries"`
	} `json:"_embedded"`
	Links struct {
		First struct {
			Class string `json:"class"`
			Href  string `json:"href"`
		} `json:"first"`
		Last struct {
			Class string `json:"class"`
			Href  string `json:"href"`
		} `json:"last"`
		Next struct {
			Class string `json:"class"`
			Href  string `json:"href"`
		} `json:"next"`
		Previous interface{} `json:"previous"`
		Self     struct {
			Class string `json:"class"`
			Href  string `json:"href"`
		} `json:"self"`
	} `json:"_links"`
	Page         int64 `json:"page"`
	TotalEntries int64 `json:"total_entries"`
}
