package multiconfig

import (
	"fmt"
	"strings"
)

type flagVar struct {
	raw string
	set bool
}

func (v *flagVar) String() string {
	return v.raw
}

func (v *flagVar) Set(raw string) error {
	v.set = true
	v.raw = raw

	return nil
}

func (c *Config) lookupOption(name string, fv *flagVar) (string, bool) {
	if fv.set {
		return fv.raw, true
	}

	// The flag name is transformed to all caps with hyphens replaced with
	// underscores. This is to more closely match how environment variables are
	// normally stored.
	//
	// Example:
	// foo => FOO
	// foo-api-token => FOO_API_TOKEN

	envName := strings.Replace(strings.ToUpper(name), "-", "_", -1)
	envVar := c.envGetter(envName)
	if envVar != "" {
		return envVar, true
	}

	if v, ok := c.config[name]; ok {
		return fmt.Sprintf("%v", v), true
	}

	return "", false
}
