package multiconfig

import "log"

// StringVar registers a new string config option. See the flag package for
// more details.
func (c *Config) StringVar(dest *string, name string, defaultValue string, usage string) {
	if name == "config" {
		log.Fatalf("%q is a reserved flag", name)
	}

	var fv flagVar
	c.flagSet.Var(&fv, name, usage)

	c.funcs = append(c.funcs, func() error {
		value, found := c.lookupOption(name, &fv)
		if !found {
			*dest = defaultValue
			return nil
		}

		*dest = value
		return nil
	})
}
