package main

import (
	"fmt"
	"log"

	multiconfig "git.internal.justin.tv/common/go-multiconfig"
)

func main() {
	var foo string
	var bar int

	conf := multiconfig.NewConfig()
	conf.StringVar(&foo, "foo", "blah", "The foo flag")
	conf.IntVar(&bar, "bar", 11, "The bar flag")
	if err := conf.Parse(); err != nil {
		log.Fatal(err)
	}

	fmt.Printf("foo: %q\n", foo)
	fmt.Printf("bar: %d\n", bar)
}
