#!/usr/bin/env bash
set -e -o pipefail

for file in \
	"google/protobuf/any.proto" \
	"google/protobuf/empty.proto" \
	"google/protobuf/timestamp.proto" \
	"google/protobuf/descriptor.proto" \
	"google/api/http.proto" \
	"google/api/annotations.proto" \
; do
	for dir in \
		"${GOPATH}/src/github.com/google/protobuf/src" \
		"${GOPATH}/src/github.com/google/googleapis" \
	; do
		path="${dir}/${file}"
		test -f "${path}" || continue

		mkdir -p -- "$(dirname "./${file}")"
		cp -- "${path}" "./${file}"

		break
	done
done
