// Code generated by protoc-gen-go.
// source: code.justin.tv/release/trace/common/event/kind.proto
// DO NOT EDIT!

/*
Package event is a generated protocol buffer package.

It is generated from these files:
	code.justin.tv/release/trace/common/event/kind.proto

It has these top-level messages:
*/
package event

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Kind describes the type of event instrumented.
//
// When a request-response RPC takes place, there are several identifiable
// instants that can be observed by the client, and several that can be
// observed by the server.  Each of those is assigned a different Kind
// value.  An program may only be instrumented to measure a small subset
// of the possible events.  The goal of the Kind enumeration is to
// document all known events precisely, so that if two programs emit an
// event with a particular Kind, that the results will be comparable.
//
// If a program wishes to emit an event which is not described by an
// existing Kind value, a new Kind should be written to fit the bill.  The
// new value should be reusable across other programs with similar
// requirements and should not be particular to the language or framework
// used.
type Kind int32

const (
	Kind_UNKNOWN Kind = 0
	// Server reads the beginning of a request.  The server has received
	// sufficient data from the client to determine which Trace
	// transaction the request should be attributed to, if any.  If the
	// protocol differentiates between a metadata preamble and a payload
	// that follows, this event is emitted immediately after the entire
	// metadata has been received.
	//
	// For an HTTP request, this would be when the transport has presented
	// the request URI and headers are presented to the application.
	Kind_REQUEST_HEAD_RECEIVED Kind = 20
	// Server finishes reading the last of the request body.
	//
	// For an HTTP request, this would be when the transport has presented
	// the last of the request body to the application and notified it
	// that no more body data will be received.  Trailers may be yet to
	// come.
	Kind_REQUEST_BODY_RECEIVED Kind = 21
	// Server responds to a request.  There has not yet been any direct
	// communication to the client about the client's request on the
	// application layer, but the server will change that immediately
	// after generating this event.  Transport-layer acknowledgement of
	// data receipt does not trigger this event.
	//
	// For an HTTP response, this would be when the status code and
	// headers are presented to the HTTP transport, before any bytes are
	// written to the wire.
	Kind_RESPONSE_HEAD_PREPARED Kind = 30
	// Server has sent the last of the response body to the client.
	//
	// For an HTTP response, this would be when the last of the response
	// body has been accepted by the HTTP transport, and the application
	// has notified the transport that no more body data will be sent.
	Kind_RESPONSE_BODY_SENT Kind = 31
	// Client initiates a request.  There has been no indication given to
	// the outside world that this particular request is about to take
	// place.  The application knows enough about the request to begin
	// making externally-visible actions.
	//
	// For an HTTP request, this would be when the request URI and headers
	// are presented to the HTTP transport, before any bytes are written
	// to the wire.  The hostname may still need to be resolved, a TCP
	// connection may still need to be established, a TLS handshake may
	// still need to take place.
	Kind_REQUEST_HEAD_PREPARED Kind = 40
	// Client finishes the externally-visible actions required for the
	// request.
	//
	// For an HTTP request, this would be when the last of the request
	// body has been accepted by the HTTP transport, and the application
	// has notified the transport that no more body data will be sent.
	Kind_REQUEST_BODY_SENT Kind = 41
	// Client reads the beginning of the response.  The response metadata
	// has been read and is ready to be presented to the application's
	// business logic, giving some initial indication of if the RPC
	// succeeded.  The response body has not yet been read.
	//
	// For an HTTP response, this would be when the client's HTTP
	// transport has read and decoded the full response headers from the
	// wire and is presenting them to the application, but before the
	// response body has been consumed.
	Kind_RESPONSE_HEAD_RECEIVED Kind = 50
	// Client finishes reading the last of the response body.
	//
	// For an HTTP response, this would be when the transport has
	// presented the last of the response body to the application and
	// notified it that no more body data will be received.  Trailers may
	// be yet to come.
	Kind_RESPONSE_BODY_RECEIVED Kind = 51
)

var Kind_name = map[int32]string{
	0:  "UNKNOWN",
	20: "REQUEST_HEAD_RECEIVED",
	21: "REQUEST_BODY_RECEIVED",
	30: "RESPONSE_HEAD_PREPARED",
	31: "RESPONSE_BODY_SENT",
	40: "REQUEST_HEAD_PREPARED",
	41: "REQUEST_BODY_SENT",
	50: "RESPONSE_HEAD_RECEIVED",
	51: "RESPONSE_BODY_RECEIVED",
}
var Kind_value = map[string]int32{
	"UNKNOWN":                0,
	"REQUEST_HEAD_RECEIVED":  20,
	"REQUEST_BODY_RECEIVED":  21,
	"RESPONSE_HEAD_PREPARED": 30,
	"RESPONSE_BODY_SENT":     31,
	"REQUEST_HEAD_PREPARED":  40,
	"REQUEST_BODY_SENT":      41,
	"RESPONSE_HEAD_RECEIVED": 50,
	"RESPONSE_BODY_RECEIVED": 51,
}

func (x Kind) String() string {
	return proto.EnumName(Kind_name, int32(x))
}

func init() {
	proto.RegisterEnum("code.justin.tv.release.trace.common.event.Kind", Kind_name, Kind_value)
}
