import { ProjectResources, EnvironmentConfig } from "../lib";

export const BASIC_CONFIG: EnvironmentConfig = {
  accountId: "123456",
  accountName: "test-account",
  defaultRegion: "us-west-2",
  airflow: {
    mwaaEnvironmentName: "test-mwaa-env",
  },
};

export const CDK_OUTDIR = "/tmp/test-conductor-cdk/";

export async function createBasicProjectResources(): Promise<ProjectResources> {
  const projectResources = new ProjectResources({
    name: "test-project",
    envName: "test-env",
    env: BASIC_CONFIG,
    branch: "test-branch",
    commitHash: "asdf",
    cdkOutdir: CDK_OUTDIR,
  });
  await projectResources.createCoreStack();
  return projectResources;
}
