import os
from pathlib import Path

import boto3

from conductor.internal.utils import load_project

SERIALIZED_DAG_TEMPLATE = Path(
    os.path.dirname(__file__), "templates", "serialized_dag.py.txt"
)


def mwaa_login(project_root) -> None:
    os.environ[
        "CDK_OUTDIR"
    ] = "/tmp"  # Placeholder, not used but required to run Conductor.
    # Load the project.
    project = load_project(project_root)
    env_name = project.project_resources.env_name
    mwaa_env_name = project.project_resources.env.airflow.mwaa_environment_name
    if mwaa_env_name is None:
        raise ValueError(
            "Cannot fetch MWAA login URL when selected "
            f"mwaa_environment_name attribute of CONDUCTOR_ENV={env_name} is None."
        )
    os.environ["AWS_PROFILE"] = project.project_resources.env.account_name
    client = boto3.client("mwaa")
    resp = client.create_web_login_token(Name=mwaa_env_name)
    host = resp["WebServerHostname"]
    token = resp["WebToken"]
    print(f"https://{host}/aws_mwaa/aws-console-sso?login=true#{token}")
