import os
from typing import Dict

from conductor_cdk import (  # noqa: F401
    AirflowConfig,
    DAGResources,
    EnvironmentConfig,
    PagerdutyConfig,
    ProjectBucketConfig,
    ProjectResources,
    RedshiftConfig,
    SageMakerConfig,
    VPCConfig,
)


class Project:
    project_resources: ProjectResources

    def __init__(self, *, name: str, environments: Dict[str, EnvironmentConfig]):
        self._name = name
        env_name = os.environ["CONDUCTOR_ENV"]
        self.project_resources = ProjectResources(
            name=name,
            env_name=env_name,
            env=environments[env_name],
            branch=os.environ["CONDUCTOR_GIT_BRANCH"],
            commit_hash=os.environ["CONDUCTOR_COMMIT_HASH"],
            cdk_outdir=os.environ["CDK_OUTDIR"],
        )
        self.project_resources.create_core_stack()

    @property
    def name(self) -> str:
        return self._name

    def get_dag_resources(self, name: str):
        return DAGResources(name, self.project_resources)
