import argparse

from conductor.docker import CONTAINER_ROOT
from conductor.internal.utils import load_conductor_instances


def main() -> None:
    parser = argparse.ArgumentParser(description="Container entrypoint")
    parser.add_argument("dag_name", help="Name of DAG to look for task under.")
    parser.add_argument("task_id", help="ID of task that contains entrypoint")
    parser.add_argument(
        "--project_root", help="Root directory of the project.", default=CONTAINER_ROOT
    )
    args = parser.parse_args()

    conductor_instances = load_conductor_instances(args.project_root)
    for c in conductor_instances:
        if c.name == args.dag_name:
            params = c.task_container_params[args.task_id]
            params.entrypoint(**params.kwargs)
            return
    raise ValueError(f"No conductor DAG named {args.dag_name} found.")


if __name__ == "__main__":
    main()
