from conductor.config import Project, ProjectResources
from conductor.hooks.metrics import ConfiguredMetricsHook
from conductor.hooks.redshift import ConfiguredRedshiftHook


class HooksRegistry:
    def __init__(self, project_resources: ProjectResources) -> None:
        self.RedshiftHook = ConfiguredRedshiftHook(project_resources).generate_hook
        self.MetricsHook = ConfiguredMetricsHook(project_resources).generate_hook


def configure_hooks(project: Project) -> HooksRegistry:
    return HooksRegistry(project.project_resources)
