from abc import ABC, abstractmethod

from airflow.hooks.base import BaseHook

from conductor.config import ProjectResources


class IConfiguredHook(ABC):
    def __init__(self, project_resources: ProjectResources) -> None:
        self.project_resources = project_resources

    @abstractmethod
    def generate_hook(self, *args, **kwargs) -> BaseHook:
        """
        Calls the underlying Airflow Operators.
        """
        pass
