from typing import Any, Dict


# See https://stackoverflow.com/questions/3232943/update-value-of-a-nested-dictionary-of-varying-depth/30655448#30655448
def deep_update(source: Dict[str, Any], overrides: Dict[str, Any]):
    """
    Update a nested dictionary
    Modify ``source`` in place.
    """
    for key, value in overrides.items():
        if isinstance(value, dict) and value:
            returned = deep_update(source.get(key, {}), value)
            source[key] = returned
        else:
            source[key] = overrides[key]
    return source
