---
title: "Command Line Interface (CLI)"
page-category: "searchable"
---

## CLI Parameters
All commands below can be prefixed with parameters:
- `--env <env_name>` - specify environment.
An `EnvironmentConfig` with a matching name must be present in your `Project`.
The default value is `staging`.

## CLI Commands

### deploy
```bash
conductor deploy
```
Deploy CDK resources for given project, then compile and upload all DAG definitions to target Airflow cluster.

##### Options:

- `--dag` Name of DAG to deploy. If specified, will only compile upload definition of selected DAG.


### init
```bash
conductor init
```
Initialize a new Conductor project.
Requires the project directory be instantiated with a `poetry` generated `pyproject.toml`, and an initial `git commit`.

### mwaa-login
```bash
conductor mwaa-login
```
Generate a login URL for your MWAA environment.
Requires the selected environment's Airflow config to have the `mwaa_environment_name` attribute set.
