---
title: "Hooks"
page-category: "searchable"
---

The page documents hooks configured via Conductor. For hooks included with Airflow, read the Airflow [documentation on hooks and operators](https://airflow.apache.org/docs/apache-airflow/stable/operators-and-hooks-ref.html)

## Using Conductor Hooks
Conductor hooks save you a lot of boilerplate by pre-loading configuration into existing hooks. Configure your hooks by creating a python file anywhere within your project and adding the following:

```python
# hooks.py for exaxmple
from project_config import project
from conductor.hook_registry import configure_hooks

configured_hooks = configure_hooks(project)
```
Within your business logic, you can then use the configured hooks:
```python
from my_hooks_module import configured_hooks
redshift_hook = configured_hooks.RedshiftHook()
...
```

## Configured Hooks
The below docs detail usage of Conductor Configured Hooks.
- Args: required arguments.
- Optional Args: optional, aka keyward arguments or kwargs.
- Outputs: Airflow hook that is returned.
- Required Config: Conductor configuration required in the selected `EnvironmentConfig` required for usage of the hook.
- Optional Config: Conductor configuration that is not necessary for operator usage, but can modify or augment the behavior.

### RedshiftHook
Returns a `PostgresHook` configured for Redshift access. See Airflow's [DbApi](https://airflow.apache.org/docs/apache-airflow/stable/_modules/airflow/hooks/dbapi.html) documentation for available methods.

Example usage:
```python
hook = configured_hooks.RedshiftHook()
df = hook.get_pandas_df(sql="SELECT * FROM my_table")
```
##### Outputs
- `twitch_airflow_components.hooks.postgres.PostgresHook` Configured with the details of the provided `RedshiftConfig`.

##### Required Config
- `RedshiftConfig` Provides the connection details for a Redshift cluster.


### MetricsHook
Provides a simple, type-checked interface to CloudWatch Metrics.

Example usage:
```python
from twitch_airflow_components.hooks.metrics import Metric, Dimension
hook = configured_hooks.MetricsHook()
hook.put_metrics(payloads=[
    Metric(
        MetricName="success",
        Value=1,
        Dimensions=[Dimension(Name="stage", Value="train")]
        Unit="Count",
    )
])
```
##### Outputs
- `twitch_airflow_components.hooks.metrics.MetricsHook` Configured with default namespace equal to your project name.