---
title: "Utils"
page-category: "searchable"
---
This page documents useful utilities and abstractions provided by Conductor.

## Types
Conductor offers abstract types that allow Conductor to make stronger assumptions about your code, which can reduce the amount of boilerplate that needs to be written to get a DAG running.

These types are located in the `conductor.types` module.

### Model
The `Model` type provides a basic interface for model training and serving within SageMaker.
It makes minimal assumptions about the model interface:
- The model object is pickle-able.
- The model must have a `train` method.
- The model must have a `predict` method that accepts and outputs `io.StringIO` data.

The Conductor SageMakerTraining operator expects models to be of this type.

**Abstract Methods**
- `train(self)` Script to train the model.
- `predict(self, data: io.StringIO) -> io.StringIO` Infer on a variable-sized batch of data.


## Error Handling
Conductor ships with a default Pagerduty integration for all environments where `prod=True`.
If you are using MWAA, to enable this integration within your cluster, follow the [setup guide](https://docs.aws.amazon.com/mwaa/latest/userguide/connections-secrets-manager.html).

MWAA Environments that are spun up using the `conductor-managed-airflow-environment` Twitch CDK module are set up to automatically according to the above guide, and are ready to use with Secret Manager.
Simply add your Pagerduty Events API integration key as a plaintext value in the form `none://:pagerduty@?routing_key=<your integration key>`, and name the secret `airflow/connections/pagerduty`.

If you want to use a separate Pagerduty key per project, Conductor offers a `PagerdutyConfig`, documentation under [Config]({{"/pages/documentation/config.html" | relative_url}}).
