import os
import sys
from pathlib import Path

import pytest
from git import Repo

from conductor.cli.cmd.deploy import load_project
from conductor.cli.cmd.init import init
from conductor.internal.utils import load_conductor_instances
from tests.cli.cmd.test_files import FIXTURE_DIR


@pytest.mark.datafiles(Path(FIXTURE_DIR, "pyproject.toml"))
def test_init(datafiles, monkeypatch) -> None:
    monkeypatch.setenv("CONDUCTOR_ENV", "staging")
    os.chdir(datafiles)
    Repo.init(datafiles)  # Initialize a git repo in the test directory.
    init(datafiles)  # Should not error.
    sys.path.append(str(datafiles))
    project = load_project(datafiles)
    conductor_instances = load_conductor_instances(datafiles)
    assert (
        project.project_resources.env.airflow.mwaa_environment_name
        == "my-mwaa-environment-name"
    )
    assert conductor_instances[0].name == "my-dag"
