import os
from pathlib import Path

import pytest

from conductor.cli.cmd.mwaa_login import mwaa_login
from tests.cli.cmd.test_files import FIXTURE_DIR


@pytest.mark.datafiles(Path(FIXTURE_DIR, "test_project"))
def test_mwaa_login(datafiles, mocker) -> None:
    os.chdir(datafiles)

    def client(_service_name: str):
        class MWAA:
            def create_web_login_token(self, Name: str = ""):
                assert Name == "my-mwaa-environment-name"
                return {"WebServerHostname": "my.host.com", "WebToken": "abcde"}

        return MWAA()

    mocker.patch("conductor.cli.cmd.mwaa_login.boto3.client", client)
    mock_print = mocker.patch("builtins.print")
    mwaa_login(datafiles)
    mock_print.assert_called_with(
        "https://my.host.com/aws_mwaa/aws-console-sso?login=true#abcde"
    )


@pytest.mark.datafiles(Path(FIXTURE_DIR, "test_project"))
def test_mwaa_login_fails(datafiles, mocker, monkeypatch) -> None:
    os.chdir(datafiles)
    monkeypatch.setenv("CONDUCTOR_ENV", "dummy")
    with pytest.raises(ValueError):
        mwaa_login(datafiles)
