import os
import sys
from pathlib import Path

import pytest

import conductor.utils.sagemaker_training_environment
from conductor.docker.conductor_entrypoints.train import main
from tests.docker.test_files import FIXTURE_DIR


@pytest.mark.datafiles(Path(FIXTURE_DIR, "test_project"))
@pytest.mark.no_auto_env
def test_process(datafiles, mocker, monkeypatch):
    monkeypatch.setenv("CONDUCTOR_ENV", "test-env")
    monkeypatch.setenv("CONDUCTOR_GIT_BRANCH", "test-branch")
    monkeypatch.setenv("CONDUCTOR_COMMIT_HASH", "test-commit-hash")
    monkeypatch.setenv("CDK_OUTDIR", "cdk")

    mocker.patch.object(
        conductor.utils.sagemaker_training_environment,
        "INPUT_CONFIG_PATH",
        str(datafiles),
    )
    mocker.patch.object(
        conductor.utils.sagemaker_training_environment, "MODEL_PATH", str(datafiles)
    )

    sys.path.append(str(datafiles))
    with pytest.raises(KeyError):
        main()

    monkeypatch.setenv("MODEL_CLS_MODULE", "model")
    with pytest.raises(KeyError):
        main()

    monkeypatch.setenv("MODEL_CLS_NAME", "ModelTestClass")
    main()
    assert "model.pkl" in os.listdir(datafiles)
