from conductor.config import RedshiftConfig
from conductor.hooks.redshift import ConfiguredRedshiftHook
from tests.utils import create_test_project


def test_redshift():
    redshift_config = RedshiftConfig(
        host="host",
        port=5439,
        cluster_identifier="test_cluster",
        db_name="test_db",
        db_user="test_user",
        unload_role="arn:aws:iam::400577501318:role/RedshiftS3UnloadRole",
    )
    project = create_test_project(redshift=redshift_config)

    hookgen = ConfiguredRedshiftHook(project.project_resources)

    test_redshift_hook = hookgen.generate_hook()

    assert test_redshift_hook.connection.host == "host"
    assert (
        test_redshift_hook.connection.extra
        == '{"iam": true, "aws_conn_id": null, "redshift": true, "cluster-identifier": "test_cluster"}'
    )
