

module "bs-dev" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "fuel-devportal"
  eb_application_name = "tcs-example"
  vpc_id = "dev-vpc"
  ec2_subnet_ids = "dev-sbs"
  elb_subnet_ids = "dev-sbs"
  elb_loadbalancer_security_groups = "dev-sgs"
  auto_scaling_lc_security_groups = "dev-sgs"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "dev-devtools-dta"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "mmdixon@justin.tv"
  service = "mmdixon/tcs-example"
  env = "dev"
  associate_public_address = "false"
  cname_prefix = "fuel-devportal-test-dev"
}
