<?php
// ÜÄÖ UTF8-FTW
// Only allow including of this file
if(preg_match('/chat_activity_checker\.php/i', $_SERVER['PHP_SELF']) === 1)
{
	exit();
}

header('Content-Type: text/html; charset=utf-8');

function array_to_sql_string($array)
{
	if(count($array) > 0)
	{
		$return = '';
		foreach($array as $part)
		{
			$return .= ",'".$GLOBALS['mysqli']->real_escape_string($part)."'";
		}
		return substr($return, 1);
	}
	else
	{
		return "''";
	}
}

if(isset($_POST['list']) && !empty($_POST['list']))
{
	$list = str_replace(array('	', ' '), ' ', $_POST['list']);
	$list_explode = explode("\n", $list);
	// remove spaces at the start and end of each line and remove blank lines
	foreach($list_explode as $key => $part)
	{
		$part = trim($part);
		$list_explode[$key] = $part;
		if(empty($part))
		{
			unset($list_explode[$key]);
		}
	}
	$list_explode = array_unique($list_explode);
	
	// Remove possible user match and banned info
	$not_lookup_user_array = array('xanbot', 'nightbot', 'moobot', 'ackbot', 'login');
	$list_list_explode = array();
	foreach($list_explode as $part)
	{
		$part_exploded = explode(' ', $part);
		// If it ends with View the it's for sure an AA lookup
		if(count($part_exploded) >= 2 && substr($part, -4) == 'View')
		{
			$part_username = $part_exploded[2];
		}
		elseif(is_numeric($part_exploded[0]) && isset($part_exploded[2]) && !empty($part_exploded[2]) && !in_array($part_exploded[2], array('Type', 'login', 'ip', 'email')))
		{
			// Still AA lookup
			$part_username = $part_exploded[2];
		}
		else
		{
			// Normal list or Alt Lookup room
			$part_username = $part_exploded[0];
		}
		if(!in_array(strtolower($part_username), $not_lookup_user_array))
		{
			$list_list_explode[] = $part_username;
		}
	}
	$user_array = array_unique($list_list_explode);
	unset($list_explode, $list_list_explode);
	
	$error = false;
	if(count($user_array) > 2500)
	{
		$error = true;
		$error_msg = 'You can only check up to 2500 user at once!'.PHP_EOL;
	}
	elseif(count($user_array) > 0)
	{
		// Get chat log tables
		if($result = $mysqli->query("SHOW TABLES FROM `twitch_chatlogs` LIKE 'chatlog_%' "))
		{
			$chatlog_table_array = array();
			while($row = $result->fetch_row())
			{
			   $chatlog_table_array[] = substr($row[0], 8);
			}
			$result->free();
			$chatlog_table_array = array_reverse($chatlog_table_array);
			// Only need the last 2 days / tables
			array_splice($chatlog_table_array, 2);
		}
		
		// Produce query
		$chatlogs_query_string = '';
		foreach($chatlog_table_array as $table)
		{
			$chatlogs_query_string .= "(SELECT `room`,`nick`, CASE WHEN `tags_int`&1 = 1 THEN 'MOD' ELSE '' END `mod` FROM `chatlog_".$mysqli->real_escape_string($table)."` WHERE `nick` IN (".array_to_sql_string($user_array).") AND `tags_int`&128 != 128) UNION DISTINCT ";
		}
		$chatlogs_query_string = substr($chatlogs_query_string, 0, -16);
		$chatlogs_query_string .= ' ORDER BY `room` ASC, `nick` ASC';
		// echo $chatlogs_query_string.PHP_EOL;
		// exit();
		
		if($result = $mysqli->query($chatlogs_query_string))
		{
			$active_chatter_array = array();
			while($row = $result->fetch_assoc())
			{
				$user_in_channel_status = '';
				if($row['mod'] == 'MOD')
				{
					$user_in_channel_status .= ' [MOD]';
				}
				$active_chatter_array[] = $row['room'].'     '.$row['nick'].$user_in_channel_status;
			}
		}
	}
}

?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="referrer" content="origin">
	<title>Chat actvity checker</title>
</head>
<body>
<h2>Check chat activity for a list of users</h2><br>
<form id="form" action="" method="post">
<table>
<tr>
	<td>
		<div align="center">Userlist (2000 max):</div>
	</td>
	<?php
	if(isset($_POST['list']) && !empty($_POST['list']))
	{
		?>
	<td>
		<div align="center">List of names that got used for lookup:</div>
	</td>
		<?php
	}
	?>
</tr>
<tr>
	<td>
		<textarea name="list" id="list" cols="60" rows="15"><?php if(isset($_POST['list']) && !empty($_POST['list'])) echo htmlspecialchars($_POST['list'], ENT_QUOTES); ?></textarea>
	</td>
	<?php
	if(isset($_POST['list']) && !empty($_POST['list']))
	{
		?>
	<td>
		<textarea name="used_list" id="used_list" cols="30" rows="15" readonly><?php 
		if(isset($user_array) && count($user_array) > 0)
		{
			foreach($user_array as $user)
			{ 
				echo htmlspecialchars($user, ENT_QUOTES).PHP_EOL;
			}
		} ?></textarea>
	</td>
		<?php
	}
	?>
</tr>
<tr>
	<td>
		<br>
		<input type="Submit" name="check" value="Check" />
	</td>
</tr>
</table>
</form>
<?php
if(isset($error) && $error === true)
{
	echo '<h2><b>'.$error_msg.'</b></h2>'.PHP_EOL;
}
if(isset($active_chatter_array))
{
?>
<br>
<table>
<tr>
	<td>
		<div align="center">In chat active:</div>
	</td>
</tr>
<tr>
	<td>
		<textarea name="active_chatter" id="active_chatter" cols="60" rows="15"><?php
if(count($active_chatter_array) > 0)
{
	foreach($active_chatter_array as $part)
	{
		echo htmlspecialchars($part, ENT_QUOTES).PHP_EOL;
	}
}
else
{
	echo 'No user from the list was active in chat the last 2 days!';
}
?></textarea>
	</td>
</tr>
</table>
<?php
}
?>
<br>
Total request time: <strong><?php echo round(microtime(true) - $script_start_time, 4); ?> sec</strong>
</body>
</html>