<?php
// äüö UFT8-FTW
error_reporting(0);
ignore_user_abort(false);
$script_start_time = microtime(true);

require_once __DIR__ . '/../RedisSessionHandler.php';
$sessHandler = new RedisSessionHandler(null, null, null, null, true);
session_set_save_handler($sessHandler);
session_start();
// We don't change anything in the session so we can close writes here
@session_write_close();


if(!empty($_SERVER['HTTPS']))
{
	$http_or_https = 'https';
}
else
{
	$http_or_https = 'http';
}


$delete_whitelist_array = array('desk:21812880' /* Ryan */);

if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true)
{
	$current_user = 'desk:'.$_SESSION['user']['desk_ID'];
	
$mysqli = new mysqli('betterdesk-mysql.cunim1xnmwzu.us-west-1.rds.amazonaws.com', 'twitch_chatlogs_read', 'ivp7xYUB9EgFA8hm', 'twitch_chatlogs');
/* check connection */
if($mysqli->connect_errno) {
	echo 'There was an error connecting to the backend DB. Please try again later.';
	// printf('Connect failed: %s'.PHP_EOL, $mysqli->connect_error);
	exit();
}
$mysqli->set_charset('utf8mb4');

// chat activity checker
if(isset($_GET['chat_activity_checker']))
{
	require_once __DIR__ . '/chat_activity_checker.php';
	exit();
}

// Get the list of all tables
$chatlog_table_array = array();
if($result = $mysqli->query("SHOW TABLES FROM `twitch_chatlogs` LIKE 'chatlog_%' "))
{
    while($row = $result->fetch_row())
	{
       $chatlog_table_array[] = substr($row[0], 8);
    }
    $result->free();
}
$chatlog_table_array = array_reverse($chatlog_table_array);
// Only show the last 14 days
if(count($chatlog_table_array) > 14)
{
	$chatlog_table_array = array_splice($chatlog_table_array, 0, 14);
}


// Delete entry part
if(isset($_GET['delete_ID']) && !empty($_GET['delete_ID']) && isset($_GET['table']) && !empty($_GET['table']) && in_array($current_user, $delete_whitelist_array) === true && in_array($_GET['table'], $chatlog_table_array))
{
	$db_query = "DELETE FROM `chatlog_".$mysqli->real_escape_string($_GET['table'])."` WHERE `ID` = '".$mysqli->real_escape_string($_GET['delete_ID'])."'";
	if($mysqli->query($db_query) === true)
	{
		// Add an audit entry
		$mysqli->query("INSERT INTO `audits` (`action`, `action_by`, `command`) VALUES ('delete', '".$mysqli->real_escape_string($current_user)."', '".$mysqli->real_escape_string($db_query)."')");
	}
}

function get_date_for_chatlog($report_time, $for_link = false)
{
	$dateTime = new DateTime(date('c', strtotime($report_time)), new DateTimeZone(date_default_timezone_get()));
	// $dateTime->setTimezone(new DateTimeZone('America/New_York'));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	if($for_link === true)
	{
		$return = $dateTime->format('Y_m_d');
	}
	else
	{
		$return = $dateTime->format('Y-m-d h:i:s A T');
	}
	return $return;
}

function gen_report_line_string_for_message($timestamp, $room, $tags_int, $nick, $message)
{
	$tags_string = '';
	if(strlen($room) > 1 && strtolower(substr($room, 1)) == strtolower($nick))
	{
		$tags_string .= '[Broadcaster] ';
	}
	
	if(isset($tags_int) && !empty($tags_int))
	{
		$tags_array = array();
		if(($tags_int & 64) == 64)
		{
			// Cheer message
			$tags_array[] = 'cheer_message';
		}

		if(($tags_int & 32) == 32)
		{
			// Subscriber
			$tags_array[] = 'subscriber';
		}

		if(($tags_int & 16) == 16)
		{
			// Turbo
			$tags_array[] = 'turbo';
		}

		if(($tags_int & 8) == 8)
		{
			// Staff
			$tags_array[] = 'staff';
		}

		if(($tags_int & 4) == 4)
		{
			// Admin
			$tags_array[] = 'admin';
		}

		if(($tags_int & 2) == 2)
		{
			// Global Mod
			$tags_array[] = 'global_mod';
		}

		if(($tags_int & 1) == 1)
		{
			// Mod
			$tags_array[] = 'mod';
		}

		// Images depending on the tags
		if(in_array('mod', $tags_array))
		{
			$tags_string .= '[Mod] ';
		}
		if(in_array('global_mod', $tags_array))
		{
			$tags_string .= '[Global-Mod] ';
		}
		if(in_array('admin', $tags_array))
		{
			$tags_string .= '[Admin] ';
		}
		if(in_array('staff', $tags_array))
		{
			$tags_string .= '[Staff] ';
		}

		if(in_array('turbo', $tags_array))
		{
			$tags_string .= '[Turbo] ';
		}

		if(in_array('subscriber', $tags_array))
		{
			$tags_string .= '[Subscriber]';
		}

		if(in_array('cheer_message', $tags_array))
		{
			$tags_string .= '[Cheer-Message]';
		}
	}
	
	$tags_string = trim($tags_string);
	if(!empty($tags_string))
	{
		$tags_string = '['.$tags_string.']   ';
	}

	return get_date_for_chatlog($timestamp).'   '.$room.'   '.$tags_string.$nick.'   '.$message;
}

function parse_clearchat_message($message)
{
	$return = '';
	// Timeout
	if(substr($message, 0, 13) == 'ban-duration=')
	{
		// Get duration
		$pos = strpos($message, ';');
		$return .= 'Timeout for '.substr($message, 13, $pos - 13).' seconds';
	}
	// /clear
	elseif(empty($message))
	{
		$return .= 'History cleared (/clear)';
	}
	// Ban
	else
	{
		$return .= 'Ban';
	}

	// Check for reason msg
	if(($pos = strpos($message, 'ban-reason=')) !== false)
	{
		$reason_msg = trim(substr($message, $pos + 11));
		if(!empty($reason_msg))
		{
			$return .= ' for: "'.str_replace('\s', ' ', $reason_msg).'"';
		}
	}

	return $return;
}

?><!DOCTYPE html>
<html lang="en">
<head>
<title>Chat Logs</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="referrer" content="origin">
<link rel="stylesheet" type="text/css" href="css/bootstrap.css">
<link rel="stylesheet" type="text/css" href="css/style.css">
<script src="../js/jquery.min.js"></script>
<script src="js/jquery.tablesorter.js"></script>
<script src="../js/bootstrap.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
		// Click the button
		check_user_for_ban();
		// Sort the results
		$("#logstable").tablesorter({sortList: [[0,1]]} );
	} 
);

function check_user_for_ban() {
	if($('#ban-check').val() != "")
	{
		$.getJSON('https://api.twitch.tv/kraken/users/' + encodeURIComponent($('#ban-check').val()) + '?callback=?').done(function (data) {
			if (/.+is unavailable$/.test(data.message)) { // Ban Check
				form_result('fail', 'Banned');
			} else if (/.+is not available on Twitch$/.test(data.message) || /.+does not exist$/.test(data.message)) { // JTV / Nonexistant Check
				form_result('warn', 'JTV or Deleted');
			} else {
				form_result('success', 'OK');
			}
		}).fail(function () {
			form_result('warn', 'The Twitch API appears to have returned an invalid response. Twitch may be having issues at the moment.')
		})
	}
}

function form_result(type, message) {
	if (type === 'success') {
		var style = 'class="label label-success"';
	} else if (type === 'warn') {
		var style = 'class="label label-info"';
	} else {
		var style = 'class="label label-danger" style="background-color: #D9534F;"';
	}
	
	$('#ban-check-result').html('<span ' + style + '>' + message + '</span>');
}

function clear_ban_check_result() {
	$('#ban-check-result').html('');
}

function translate_popup(url, id){
	var popup_window = window.open(url, "Translate_popup_" + id, "width=865,height=475,resizable=yes");
	popup_window.focus();
	return false;
}

</script>
<style>
	body{padding-top:60px; }
	a:visited{ color:#005580;}
	#btt {
		z-index: 5;
		position: fixed;
		bottom: 5px;
		right: 5px;
		color: #fff;
	}
	$btt a:visited{ color: #fff; }
	
	.unselectable {
		-webkit-touch-callout: none;
		-webkit-user-select: none;
		-khtml-user-select: none;
		-moz-user-select: none;
		-ms-user-select: none;
		user-select: none;
	}
	
	<?php if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on') { ?>

	/* Fire's Dark Mode */

	body {
		background-color: #262626;
		color: #ccc;
	}

	.tablesorter tbody td {
		border-color: #666;
		color: #ccc !important;
		background-color: #111 !important;
	}

	table.tablesorter thead tr .headerSortDown, table.tablesorter thead tr .headerSortUp {
		border-color: #666;
		background-color: #414141 !important;
	}

	.table tbody tr.error > td {
		background-color: #470000 !important;
	}

	.table tbody tr.success > td {
		background-color: #002E06 !important;
	}

	.table tbody tr.clearchat > td {
		background-color: #797979 !important;
	}

	table.tablesorter thead tr th, table.tablesorter tfoot tr th {
		border-color: #666;
		background-color: #565656 !important;
	}

	table.tablesorter {
		background-color: #111;
	}

	a:visited {
		color: #6441A5;
	}

	a:hover {
		color: #6441A5;
	}

	a {
		color: #B9A3E3;
	}

	hr {
		border-color: #666;
	}

	input, select {
		color: #ccc !important;
		background-color: #333 !important;
		border-color: #111 !important;
	}
	
	<?php } ?>
</style>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head>
<body>
	<div class="navbar navbar-fixed-top">
		<div class="navbar-inner">
			<div class="container" style="min-width: 840px;">
				<a class="brand" href="/chatlogs/">
					Twitch Chat Logs by Root
				</a>
				
				<ul class="nav">
					<li><a href="?chat_activity_checker">Chat activity checker</a></li>
					<li><a href="feed/">Live Logs</a></li>
		      </ul>
			  <p class="navbar-text pull-right"> Current Time: <?php echo get_date_for_chatlog(date('c')); ?></p>
		  </div>
		</div>
	</div>

	<div class="container">
		<div><a href="#top" id="btt" class="btn btn-inverse">Back to top</a></div>
		<a name="top"></a>
		<form class="form-horizontal" id="form" method="GET" name="logform">
						<div class="row-fluid">
				<div class="span6">
					<div class="control-group">
						<label class="control-label" for="room">Room</label>
						<div class="controls">
							<input type="text" size="53" maxlength="255" name="room" value="<?php if(isset($_GET['room']) && !empty($_GET['room'])) echo htmlspecialchars($_GET['room'], ENT_QUOTES|ENT_HTML5);?>" /> <strong>OR</strong>
						</div>
					</div>

					<div class="control-group">
						<label class="control-label" for="username">Username</label>
						<div class="controls">
							<input type="text" size="50" maxlength="255" name="username" value="<?php if(isset($_GET['username']) && !empty($_GET['username'])) echo htmlspecialchars($_GET['username'], ENT_QUOTES|ENT_HTML5);?>" /> <strong>OR</strong>
						</div>
					</div>

					<hr />

					<div class="control-group">
						<label class="control-label" for="message">Message / Text Filter</label>
						<div class="controls">
							<input type="text" size="55" placeholder="REGEX" name="message" value="<?php if(isset($_GET['message']) && !empty($_GET['message'])) echo htmlspecialchars($_GET['message'], ENT_QUOTES|ENT_HTML5);?>" /> 
						</div>
					</div>

					<hr />

					<div class="control-group">
						<label class="control-label" for="time">Date</label>
						<div class="controls">
							<select name="table">
							<?php
foreach($chatlog_table_array as $table)
{
	if(isset($_GET['table']) && $_GET['table'] == $table)
	{
		echo '<option selected="true">';
	}
	else
	{
		echo '<option>';
	}
	echo htmlspecialchars($table, ENT_QUOTES|ENT_HTML5).'</option>'.PHP_EOL;
}
?>
							</select>
						</div>
					</div>

					<div class="control-group">
						<div class="controls">
							<button type="submit" class="btn">Search</button>
						</div>
					</div>
      			</div>

      			<div class="span6">
					<div class="control-group">
						<label class="control-label" for="all">Search All Days</label>
						<div class="controls">
							<input type="checkbox" name="all" value="all" <?php if(isset($_GET['all']) && $_GET['all'] == 'all') echo 'checked';?>/> (Username)
						</div>
					</div>
					<div class="control-group">
						<label class="control-label" for="all">Unique Names</label>
						<div class="controls">
							<input type="checkbox" name="unique_names" value="true" <?php if(isset($_GET['unique_names']) && $_GET['unique_names'] == 'true') echo 'checked';?>/> (Removes duplicate names in result)
						</div>
					</div>
					<div class="control-group">
						<label class="control-label" for="all">Only Mods</label>
						<div class="controls">
							<input type="checkbox" name="mods_only" value="true" <?php if(isset($_GET['mods_only']) && $_GET['mods_only'] == 'true') echo 'checked';?>/> (Only show messages from mods in a channel)
						</div>
					</div>
					</form> <!-- End of normal form -->
					<hr />
					
					<div class="control-group">
						<label class="control-label" for="all">Ban check</label>
						<div class="controls">
								<input type="text" id="ban-check" class="form-control" placeholder="Username" onkeypress="return event.keyCode != 13;" onChange="clear_ban_check_result();" onKeyUp="clear_ban_check_result();" onKeyDown="clear_ban_check_result();" value="<?php if(isset($_GET['username']) && !empty($_GET['username'])) echo htmlspecialchars($_GET['username'], ENT_QUOTES|ENT_HTML5);?>" /> <button type="button" id="ban-check-button" class="btn btn-default" onclick="check_user_for_ban();" title="Check">Check</button>
								<div id="ban-check-result"></div>
						</div>
					</div>

					<hr />

					<div class="control-group">
						<label class="control-label" for="all"></label>
						<div class="controls">
							<button class="btn" onClick="event.preventDefault(); $('html, body').animate({ scrollTop: $(document).height()-$(window).height() });">Scroll to bottom</button>
						</div>
					</div>

				</div>
			</div>
		
		
<table class="table tablesorter" id="logstable">
<thead>
	<tr>
		<th style="max-width:205px;width:205px;">Time Stamp</th>
		<th style="max-width:200px;width:200px;">Room</th>
		<th style="max-width:75px;width:75px;">Badge</th>
		<th style="max-width:200px;width:200px;">Username</th>
		<th style="max-width:330px;width:330px;">Message</th>
		<th style="max-width:20px;width:20px;"><abbr title="Translate">T</abbr></th>
		<?php if(in_array($current_user, $delete_whitelist_array)) echo '<th style="max-width:20px;width:20px;"></th>'.PHP_EOL; ?>
	</tr>
</thead>
<tbody>
<?php
// Here is the actual chatlogs query
// Build the acutal query
$chatlogs_query_string = '';
if(((isset($_GET['room']) && !empty($_GET['room'])) || (isset($_GET['username']) && !empty($_GET['username']))) && isset($_GET['table']) && in_array($_GET['table'], $chatlog_table_array))
{
	if(isset($_GET['all']) && $_GET['all'] == 'all' && isset($_GET['username']) && !empty($_GET['username']))
	{
		$chatlog_table_foreach_counter = 0;
		foreach($chatlog_table_array as $table)
		{
			$chatlogs_query_string .= "(SELECT `room`,`nick`,`message`,`tags_int`,`timestamp` FROM `chatlog_".$mysqli->real_escape_string($table)."` WHERE `nick` = '".$mysqli->real_escape_string($_GET['username'])."' ORDER BY `ID` DESC) UNION ALL ";
			$chatlog_table_foreach_counter = $chatlog_table_foreach_counter + 1;
			if($chatlog_table_foreach_counter >= 30)
			{
				// This limits the all lookup to the last 30 days max
				break;
			}
		}
		$chatlogs_query_string = substr($chatlogs_query_string, 0, -11);
	}
	else
	{
		$chatlogs_query_string .= 'SELECT `ID`,`room`,`nick`,`message`,`tags_int`,`timestamp` FROM `chatlog_'.$mysqli->real_escape_string($_GET['table']).'` WHERE ';
		if(isset($_GET['room']) && !empty($_GET['room']))
		{
			$chatlogs_query_string .= "`room` = '".$mysqli->real_escape_string('#'.$_GET['room'])."'";
			if(isset($_GET['mods_only']) && !empty($_GET['mods_only']))
			{
				$chatlogs_query_string .= ' AND `tags_int`&1 = 1';
			}
		}
		elseif(isset($_GET['username']) && !empty($_GET['username']))
		{
			$chatlogs_query_string .= "`nick` = '".$mysqli->real_escape_string($_GET['username'])."'";
		}
		
		if(isset($_GET['message']) && !empty($_GET['message']))
		{
			$chatlogs_query_string .= " AND `message` REGEXP '".$mysqli->real_escape_string($_GET['message'])."'";
		}
		
		if(isset($_GET['unique_names']) && $_GET['unique_names'] == 'true')
		{
			$chatlogs_query_string .= ' GROUP BY `nick`';
		}
		$chatlogs_query_string .= ' ORDER BY `ID` DESC';
	}
}
elseif(isset($_GET['message']) && !empty($_GET['message']) && isset($_GET['table']) && in_array($_GET['table'], $chatlog_table_array))
{
	$chatlogs_query_string .= 'SELECT `ID`,`room`,`nick`,`message`,`tags_int`,`timestamp` FROM `chatlog_'.$mysqli->real_escape_string($_GET['table'])."` WHERE `message` REGEXP '".$mysqli->real_escape_string($_GET['message'])."'";
	
	if(isset($_GET['unique_names']) && $_GET['unique_names'] == 'true')
	{
		$chatlogs_query_string .= ' GROUP BY `nick`';
	}
	$chatlogs_query_string .= ' ORDER BY `ID` DESC';
}


if(!empty($chatlogs_query_string))
{
	// Add an audit entry
	$mysqli->query("INSERT INTO `audits` (`action`, `action_by`, `command`) VALUES ('search', '".$mysqli->real_escape_string($current_user)."', '".$mysqli->real_escape_string($chatlogs_query_string)."')");
	// echo '<!-- '.$chatlogs_query_string.' -->'.PHP_EOL;
	$all_row_report_form_string = '';
	$mysql_query_start_time = microtime(true);
	if($result = $mysqli->query($chatlogs_query_string, MYSQLI_USE_RESULT))
	{
		$mysql_query_end_time = microtime(true);
		while($row = $result->fetch_assoc())
		{
			if(($row['tags_int'] & 128) == 128)
			{
				echo '<tr class="clearchat">';
			}
			elseif(strlen($row['room']) > 1 && strtolower(substr($row['room'], 1)) == strtolower($row['nick']))
			{
				echo '<tr class="success">';
			}
			else
			{
				echo '<tr>';
			}

			if(($row['tags_int'] & 128) == 128)
			{
				echo '<td style="max-width:205px;width:205px;">'.get_date_for_chatlog($row['timestamp']).'</td>';
				echo '<td style="max-width:200px;width:200px;"><a href="https://www-origin.twitch.tv/'.rawurlencode(substr($row['room'], 1)).'" target="_blank" rel="noreferrer">'.htmlspecialchars($row['room'], ENT_QUOTES|ENT_HTML5).'</a></td>';
			}
			else
			{
				$report_form_string = gen_report_line_string_for_message($row['timestamp'], $row['room'], $row['tags_int'], $row['nick'], $row['message']);
				// Add the report string to the big string if the search was per user
				if(isset($_GET['username']) && !empty($_GET['username']))
				{
					$all_row_report_form_string .= $report_form_string.PHP_EOL;
				}
				echo '<td style="max-width:205px;width:205px;"><a href="https://www-origin.twitch.tv/'.rawurlencode($row['nick']).'/report_form?tos_ban=true&amp;content=chat&amp;reason=spam&amp;description='.urlencode($report_form_string).'" target="_blank" rel="noreferrer">'.get_date_for_chatlog($row['timestamp']).'</a></td>';
				echo '<td style="max-width:200px;width:200px;"><a href="https://www-origin.twitch.tv/'.rawurlencode(substr($row['room'], 1)).'" target="_blank" rel="noreferrer">'.htmlspecialchars($row['room'], ENT_QUOTES|ENT_HTML5).'</a></td>';
			}
			// Tags
			echo '<td style="max-width:75px;width:75px;">';
			$tags_string = '';
			if(($row['tags_int'] & 128) == 128)
			{
				$tags_string = '<img src="clear.png" width="18" height="18" alt="[CLEARCHAT]" title="CLEARCHAT">';
			}
			else
			{
				if(strlen($row['room']) > 1 && strtolower(substr($row['room'], 1)) == strtolower($row['nick']))
				{
					$tags_string .= '<img src="//www-cdn.jtvnw.net/images/xarth/badge_broadcaster.svg" width="18" height="18" alt="[Broadcaster]" title="Broadcaster" style="background-color: #e71818;"> ';
				}
				if(isset($row['tags_int']) && !empty($row['tags_int']))
				{
					$tags_array = array();
					$tags_int = $row['tags_int'];
					if(($tags_int & 64) == 64)
					{
						// Cheer message
						$tags_array[] = 'cheer_message';
					}

					if(($tags_int & 32) == 32)
					{
						// Subscriber
						$tags_array[] = 'subscriber';
					}

					if(($tags_int & 16) == 16)
					{
						// Turbo
						$tags_array[] = 'turbo';
					}

					if(($tags_int & 8) == 8)
					{
						// Staff
						$tags_array[] = 'staff';
					}

					if(($tags_int & 4) == 4)
					{
						// Admin
						$tags_array[] = 'admin';
					}

					if(($tags_int & 2) == 2)
					{
						// Global Mod
						$tags_array[] = 'global_mod';
					}

					if(($tags_int & 1) == 1)
					{
						// Mod
						$tags_array[] = 'mod';
					}

					// Images depending on the tags
					if(in_array('mod', $tags_array))
					{
						$tags_string .= '<img src="//www-cdn.jtvnw.net/images/xarth/badge_mod.svg" width="18" height="18" alt="[Mod]" title="Mod" style="background-color: #34ae0a;"> ';
					}
					if(in_array('global_mod', $tags_array))
					{
						$tags_string .= '<img src="//www-cdn.jtvnw.net/images/xarth/badge_globalmod.svg" width="18" height="18" alt="[Global-Mod]" title="Global-Mod" style="background-color: #0c6f20;"> ';
					}
					if(in_array('admin', $tags_array))
					{
						$tags_string .= '<img src="//www-cdn.jtvnw.net/images/xarth/badge_admin.svg" width="18" height="18" alt="[Admin]" title="Admin" style="background-color: #faaf19;"> ';
					}
					if(in_array('staff', $tags_array))
					{
						$tags_string .= '<img src="//www-cdn.jtvnw.net/images/xarth/badge_staff.svg" width="18" height="18" alt="[Staff]" title="Staff" style="background-color: #200f33;"> ';
					}

					if(in_array('turbo', $tags_array))
					{
						$tags_string .= '<img src="//www-cdn.jtvnw.net/images/xarth/badge_turbo.svg" width="18" height="18" alt="[Turbo]" title="Turbo" style="background-color: #6441a5;"> ';
					}

					if(in_array('subscriber', $tags_array))
					{
						$tags_string .= '<img src="//static-cdn.jtvnw.net/jtv_user_pictures/subscriber-star.png" width="16" height="16" alt="[Subscriber]" title="Subscriber" style="background-color: #fff; border:1px solid #000;"> ';
					}

					if(in_array('cheer_message', $tags_array))
					{
						$tags_string .= '<img src="//static-cdn.jtvnw.net/bits/light/animated/red/1" width="18" height="18" alt="[Cheer-Message]" title="Cheer-Message">';
					}
				}
			}
			$tags_string = trim($tags_string);
			if(!empty($tags_string))
			{
				$tags_string = '['.$tags_string.']';
			}
			echo $tags_string;
			echo '</td>';
			// Tags - end
			echo '<td style="max-width:200px;width:200px;"><a href="https://www-origin.twitch.tv/'.rawurlencode($row['nick']).'" target="_blank" rel="noreferrer">'.htmlspecialchars($row['nick'], ENT_QUOTES|ENT_HTML5).'</a></td>';
			if(($row['tags_int'] & 128) == 128)
			{
				// Message
				echo '<td style="max-width:330px;width:330px;">'.htmlspecialchars(parse_clearchat_message($row['message']), ENT_QUOTES|ENT_HTML5).'</td>';
				// echo PHP_EOL.'<!-- '.$row['message'].' -->'.PHP_EOL;
				// Translate
				echo '<td style="max-width:20px;width:20px;" class="unselectable"></td>';
			}
			else
			{
				// Message
				echo '<td style="max-width:330px;width:330px;">'.htmlspecialchars($row['message'], ENT_QUOTES|ENT_HTML5).'</td>';
				// Translate
				echo '<td style="max-width:20px;width:20px;" class="unselectable"><a href="https://translate.google.com/#auto/en/'.rawurlencode($row['message']).'" target="_blank" rel="noreferrer" onclick="return translate_popup(this.href, '.$row['ID'].');" class="unselectable"><img src="translate.png" title="Translate" alt="" class="unselectable"></a></td>';
			}
			// Delete button for whitelisted people
			if(in_array($current_user, $delete_whitelist_array))
			{
				echo '<td style="max-width:25px;width:25px;text-align:right;align:right;"><a href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF'].'?room='.rawurlencode($_GET['room']).'&amp;username='.rawurlencode($_GET['username']).'&amp;table='.rawurlencode($_GET['table']).'&amp;delete_ID='.rawurlencode($row['ID']).'"><img src="delete.gif" title="Delete" alt=""></a></td>';
			}
			echo '</tr>'.PHP_EOL;
		}
		$result->free();
	}
}
?>
</tbody>
</table>
<?php
if(isset($all_row_report_form_string) && !empty($all_row_report_form_string))
{
	if(strlen(urlencode($all_row_report_form_string)) <= 4950)
	{
		echo '<br><a href="https://www-origin.twitch.tv/'.rawurlencode($_GET['username']).'/report_form?tos_ban=true&amp;content=chat&amp;reason=spam&amp;reason_detailed=spam_bots&amp;description='.urlencode($all_row_report_form_string).'" target="_blank" rel="noreferrer">Report using all chatlog rows</a><br>'.PHP_EOL;
	}
	else
	{
		echo '<br><a href="https://www-origin.twitch.tv/'.rawurlencode($_GET['username']).'/report_form?tos_ban=true&amp;content=chat&amp;reason=spam&amp;reason_detailed=spam_bots" target="_blank" rel="noreferrer">Report using this copy paste</a> <textarea onclick="javascript:this.focus(); this.select();" rows="4" readonly>'.htmlspecialchars($all_row_report_form_string, ENT_QUOTES|ENT_HTML5).'</textarea><br>'.PHP_EOL;
	}
}
?>
<br>
<a name="bottom"></a>
Total request time: <strong><?php echo round(microtime(true) - $script_start_time, 4); ?> sec</strong><?php if(isset($mysql_query_start_time, $mysql_query_end_time)) { ?> | Mysql query time: <strong><?php echo round($mysql_query_end_time - $mysql_query_start_time, 4); ?> sec</strong><?php } ?>
<br>
</div>
</body>
</html>
<?php
}
else
{
?><!DOCTYPE html>
<html lang="en">
<head>
<title>Chat Logs</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head>
<body>
You need to <a href="/index.php?login_redirect=chatlogs">login</a> to use this feature.<br>
</body>
</html>
<?php
}
?>