<?php
// äüö - UTF8 FTW
// Only allow including of this file
if(preg_match('/do_not_ban_management\.php/i', $_SERVER['PHP_SELF']))
{
	exit();
}

function get_date_for_added_at($unix_time)
{
	$dateTime = new DateTime(date('c', $unix_time), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	$return = $dateTime->format('Y-m-d h:i:s A T');
	return $return;
}

if(isset($_GET['history']))
{
?><!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="referrer" content="origin">
	<link id="favicon" rel="icon" type="image/x-icon" href="favicon.ico">
	<title>Twitch Desk - &quot;do_not_ban&quot; list history / changelog</title>
<style>
table {
	display: table;
	border-collapse: collapse;
	border-spacing: 2px;
	border-color: gray;
	border: gray;
	width: 85%;
}
table,th, td {
	border: 1px solid black;
}
td {
	padding: 5px;
}
.add {
    background-color: #33CC33;
} 
.del {
    background-color: #FF3300;
} 
</style>
</head>
<body>
<h2><b>&quot;do_not_ban&quot; list history / changelog:</b></h2><br>
<a href="?do_not_ban_management">Back</a><br><br>
<table>
<tr>
<td>Time</td>
<td>Action</td>
<td>Action by</td>
<td>Username</td>
<td>Reason</td>
</tr>
<?php
$handle = fopen('do_not_ban_list.log', 'rb');
if($handle)
{
	while(!feof($handle))
	{
		$line = fgets($handle);
		$json_decode_line = json_decode($line, true);
		if($json_decode_line !== NULL)
		{
			echo '<tr>';
			echo '<td>'.htmlspecialchars(get_date_for_added_at($json_decode_line['time']), ENT_QUOTES|ENT_HTML5).'</td>';
			if($json_decode_line['action'] == 'add')
			{
				echo '<td class="add">';
			}
			elseif($json_decode_line['action'] == 'del')
			{
				echo '<td class="del">';
			}
			echo htmlspecialchars($json_decode_line['action'], ENT_QUOTES|ENT_HTML5).'</td>';
			echo '<td>'.htmlspecialchars($json_decode_line['action_by'], ENT_QUOTES|ENT_HTML5).'</td>';
			echo '<td>'.htmlspecialchars($json_decode_line['username'], ENT_QUOTES|ENT_HTML5).'</td>';
			echo '<td>'.htmlspecialchars($json_decode_line['reason'], ENT_QUOTES|ENT_HTML5).'</td>';
			echo '</tr>'.PHP_EOL;
		}
	}
}
else
{
	echo 'Error reading the log file ...'.PHP_EOL;
}
?>
</table>
<br><br>
</body>
</html>
<?php
	exit();
}

$action_notices = '';
if($_SERVER['REQUEST_METHOD'] == 'POST')
{
	// Do actions here
	// Check if all parts are here
	if(isset($_POST['username']) && !empty($_POST['username']) && isset($_POST['action']) && !empty($_POST['action']) && isset($_POST['reason']) && !empty($_POST['reason']))
	{
		if(isset($_POST['csrf_token']) && validate_csrf_token($_POST['csrf_token']) === true)
		{
			// Load current json file
			$json_file_content = file_get_contents('do_not_ban_list.json');
			if($json_file_content === false)
			{
				echo 'Error trying to read do not ban list file!'.PHP_EOL;
				exit();
			}
			$json_decode = json_decode($json_file_content, true);
			if($json_decode === NULL)
			{
				echo 'Data in the do not ban list file is invalid!'.PHP_EOL;
				exit();
			}
			unset($json_file_content);


			if($_POST['action'] == 'add')
			{
				$post_username = strtolower(trim($_POST['username']));
				if(!isset($json_decode[$post_username]) && !empty($post_username))
				{
					$post_reason = '';
					if(isset($_POST['reason']) && !empty(trim($_POST['reason']))) $post_reason = trim($_POST['reason']);
					$json_decode[$post_username] = array('reason' => $post_reason, 'added_at' => time(), 'added_by' => $_SESSION['user']['username']);
					// Sort the list by names
					// ksort($json_decode);
					file_put_contents('do_not_ban_list.json', json_encode($json_decode), LOCK_EX);
					unset($json_decode);
					$action_notices .= 'Added "'.htmlspecialchars($post_username, ENT_QUOTES|ENT_HTML5).'" with the reason: "'.htmlspecialchars($post_reason, ENT_QUOTES|ENT_HTML5).'" to the do not ban list.<br>'.PHP_EOL;
					// Add log entry
					file_put_contents('do_not_ban_list.log', json_encode(array('time' => time(), 'action' => 'add', 'action_by' => $_SESSION['user']['username'], 'action_by_ID' => $_SESSION['user']['desk_ID'], 'username' => $post_username, 'reason' => $post_reason)).PHP_EOL, FILE_APPEND | LOCK_EX);
				}

			}
			elseif($_POST['action'] == 'del')
			{
				$post_username = strtolower(trim(rawurldecode($_POST['username'])));
				if(isset($json_decode[$post_username]) && !empty($post_username))
				{
					unset($json_decode[$post_username]);
					file_put_contents('do_not_ban_list.json', json_encode($json_decode), LOCK_EX);
					unset($json_decode);
					$action_notices .= 'Removed "'.htmlspecialchars($post_username, ENT_QUOTES|ENT_HTML5).'" from the do not ban list.<br>'.PHP_EOL;
					// Add log entry
					$post_reason = '';
					if(isset($_POST['reason']) && !empty(trim($_POST['reason']))) $post_reason = trim($_POST['reason']);
					file_put_contents('do_not_ban_list.log', json_encode(array('time' => time(), 'action' => 'del', 'action_by' => $_SESSION['user']['username'], 'action_by_ID' => $_SESSION['user']['desk_ID'], 'username' => $post_username, 'reason' => $post_reason)).PHP_EOL, FILE_APPEND | LOCK_EX);
				}
			}
		}
		else
		{
			header('HTTP/1.1 401 Unauthorized', true, 401);
			echo 'Could not verify your request';
			exit();
		}
	}
}


// Load current json file
$json_file_content = file_get_contents('do_not_ban_list.json');
if($json_file_content === false)
{
	echo 'Error trying to read do not ban list file!'.PHP_EOL;
	exit();
}
$json_decode = json_decode($json_file_content, true);
if($json_decode === NULL)
{
	echo 'Data in the do not ban list file is invalid!'.PHP_EOL;
	exit();
}
unset($json_file_content);

?><!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="referrer" content="origin">
	<link id="favicon" rel="icon" type="image/x-icon" href="favicon.ico">
	<title>Twitch Desk - &quot;do_not_ban&quot; list management</title>
<style>
table {
	display: table;
	border-collapse: collapse;
	border-spacing: 2px;
	border-color: gray;
	border: gray;
	width: 85%;
}
table,th, td {
	border: 1px solid black;
}
td {
	padding: 5px;
}
</style>
</head>
<body>
<h2><b>Current &quot;do_not_ban&quot; list:</b></h2><br>
<a href="?do_not_ban_management&amp;history">History / Changelog</a><br><br>
<?php if(!empty($action_notices)) echo $action_notices.'<br>'.PHP_EOL ?>
<table>
<tr>
<td>Username</td>
<td>Reason (Not to ban for)</td>
<td>Added at</td>
<td>Added by</td>
<td></td>
</tr>
<?php
if(is_array($json_decode) && count($json_decode) > 0)
{
	foreach($json_decode as $username => $entry)
	{
		echo '<tr>';
		echo '<td>'.htmlspecialchars($username, ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($entry['reason'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars(get_date_for_added_at($entry['added_at']), ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td>'.htmlspecialchars($entry['added_by'], ENT_QUOTES|ENT_HTML5).'</td>';
		echo '<td><form action="" method="post" autocomplete="off"><input type="hidden" name="action" value="del"><input type="hidden" name="csrf_token" value="'.$_SESSION['csrf_token'].'"><input type="hidden" name="username" value="'.rawurlencode($username).'"><input type="text" name="reason" value="" placeholder="Remove reason" size="20" required><input type="submit" value="Delete"></form></td>';
		echo '</tr>'.PHP_EOL;
	}
}
?>
<tr>
<form action="" method="post" autocomplete="off">
	<input type="hidden" name="csrf_token" value="<?php if(isset($_SESSION['csrf_token']) && !empty($_SESSION['csrf_token'])) echo $_SESSION['csrf_token']; ?>">
	<input type="hidden" name="action" value="add">
	<td><input type="text" name="username" value="" placeholder="Username" size="25" autofocus required></td>
	<td><input type="text" name="reason" value="" placeholder="Reason" size="25" required></td>
	<td></td>
	<td></td>
	<td><input type="submit" value="Add"></td>
</form>
</tr>
</table>
<br><br>
</body>
</html>