<?php
// äüö - UTF8 FTW
$script_start_time = microtime(true);
require_once __DIR__ . '/RedisSessionHandler.php';
$sessHandler = new RedisSessionHandler();
session_set_save_handler($sessHandler);
session_start();
$session_start_time = microtime(true) - $script_start_time; 
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
header('Pragma: no-cache');
$http_or_https = '';
$warning_string = '';
$curl_request_info_string = '';
$curl_error_string = '';
$global_api_request_time = 0;
if(isset($_SERVER['HTTP_X_SCHEME']) && !empty($_SERVER['HTTP_X_SCHEME']))
{
	if($_SERVER['HTTP_X_SCHEME'] == 'https')
	{
		$http_or_https = 'https';
	}
	else
	{
		$http_or_https = 'http';
	}
}
elseif(!empty($_SERVER['HTTPS']))
{
	$http_or_https = 'https';
}
else
{
	$http_or_https = 'http';
}

require_once '_functions.php';


// CSRF Token
if(!isset($_SESSION['csrf_token']) || empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = gen_csrf_token();


// Do_Not_Ban management
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['do_not_ban_management']))
{
	// We don't change anything in the SESSION variable so we can close it
	session_write_close();
	require_once 'do_not_ban_management.php';
	exit();
}

// Target user whisper report history
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['target_user_whisper_report_history']))
{
	// We don't change anything in the SESSION variable so we can close it
	session_write_close();
	require_once 'target_user_whisper_report_history.php';
	exit();
}

// Partnerconduct report
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['partnerconduct_report']))
{
	// We don't change anything in the SESSION variable so we can close it
	session_write_close();
	require_once 'partnerconduct_report.php';
	exit();
}

// Session stats history
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['session_stats_history']))
{
	// We don't change anything in the SESSION variable so we can close it
	session_write_close();
	require_once 'session_stats_history.php';
	exit();
}

// Clips overview
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['clips_overview']))
{
	// We don't change anything in the SESSION variable so we can close it
	session_write_close();
	require_once 'clips_overview.php';
	exit();
}


// Check for resolves which can be removed
// Subject array
if(!isset($_SESSION['auto_resolve_by_subject_array'])) $_SESSION['auto_resolve_by_subject_array'] = array();
if(isset($_SESSION['auto_resolve_by_subject_array']) && count($_SESSION['auto_resolve_by_subject_array']) > 0)
{
	foreach($_SESSION['auto_resolve_by_subject_array'] as $subject => $resolve_until)
	{
		if($resolve_until !== 0)
		{
			$time_until_remove = $resolve_until - time();
			if($time_until_remove <= 0)
			{
				unset($_SESSION['auto_resolve_by_subject_array'][$subject]);
			}
		}
	}
}

// Reporter array
if(!isset($_SESSION['auto_resolve_by_reporter_array'])) $_SESSION['auto_resolve_by_reporter_array'] = array();
if(isset($_SESSION['auto_resolve_by_reporter_array']) && count($_SESSION['auto_resolve_by_reporter_array']) > 0)
{
	foreach($_SESSION['auto_resolve_by_reporter_array'] as $reporter => $resolve_until)
	{
		if($resolve_until !== 0)
		{
			$time_until_remove = $resolve_until - time();
			if($time_until_remove <= 0)
			{
				unset($_SESSION['auto_resolve_by_reporter_array'][$reporter]);
			}
		}
	}
}

// "Hold" array
if(!isset($_SESSION['hold_caseID_array'])) $_SESSION['hold_caseID_array'] = array();
if(isset($_SESSION['hold_caseID_array']) && count($_SESSION['hold_caseID_array']) > 0)
{
	foreach($_SESSION['hold_caseID_array'] as $caseID => $hold)
	{
		// Old type hold conversion
		if(!is_array($hold))
		{
			$old_hold_var = $hold;
			$hold = array();
			$hold['hold_until'] = $old_hold_var;
			unset($old_hold_var);
		}
		if($hold['hold_until'] !== 0)
		{
			$time_until_remove = $hold['hold_until'] - time();
			if($time_until_remove <= 0)
			{
				unset($_SESSION['hold_caseID_array'][$caseID]);
			}
		}
	}
}

// "Do not autoresolve" array
if(!isset($_SESSION['do_not_autoresolve_by_reporter_array'])) $_SESSION['do_not_autoresolve_by_reporter_array'] = array();
if(isset($_SESSION['do_not_autoresolve_by_reporter_array']) && count($_SESSION['do_not_autoresolve_by_reporter_array']) > 0)
{
	foreach($_SESSION['do_not_autoresolve_by_reporter_array'] as $reporter => $resolve_until)
	{
		if($resolve_until !== 0)
		{
			$time_until_remove = $resolve_until - time();
			if($time_until_remove <= 0)
			{
				unset($_SESSION['do_not_autoresolve_by_reporter_array'][$reporter]);
			}
		}
	}
}


// Reset the TTL of the distributed cases redis key if enabled in this session
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && $use_redis === true && $offer_case_distribution === true && isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
{
	renew_redis_key_for_case_distribution_user();
}

// Get last modified time for case distribution
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true)
{
	$case_distribution_last_modified = get_redis_distribution_last_modified();
	header('X-MultiMode: '.$case_distribution_last_modified, true);
}


// Reset session stats
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && $show_session_stats === true && isset($_GET['reset_stats']))
{
	unset($_SESSION['session_stats']);
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}

// Session stats
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && $show_session_stats === true)
{
	// Create the empty array structure if it doesn't exist yet
	if(!isset($_SESSION['session_stats']))
	{
		$_SESSION['session_stats'] = array(
			'cases_overall' => array(),
			'report_cases' => array(),
			'whisper_cases' => array(),
			'channel_feed_cases' => array(),
			'clip_cases' => array(),
			'duplicate_cases' => array(),
			'auto_resolved_subject_cases' => array(),
			'auto_resolved_reporter_cases' => array(),
			'auto_resolved_own_tos_cases' => array(),
			'auto_resolved_by_age_cases' => array(),
			'resolved_cases' => array(),
			'TOSd_cases' => array(),
			'staff_assigned_pm_check_cases' => array(),
			'sessionID' => gen_csrf_token(32),
			'session_start_time' => time(),
			'session_end_time' => 0
		);
	}
}

// Register event so we can log the current session stats to DB (if the flag is enabled)
if($enable_session_logging_to_DB === true && $show_session_stats === true)
{
	register_shutdown_function('log_session_stats_to_db');
}


// Notification sound
if(isset($_GET['sound']) && $_GET['sound'] == 'on')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		setcookie('sound', 'on', time()+60*60*24*365);
		$_SESSION['play_sound_on_next_load'] = true;
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_GET['sound']) && $_GET['sound'] == 'off')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		setcookie('sound', 'off', time()+60*60*24*365);
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// Whisper reports
if(isset($_GET['whisper_reports']) && $_GET['whisper_reports'] == 'on')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		$_SESSION['whisper_reports_disabled'] = false;
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_GET['whisper_reports']) && $_GET['whisper_reports'] == 'off')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		$_SESSION['whisper_reports_disabled'] = true;
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// Sound volume
if(isset($_GET['sound_volume']) && is_numeric($_GET['sound_volume']) && $_GET['sound_volume'] >= 0 && $_GET['sound_volume'] <= 100)
{
	setcookie('sound_volume', $_GET['sound_volume'], time()+60*60*24*365);
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	$_SESSION['play_sound_on_next_load'] = true;
	exit();
}

// Fade speed
if(isset($_GET['fade_speed']) && is_numeric($_GET['fade_speed']) && $_GET['fade_speed'] >= 0 && $_GET['fade_speed'] <= 5000)
{
	setcookie('fade_speed', $_GET['fade_speed'], time()+60*60*24*365);
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}

// Auto load desk history
if(isset($_GET['auto_load_tos_history']) && $_GET['auto_load_tos_history'] == 'true')
{
	setcookie('auto_load_tos_history', 'true', time()+60*60*24*365);
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}
elseif(isset($_GET['auto_load_tos_history']) && $_GET['auto_load_tos_history'] == 'false')
{
	setcookie('auto_load_tos_history', 'false', time()+60*60*24*365);
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}

// Dark mode
if(isset($_GET['dark_mode']) && $_GET['dark_mode'] == 'on')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		setcookie('dark_mode', 'on', time()+60*60*24*365);
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_GET['dark_mode']) && $_GET['dark_mode'] == 'off')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		setcookie('dark_mode', 'off', time()+60*60*24*365);
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// Fade resolved cases
if(isset($_GET['fade_resolved']) && $_GET['fade_resolved'] == 'on')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		setcookie('fade_resolved', 'on', time()+60*60*24*365);
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_GET['fade_resolved']) && $_GET['fade_resolved'] == 'off')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		setcookie('fade_resolved', 'off', time()+60*60*24*365);
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// Root Chatlogs
if(isset($_GET['root_chatlogs']) && $_GET['root_chatlogs'] == 'true')
{
	setcookie('root_chatlogs', 'true', time()+60*60*24*365);
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}
elseif(isset($_GET['root_chatlogs']) && $_GET['root_chatlogs'] == 'false')
{
	setcookie('root_chatlogs', 'false', time()+60*60*24*365);
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}

// Auto resolve TOS'd channels
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['auto_resolve_TOSd']) && $_GET['auto_resolve_TOSd'] == 'true')
{
	$_SESSION['auto_resolve_TOSd_channels'] = true;
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}
elseif(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['auto_resolve_TOSd']) && $_GET['auto_resolve_TOSd'] == 'false')
{
	$_SESSION['auto_resolve_TOSd_channels'] = false;
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}

// Debug info
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['show_debug']) && $_GET['show_debug'] == 'true')
{
	$_SESSION['show_debug'] = true;
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}
elseif(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['show_debug']) && $_GET['show_debug'] == 'false')
{
	$_SESSION['show_debug'] = false;
	header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	exit();
}

// Case distribution
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && $GLOBALS['offer_case_distribution'] === true && isset($_GET['enable_case_distribution']) && $_GET['enable_case_distribution'] == 'true')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		$_SESSION['case_distribution_enabled'] = true;
		// Reset distribution weight to the default value
		set_redis_distribution_current_user_weight();
		update_redis_key_for_case_distribution_last_modified();
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['enable_case_distribution']) && $_GET['enable_case_distribution'] == 'false')
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		$_SESSION['case_distribution_enabled'] = false;
		remove_redis_entry_for_multi_user_distribution();
		update_redis_key_for_case_distribution_last_modified();
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// Case distribution weight
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && $GLOBALS['offer_case_distribution'] === true && isset($_GET['set_distribution_weight']) && is_numeric($_GET['set_distribution_weight']) && intval($_GET['set_distribution_weight']) > 0 && intval($_GET['set_distribution_weight']) <= 100)
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		set_redis_distribution_current_user_weight(intval($_GET['set_distribution_weight']));
		update_redis_key_for_case_distribution_last_modified();
		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// auto resolve subject array
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['auto_resolve_subject_add']) && !empty($_GET['auto_resolve_subject_add']))
{
	if(!isset($_SESSION['auto_resolve_by_subject_array']))
	{
		$_SESSION['auto_resolve_by_subject_array'] = array();
	}
	if(!isset($_SESSION['already_TOSd_array']))
	{
		$_SESSION['already_TOSd_array'] = array();
	}

	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		$resolve_until = 0;
		if(isset($_GET['resolve_time']) && !empty($_GET['resolve_time']) && is_numeric($_GET['resolve_time']))
		{
			// Limit autoresolve time to the max a user has links to
			if($_GET['resolve_time'] > 900 && !in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$_GET['resolve_time'] = 900;
			}
			$resolve_until = time() + intval($_GET['resolve_time']);
		}

		// Only add it to the array if it's a valid option for this user
		if(($resolve_until > 0 && (count_not_TOSd_autoresolves_by_subject() < 10 || isset($_SESSION['already_TOSd_array'][$_GET['auto_resolve_subject_add']]))) || in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
		{
			$_SESSION['auto_resolve_by_subject_array'][$_GET['auto_resolve_subject_add']] = $resolve_until;
		}
		else
		{
			if(!isset($_SESSION['error_msg'])) $_SESSION['error_msg'] = '';
			if($resolve_until == 0)
			{
				$_SESSION['error_msg'] .= htmlspecialchars('You need to set a time limit for your autoresolve against "'.$_GET['auto_resolve_subject_add'].'"', ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
			}
			else
			{
				$_SESSION['error_msg'] .= htmlspecialchars('You can only auto resolve 10 subjects (channel) simultaneously (Thanks Ryan). Please remove an autoresolve before you try to add a new one.', ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
			}
		}

		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['auto_resolve_subject_remove']) && !empty($_GET['auto_resolve_subject_remove']))
{
	if(!isset($_SESSION['auto_resolve_by_subject_array']))
	{
		$_SESSION['auto_resolve_by_subject_array'] = array();
	}

	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		if(isset($_SESSION['auto_resolve_by_subject_array'][$_GET['auto_resolve_subject_remove']])) unset($_SESSION['auto_resolve_by_subject_array'][$_GET['auto_resolve_subject_remove']]);

		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// auto resolve reporter array
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['auto_resolve_reporter_add']) && !empty($_GET['auto_resolve_reporter_add']))
{
	if(!isset($_SESSION['auto_resolve_by_reporter_array']))
	{
		$_SESSION['auto_resolve_by_reporter_array'] = array();
	}

	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		$resolve_until = 0;
		if(isset($_GET['resolve_time']) && !empty($_GET['resolve_time']) && is_numeric($_GET['resolve_time']))
		{
			// Limit autoresolve time to the max a user has links to
			if($_GET['resolve_time'] > 900 && !in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$_GET['resolve_time'] = 900;
			}
			$resolve_until = time() + intval($_GET['resolve_time']);
		}

		// Only add it to the array if it's a valid option for this user
		if(($resolve_until > 0 && count($_SESSION['auto_resolve_by_reporter_array']) < 10) || in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
		{
			$_SESSION['auto_resolve_by_reporter_array'][$_GET['auto_resolve_reporter_add']] = $resolve_until;
		}
		else
		{
			if(!isset($_SESSION['error_msg'])) $_SESSION['error_msg'] = '';
			if($resolve_until == 0)
			{
				$_SESSION['error_msg'] .= htmlspecialchars('You need to set a time limit for your autoresolve against "'.$_GET['auto_resolve_reporter_add'].'"', ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
			}
			else
			{
				$_SESSION['error_msg'] .= htmlspecialchars('You can only auto resolve 10 reporter simultaneously (Thanks Ryan). Please remove an autoresolve before you try to add a new one.', ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
			}
		}

		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['auto_resolve_reporter_remove']) && !empty($_GET['auto_resolve_reporter_remove']))
{
	if(!isset($_SESSION['auto_resolve_by_reporter_array']))
	{
		$_SESSION['auto_resolve_by_reporter_array'] = array();
	}

	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		if(isset($_SESSION['auto_resolve_by_reporter_array'][$_GET['auto_resolve_reporter_remove']])) unset($_SESSION['auto_resolve_by_reporter_array'][$_GET['auto_resolve_reporter_remove']]);

		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// hold caseID array
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['hold_caseID_add']) && !empty($_GET['hold_caseID_add']))
{
	if(!isset($_SESSION['hold_caseID_array']))
	{
		$_SESSION['hold_caseID_array'] = array();
	}

	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		$hold_until = 0;
		if(isset($_GET['hold_time']) && !empty($_GET['hold_time']) && is_numeric($_GET['hold_time']))
		{
			// Limit autoresolve time to the max a user has links to
			if($_GET['hold_time'] > 3600 && !in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
			{
				$_GET['hold_time'] = 3600;
			}
			$hold_until = time() + intval($_GET['hold_time']);
		}

		// Only add it to the array if it's a valid option for this user
		if($hold_until > 0 || in_array($_SESSION['user']['desk_ID'], array(21812684 /* CommanderRoot */)))
		{
			$_SESSION['hold_caseID_array'][$_GET['hold_caseID_add']]['hold_until'] = $hold_until;
			if(isset($_GET['hold_subject']) && !empty($_GET['hold_subject']))
			{
				$_SESSION['hold_caseID_array'][$_GET['hold_caseID_add']]['subject'] = $_GET['hold_subject'];
			}
		}
		else
		{
			if(!isset($_SESSION['error_msg'])) $_SESSION['error_msg'] = '';
			if($hold_until == 0)
			{
				$_SESSION['error_msg'] .= htmlspecialchars('You need to set a time limit for the hold against case '.$_GET['hold_caseID_add'], ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
			}
			else
			{
				// $_SESSION['error_msg'] .= htmlspecialchars('You can only hold 10 cases simultaneously (Thanks Ryan). Please remove a hold before you try to add a new one.', ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
			}
		}

		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['hold_caseID_remove']) && !empty($_GET['hold_caseID_remove']))
{
	if(!isset($_SESSION['hold_caseID_array']))
	{
		$_SESSION['hold_caseID_array'] = array();
	}

	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		if(isset($_SESSION['hold_caseID_array'][$_GET['hold_caseID_remove']])) unset($_SESSION['hold_caseID_array'][$_GET['hold_caseID_remove']]);

		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// "do not autoresolve reporter" array
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['do_not_autoresolve_reporter_add']) && !empty(trim($_GET['do_not_autoresolve_reporter_add'])))
{
	if(!isset($_SESSION['do_not_autoresolve_by_reporter_array']))
	{
		$_SESSION['do_not_autoresolve_by_reporter_array'] = array();
	}

	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		$resolve_until = 0;
		if(isset($_GET['resolve_time']) && !empty($_GET['resolve_time']) && is_numeric($_GET['resolve_time']))
		{
			$resolve_until = time() + intval($_GET['resolve_time']);
		}

		// Add to the array
		$_SESSION['do_not_autoresolve_by_reporter_array'][trim(mb_strtolower($_GET['do_not_autoresolve_reporter_add']))] = $resolve_until;

		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
elseif(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['do_not_autoresolve_reporter_remove']) && !empty($_GET['do_not_autoresolve_reporter_remove']))
{
	if(!isset($_SESSION['do_not_autoresolve_by_reporter_array']))
	{
		$_SESSION['do_not_autoresolve_by_reporter_array'] = array();
	}

	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		if(isset($_SESSION['do_not_autoresolve_by_reporter_array'][$_GET['do_not_autoresolve_reporter_remove']])) unset($_SESSION['do_not_autoresolve_by_reporter_array'][$_GET['do_not_autoresolve_reporter_remove']]);

		header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'], true, 302);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// Logout
if(isset($_GET['logout']))
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		if(isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
		{
			remove_redis_entry_for_multi_user_distribution();
			update_redis_key_for_case_distribution_last_modified();
		}

		// Log the final session stats to the DB (if enabled)
		if($enable_session_logging_to_DB === true && $show_session_stats === true)
		{
			$_SESSION['session_stats']['session_end_time'] = time();
			log_session_stats_to_db();
		}

		do_logout();
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

// Case update stuff --------------------------------------------------------------------------------------------------------------------------------------------------------------
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['assign_and_resolve']) && !empty($_GET['assign_and_resolve']))
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		if($show_session_stats === false)
		{
			// We don't change anything in the session so we can close writes here
			session_write_close();
		}
		if(isset($_GET['with_label']) && !empty($_GET['with_label']))
		{
			$resolve_label_array = NULL;
			if($_GET['with_label'] == 'whisper')
			{
				$resolve_label_array = array('Whisper Report');
			}
			// Resolve and add the label
			do_assign_and_resolve($_GET['assign_and_resolve'], false, $resolve_label_array);
		}
		else
		{
			// Plain resolve without adding a label
			do_assign_and_resolve($_GET['assign_and_resolve']);
		}
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['macro_global_tosed']) && !empty($_GET['macro_global_tosed']))
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		do_macro_global_tosed($_GET['macro_global_tosed']);
		if(!isset($_SESSION['already_TOSd_array']))
		{
			$_SESSION['already_TOSd_array'] = array();
		}
		if(isset($_GET['TOSd_subject']) && !empty($_GET['TOSd_subject']) && !isset($_SESSION['already_TOSd_array'][$_GET['TOSd_subject']]))
		{
			// Add the subject to the already TOS'd list
			$_SESSION['already_TOSd_array'][$_GET['TOSd_subject']] = true;
		}
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['assign_to_staff_pm_check']) && !empty($_GET['assign_to_staff_pm_check']))
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		do_assign_to_staff_for_pm_check($_GET['assign_to_staff_pm_check']);
		if(!isset($_SESSION['already_Staffed_array']))
		{
			$_SESSION['already_Staffed_array'] = array();
		}
		if(isset($_GET['Staffed_subject']) && !empty($_GET['Staffed_subject']) && !in_array($_GET['Staffed_subject'], $_SESSION['already_Staffed_array']))
		{
			// Add the subject to the already TOS'd list
			$_SESSION['already_Staffed_array'][] = $_GET['Staffed_subject'];
		}
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}

if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['assign_to_staff_escalation']) && !empty($_GET['assign_to_staff_escalation']))
{
	if(isset($_GET['csrf_token']) && validate_csrf_token($_GET['csrf_token']) === true)
	{
		do_assign_to_staff_for_escalation($_GET['assign_to_staff_escalation']);
	}
	else
	{
		header('HTTP/1.1 401 Unauthorized', true, 401);
		echo 'Could not verify your request';
	}
	exit();
}
// ------------------------------------------------------------------------------------------------------------------

// Load notes -------------------------------------------------------------------------------------------------------
if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_GET['load_desk_notes']) && !empty($_GET['load_desk_notes']))
{
	// We don't change anything in the session so we can close writes here
	session_write_close();
	echo load_desk_notes($_GET['load_desk_notes']);
	exit();
}
// ------------------------------------------------------------------------------------------------------------------


if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true)
{
	// Normal script
	// Get open cases
	$open_cases_overview = get_new_cases_overview();
	if(count($open_cases_overview) > 0)
	{
		// print_r($open_cases_overview);
		$open_full_cases = get_full_open_cases($open_cases_overview);
		// print_r($open_full_cases);
		$cases_html_output = '';

		if(count($open_full_cases) > 0)
		{
			if(isset($_COOKIE['sound']) && $_COOKIE['sound'] == 'on' && (!isset($_SESSION['play_sound_on_next_load']) || $_SESSION['play_sound_on_next_load'] === true))
			{
				if(!isset($new_case_notification_string))
				{
					$new_case_notification_string = '';
				}
				if(isset($_COOKIE['sound_volume']) && is_numeric($_COOKIE['sound_volume']) && $_COOKIE['sound_volume'] >= 0 && $_COOKIE['sound_volume'] <= 100)
				{
					$case_notification_autoplay_sound = '';
				}
				else
				{
					$case_notification_autoplay_sound = ' autoplay';
				}
				$new_case_notification_string .= '<audio id="new_case_notification_sound"'.$case_notification_autoplay_sound.'><source src="';
				if(in_array($_SESSION['user']['desk_ID'], array(21812873 /* Itaku */)))
				{
					$new_case_notification_string .= 'alarm_itaku.mp3';
				}
				elseif(in_array($_SESSION['user']['desk_ID'], array(21812838 /* Sammy */)))
				{
					$new_case_notification_string .= 'alarm_sammy.mp3';
				}
				else
				{
					// Default notification mp3
					$new_case_notification_string .= 'alarm.mp3';
				}
				$new_case_notification_string .= '" type="audio/mpeg"></audio>'.PHP_EOL;
			}

			$cases_html_output .= gen_html_output_for_cases($open_full_cases);
			$_SESSION['play_sound_on_next_load'] = false;
		}
		else
		{
			$cases_html_output = 'Currently there are no new or open unassigned cases! (Page refreshes every 10 seconds)<br><hr>'.PHP_EOL;
			$cases_html_output .= '<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 10000);</script>'.PHP_EOL;
			$_SESSION['play_sound_on_next_load'] = true;
			$_SESSION['caseMessage_cache_array'] = array();
		}
	}
	else
	{
		$cases_html_output = 'Currently there are no new or open unassigned cases! (Page refreshes every 10 seconds)<br><hr>'.PHP_EOL;
		$cases_html_output .= '<script type="text/javascript">setTimeout(function () { window.location.reload(); }, 10000);</script>'.PHP_EOL;
		$_SESSION['play_sound_on_next_load'] = true;
		$_SESSION['caseMessage_cache_array'] = array();
		// exit();
	}

	// Send the HTTP2 preload / push headers
	if(headers_sent() === false && false) {
		header('Link: </css/bootstrap.css>; rel=prefetch; as=stylesheet', false);
		if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on') header('Link: </css/darkmode.css>; rel=prefetch; as=stylesheet', false);
		header('Link: </js/jquery.min.js>; rel=prefetch', false);
		header('Link: </js/general.js>; rel=prefetch', false);
		header('Link: </js/moment.min.js>; rel=prefetch', false);
		header('Link: </fonts/glyphicons-halflings-regular.woff>; rel=prefetch', false);
		if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on') header('Link: </js/fire_reloadv3.js>; rel=prefetch', false);
		header('Link: </js/bootstrap.min.js>; rel=prefetch', false);
		// Better dropdown menu
		header('Link: </css/dropdowns-enhancement.css>; rel=prefetch; as=stylesheet', false);
		header('Link: </js/dropdowns-enhancement.js>; rel=prefetch', false);
		header('Link: </js/bootbox.min.js>; rel=prefetch', false);
	}

?><!DOCTYPE html>
<html lang="en">
  <head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="referrer" content="origin">
	<link id="favicon" rel="icon" type="image/x-icon" href="favicon.ico">
	<title>(<?php if(isset($open_full_cases)){ echo count($open_full_cases); } else { echo '0'; } ?>) Twitch Desk - <?php echo $_SESSION['user']['username']; ?></title>
	<link href="css/bootstrap.css" rel="stylesheet">
<?php if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on') echo '	<link href="css/darkmode.css" rel="stylesheet">'.PHP_EOL; ?>
	<!-- Better dropdown menus -->
	<link href="css/dropdowns-enhancement.css" rel="stylesheet">
	<script type="text/javascript" src="js/jquery.min.js"></script>
	<script type="text/javascript" src="js/general.js"></script>
	<script type="text/javascript" src="js/moment.min.js"></script>
<script type="text/javascript">
<!--
"use strict";
var case_counter = <?php if(isset($open_full_cases)){ echo count($open_full_cases); } else { echo '0'; } ?>;
var auto_load_tos_history = <?php if(isset($_COOKIE['auto_load_tos_history']) && $_COOKIE['auto_load_tos_history'] == 'false') { echo 'false'; } else { echo 'true'; } ?>;
var auto_resolve_TOSd_channels = <?php if(isset($_SESSION['auto_resolve_TOSd_channels']) && $_SESSION['auto_resolve_TOSd_channels'] === true) { echo 'true'; } else { echo 'false'; } ?>;
var fade_on_resolve_enabled = <?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on') { echo 'true'; } else { echo 'false'; } ?>;
var case_distribution_last_modified = <?php echo $case_distribution_last_modified; ?>;
var stream_preview_image_request_cache = [];
var csrf_token = "<?php if(isset($_SESSION['csrf_token']) && !empty($_SESSION['csrf_token'])) echo $_SESSION['csrf_token']; ?>";
var twitch_oauth_client_id = "m5xvoc1c72mnurm5wi5lmrvz7xnjz0d";

function assign_and_resolve(case_id, add_new_after_done) {
	var add_new_after_done = typeof add_new_after_done !== 'undefined' ? add_new_after_done : true;
	$.ajax({url:"<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?assign_and_resolve=" + case_id + "&csrf_token=" + csrf_token,
		type: "GET",
		cache: false,
		success:function(result, textStatus, jqXHR){
			check_case_distribution_last_update_difference(jqXHR.getResponseHeader("X-MultiMode"));
			<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
			$("#assign_and_resolve_" + case_id).html(result);
			case_counter = case_counter - 1;
			<?php } ?>
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
			check_for_reload();
		},
		error:function(jqXHR, textStatus, errorThrown){
			// Try again
			$("#assign_and_resolve_" + case_id).html(errorThrown + '... Try again');
			$("#assign_and_resolve_" + case_id).removeAttr('disabled');
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
		},
	});
	<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
	$("#assign_and_resolve_" + case_id).html('Updating ...');
	$("#assign_and_resolve_" + case_id).attr("disabled", "disabled");
	// Disable other buttons
	$("#assign_and_resolve_with_label_" + case_id).attr("disabled", "disabled");
	$("#macro_global_tosed_" + case_id).attr("disabled", "disabled");
	$("#assign_to_staff_" + case_id).attr("disabled", "disabled");
	// Remove the stream preview on case resolve
	if($("#stream_preview_" + case_id).html().length > 0)
	{
		$("#stream_preview_" + case_id).html('');
	}
	<?php } ?>
	fadeOut_case(case_id, add_new_after_done);
}
function assign_and_resolve_with_label(case_id, label) {
	$.ajax({url:"<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?assign_and_resolve=" + case_id + "&with_label=" + label + "&csrf_token=" + csrf_token,
		type: "GET",
		cache: false,
		success:function(result, textStatus, jqXHR){
			check_case_distribution_last_update_difference(jqXHR.getResponseHeader("X-MultiMode"));
			<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
			$("#assign_and_resolve_with_label_" + case_id).html(result);
			case_counter = case_counter - 1;
			<?php } ?>
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
			check_for_reload();
		},
		error:function(jqXHR, textStatus, errorThrown){
			// Try again
			$("#assign_and_resolve_with_label_" + case_id).html(errorThrown + '... Try again');
			$("#assign_and_resolve_with_label_" + case_id).removeAttr('disabled');
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
		},
	});
	<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
	$("#assign_and_resolve_with_label_" + case_id).html('Updating ...');
	$("#assign_and_resolve_with_label_" + case_id).attr("disabled", "disabled");
	// Disable other buttons
	$("#assign_and_resolve_" + case_id).attr("disabled", "disabled");
	$("#macro_global_tosed_" + case_id).attr("disabled", "disabled");
	$("#assign_to_staff_" + case_id).attr("disabled", "disabled");
	// Remove the stream preview on case resolve
	if($("#stream_preview_" + case_id).html().length > 0)
	{
		$("#stream_preview_" + case_id).html('');
	}
	<?php } ?>
	fadeOut_case(case_id);
}
function macro_global_tosed(case_id, subject) {
	$.ajax({url:"<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?macro_global_tosed=" + case_id + "&TOSd_subject=" + subject + "&csrf_token=" + csrf_token,
		type: "GET",
		cache: false,
		success:function(result, textStatus, jqXHR){
			check_case_distribution_last_update_difference(jqXHR.getResponseHeader("X-MultiMode"));
			<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
			$("#macro_global_tosed_" + case_id).html(result);
			case_counter = case_counter - 1;
			<?php } ?>
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
			check_for_reload();
		},
		error:function(jqXHR, textStatus, errorThrown){
			// Try again
			$("#macro_global_tosed_" + case_id).html(errorThrown + '... Try again');
			$("#macro_global_tosed_" + case_id).removeAttr('disabled');
		},
	});
	$("#macro_global_tosed_" + case_id).html('Updating ...');
	$("#macro_global_tosed_" + case_id).attr("disabled", "disabled");
	// Disable other buttons
	$("#assign_and_resolve_" + case_id).attr("disabled", "disabled");
	$("#assign_and_resolve_with_label_" + case_id).attr("disabled", "disabled");
	$("#assign_to_staff_" + case_id).attr("disabled", "disabled");
	// Remove the stream preview on TOS'd
	if($("#stream_preview_" + case_id).html().length > 0)
	{
		$("#stream_preview_" + case_id).html('');
	}
	fadeOut_case(case_id);
}
function assign_to_staff_for_pm_check(case_id, subject) {
	$.ajax({url:"<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?assign_to_staff_pm_check=" + case_id + "&Staffed_subject=" + subject + "&csrf_token=" + csrf_token,
		type: "GET",
		cache: false,
		success:function(result, textStatus, jqXHR){
			check_case_distribution_last_update_difference(jqXHR.getResponseHeader("X-MultiMode"));
			<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
			$("#assign_to_staff_" + case_id).html(result);
			case_counter = case_counter - 1;
			<?php } ?>
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
			check_for_reload();
		},
		error:function(jqXHR, textStatus, errorThrown){
			// Try again
			$("#assign_to_staff_" + case_id).html(errorThrown + '... Try again');
			$("#assign_to_staff_" + case_id).removeAttr('disabled');
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
		},
	});
	<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
	$("#assign_to_staff_" + case_id).html('Updating ...');
	$("#assign_to_staff_" + case_id).attr("disabled", "disabled");
	// Disable other buttons
	$("#assign_and_resolve_" + case_id).attr("disabled", "disabled");
	$("#assign_and_resolve_with_label_" + case_id).attr("disabled", "disabled");
	$("#macro_global_tosed_" + case_id).attr("disabled", "disabled");
	<?php } ?>
	fadeOut_case(case_id);
}
function assign_to_staff_for_escalation(case_id) {
	$.ajax({url:"<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?assign_to_staff_escalation=" + case_id + "&csrf_token=" + csrf_token,
		type: "GET",
		cache: false,
		success:function(result, textStatus, jqXHR){
			check_case_distribution_last_update_difference(jqXHR.getResponseHeader("X-MultiMode"));
			<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
			$("#assign_to_staff_" + case_id).html(result);
			case_counter = case_counter - 1;
			<?php } ?>
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
			check_for_reload();
		},
		error:function(jqXHR, textStatus, errorThrown){
			// Try again
			$("#assign_to_staff_" + case_id).html(errorThrown + '... Try again');
			$("#assign_to_staff_" + case_id).removeAttr('disabled');
			<?php if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on'){ ?>
			remove_case(case_id);
			<?php } ?>
		},
	});
	<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off'){ ?>
	$("#assign_to_staff_" + case_id).html('Updating ...');
	$("#assign_to_staff_" + case_id).attr("disabled", "disabled");
	// Disable other buttons
	$("#assign_and_resolve_" + case_id).attr("disabled", "disabled");
	$("#assign_and_resolve_with_label_" + case_id).attr("disabled", "disabled");
	$("#macro_global_tosed_" + case_id).attr("disabled", "disabled");
	<?php } ?>
	fadeOut_case(case_id);
}
function load_desk_notes(case_id) {
	if($("#desk_notes_" + case_id).html().length === 0)
	{
		$.ajax({url:"<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?load_desk_notes=" + case_id,
			type: "GET",
			cache: false,
			success:function(result){
				$("#desk_notes_" + case_id).html(result);
			},
			error:function(jqXHR, textStatus, errorThrown){
				$("#desk_notes_" + case_id).html(errorThrown + '... Try again');
				$("#desk_notes_" + case_id).removeAttr('disabled');
			},
		});
		$("#desk_notes_" + case_id).html('Loading ...<br><hr>');
	}
	else
	{
		$("#desk_notes_" + case_id).html('');
	}
}
function load_report_history(case_id, user) {
	if($("#report_history_" + case_id).html().length === 0)
	{
		$.ajax({url:"<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST']; ?>/report_history.php?user=" + user,
			type: "GET",
			cache: false,
			success:function(result){
				$("#report_history_" + case_id).html(result);
			},
			error:function(jqXHR, textStatus, errorThrown){
				$("#report_history_" + case_id).html(errorThrown + '... Try again');
			},
		});
		$("#report_history_" + case_id).html('Loading ...<br><hr>');
	}
	else
	{
		$("#report_history_" + case_id).html('');
	}
}
function load_report_history_auto(case_id, user) {
	if($("#report_history_" + case_id).length > 0 && $("#report_history_" + case_id).html().length === 0)
	{
		$.ajax({url:"<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST']; ?>/report_history.php?auto_load=true&user=" + user,
			type: "GET",
			cache: true,
			success:function(result){
				$("#report_history_" + case_id).html(result);
			},
			error:function(jqXHR, textStatus, errorThrown){
				$("#report_history_" + case_id).html(errorThrown + '... Try again');
			},
		});
		$("#report_history_" + case_id).html('Loading ...<br><hr>');
	}
}
function update_case_number_in_title() {
	document.title = "(" + case_counter + ") Twitch Desk - <?php echo $_SESSION['user']['username']; ?>";
}
function fadeOut_case(case_id, add_new) {
	var add_new = typeof add_new !== 'undefined' ?  add_new : true;
	<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off') echo '/*'.PHP_EOL;
	if(isset($_COOKIE['fade_speed']) && is_numeric($_COOKIE['fade_speed']) && $_COOKIE['fade_speed'] >= 0 && $_COOKIE['fade_speed'] <= 5000)
	{
		$case_fade_speed = round($_COOKIE['fade_speed']);
	}
	else
	{
		$case_fade_speed = 200;
	}
	?>
	$.when($("#desk_case_" + case_id).fadeOut({duration:<?php echo $case_fade_speed; ?>, queue:false}) && $("#desk_case_" + case_id + "_hr").fadeOut({duration:<?php echo $case_fade_speed; ?>, queue:false}))
		.then(
			function() {
				if(add_new === true) {
					add_cases_and_resort(case_id);
				}
			}
		);
	<?php if(!isset($_COOKIE['fade_resolved']) || $_COOKIE['fade_resolved'] == 'off') echo '*/'.PHP_EOL; ?>
}

$(window).on('beforeunload', function() {
	$('.col-md-9').empty();
	$('.col-md-9').html('Loading new cases ...<br><hr>');
	$(window).scrollTop(0);
});

$(document).ready(function () {
	<?php if(isset($_COOKIE['sound_volume']) && is_numeric($_COOKIE['sound_volume']) && $_COOKIE['sound_volume'] >= 0 && $_COOKIE['sound_volume'] <= 100)
	{
		echo PHP_EOL.'	// Get the notification elemet ID
	var notification_sound_element_ID = document.getElementById("new_case_notification_sound");
	// now set the volume
	if(typeof notification_sound_element_ID != "undefined" && notification_sound_element_ID != null)
	{
		notification_sound_element_ID.volume = '.round($_COOKIE['sound_volume'] / 100, 3).';
		notification_sound_element_ID.play();
	}'.PHP_EOL;
	}

	// Desk notes auto load
	if(isset($desk_notes_string) && !empty($desk_notes_string))
	{
		echo PHP_EOL.$desk_notes_string.PHP_EOL;
	}

	// Fire's ajax reload without refresh
	if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on')
	{
		echo '	setTimeout(function () { getNew(); }, 15000);'.PHP_EOL;
	}

	// Show the user a "suggestion" box so he / she doesn't forget to enable multi user mode
	if((!isset($_SESSION['showed_multi_user_mode_suggestion']) || $_SESSION['showed_multi_user_mode_suggestion'] !== true) && !isset($_GET['_']) && $use_redis === true && $offer_case_distribution === true)
	{
		echo PHP_EOL.'	bootbox.confirm(\'This shift is within a timeframe of a secondary admin shift, do you want to enable multi user mode now?<br>' .
			'Multi user mode has <b>no negative impact</b> even if you&#039;re the only one with it enabled!<br>'.
			'Click &quot;Cancel&quot; if you want to keep it disabled or &quot;OK&quot; if you want to enable it.\', function(result) { if(result === true) { window.location = "'.$http_or_https.'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?enable_case_distribution=true&csrf_token=" + csrf_token; } });'.PHP_EOL;
		$_SESSION['showed_multi_user_mode_suggestion'] = true;
	}
	?>

	// Report time auto update
	window.timeTimer = setInterval(updateTime, 1000);
	// Check report description height
	check_all_cases_report_description_height();
	// Add preview images
	update_all_stream_preview_images();

	// Load TOS History
	if(auto_load_tos_history == true) {
		$(".tos_history_link").each(function(i){ this.click(); });
	}

	// Load detected violating content previews
	$(".violating_content_preview_link").each(function(i){ this.click(); });
});
// -->
</script>
<?php
if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on')
{
	echo '	<script type="text/javascript" src="js/fire_reloadv3.js"></script>'.PHP_EOL;
}
if(in_array($_SESSION['user']['desk_ID'], array(22379478 /* Kazzy */, 21812877 /* Zombiejill */, 24824293 /* Lucky_Misfit */, 24824270 /* GirlOnDuty */)))
{
	echo '	<link href="css/pinkmode.css" rel="stylesheet">'.PHP_EOL;
}
?>
</head>
<body>
<?php
if(isset($new_case_notification_string) && !empty($new_case_notification_string))
{
	echo $new_case_notification_string.PHP_EOL;
}
?>
<nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
	<div class="container-fluid" id="header-container">
		<div class="navbar-brand">Better Desk</div>
		<p class="navbar-text"></p>
		<div class="btn-group navbar-btn navbar-right">
			<p class="btn btn-default"><b><?php echo htmlspecialchars($_SESSION['user']['username'], ENT_QUOTES|ENT_HTML5); ?></b></p>
			<button type="button" class="btn btn-default" onclick="window.location.reload();" title="Refresh the page"><span class="glyphicon glyphicon-refresh"></span></button>
			<?php
			// Sound option
			if(isset($_COOKIE['sound']) && $_COOKIE['sound'] == 'on')
			{
				echo '<button type="button" class="btn btn-default" onclick="window.location = \''.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?sound=off&csrf_token=\' + csrf_token;" title="Disable notification sound"><span class="glyphicon glyphicon-volume-up"></span></button>'.PHP_EOL;
			}
			else
			{
				echo '<button type="button" class="btn btn-default" onclick="window.location = \''.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?sound=on&csrf_token=\' + csrf_token;" title="Enable notification sound"><span class="glyphicon glyphicon-volume-off"></span></button>'.PHP_EOL;
			}
			// Light option
			if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on')
			{
				echo '<button type="button" class="btn btn-default" onclick="window.location = \''.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?dark_mode=off&csrf_token=\' + csrf_token;" title="Disable dark mode"><span class="glyphicon glyphicon-eye-close"></span></button>'.PHP_EOL;
			}
			else
			{
				echo '<button type="button" class="btn btn-default" onclick="window.location = \''.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?dark_mode=on&csrf_token=\' + csrf_token;" title="Enable dark mode"><span class="glyphicon glyphicon-eye-open"></span></button>'.PHP_EOL;
			}
			// Fade option
			if(isset($_COOKIE['fade_resolved']) && $_COOKIE['fade_resolved'] == 'on')
			{
				echo '<button type="button" class="btn btn-default" onclick="window.location = \''.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?fade_resolved=off&csrf_token=\' + csrf_token;" title="Disable fade on resolved cases (currently enabled)"><span class="glyphicon glyphicon-sort"></span></button>'.PHP_EOL;
			}
			else
			{
				echo '<button type="button" class="btn btn-default" onclick="window.location = \''.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?fade_resolved=on&csrf_token=\' + csrf_token;" title="Enable fade on resolved cases (currently disabled)"><span class="glyphicon glyphicon-tasks"></span></button>'.PHP_EOL;
			}
			// Whisper Report disable option
			/*
			if(isset($_SESSION['whisper_reports_disabled']) && $_SESSION['whisper_reports_disabled'] === true)
			{
				echo '<button type="button" class="btn btn-danger" onclick="window.location = \''.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?whisper_reports=on&csrf_token=\' + csrf_token;" title="Enable displaying Whisper Reports (currently disabled)"><span class="glyphicon glyphicon-envelope"></span></button>'.PHP_EOL;
			}
			else
			{
				echo '<button type="button" class="btn btn-success" onclick="window.location = \''.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?whisper_reports=off&csrf_token=\' + csrf_token;" title="Disable displaying Whisper Reports (currently enabled)"><span class="glyphicon glyphicon-envelope"></span></button>'.PHP_EOL;
			}
			*/
			if($use_redis === true && $offer_case_distribution === true)
			{
				$current_case_distribution_enabled_user = get_user_of_multi_user_distribution();
				// Enable / Disable button
				if(isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
				{
					echo '<a class="btn btn-success" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?enable_case_distribution=false&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" onclick="return confirm(\'Are you sure you want to disable multi user case distribution?\')" title="Disable multi user distribution (currently enabled)"><span class="glyphicon glyphicon-transfer"></span></a>'.PHP_EOL;
				}
				else
				{
					echo '<a class="btn btn-default" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?enable_case_distribution=true&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'" onclick="return confirm(\'Are you sure you want to enable multi user case distribution?\')" title="Enable multi user distribution (currently disabled)"><span class="glyphicon glyphicon-retweet"></span></a>'.PHP_EOL;
				}
				// Set weight button, only display if the user has it enabled
				if(isset($_SESSION['case_distribution_enabled']) && $_SESSION['case_distribution_enabled'] === true)
				{
					echo '<a class="btn btn-default" onclick="bootbox.prompt({title: \'Set your distribution weight (10 is default). Allowed values are 1 - 100.\',value: \''.get_redis_distribution_current_user_weight().'\',callback: function(result) { if (result !== null && isInt(parseInt(result))) { set_distribution_weight(parseInt(result)); } }});">Distribution weight</a>'.PHP_EOL;
				}
				// Drop down for current users
				echo '<div class="btn-group">'.PHP_EOL;
				echo '<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"> <span class="caret"></span></button>'.PHP_EOL;
				echo '<ul class="dropdown-menu">'.PHP_EOL;
				echo '<li><a href="#"><b>Current users:</b></a></li>'.PHP_EOL;
				echo '<li class="divider"></li>'.PHP_EOL;
				foreach($current_case_distribution_enabled_user as $case_distribution_enabled_user_ID => $case_distribution_enabled_data)
				{
					echo '<li><a href="#">'.htmlspecialchars($case_distribution_enabled_data['username'], ENT_QUOTES|ENT_HTML5).' ('.htmlspecialchars($case_distribution_enabled_data['weight'], ENT_QUOTES|ENT_HTML5).')</a></li>'.PHP_EOL;
				}
				echo '</ul>'.PHP_EOL;
				echo '</div>'.PHP_EOL;
				unset($current_case_distribution_enabled_user);
			}
			?>
			<div class="btn-group">
				<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle">Tools <span class="caret"></span></button>
				<ul class="dropdown-menu">
					<li><a href="<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?do_not_ban_management" target="_blank" rel="noreferrer">&quot;do_not_ban&quot; management</a></li>
					<li><a href="//twitch-desk.rootonline.de/report_history.php?manual=true" target="_blank" rel="noreferrer">TOS History</a></li>
					<li><a href="<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?target_user_whisper_report_history=true" target="_blank" rel="noreferrer">Whisper report history against a user</a></li>
					<li><a href="<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?partnerconduct_report=true" target="_blank" rel="noreferrer">PartnerConduct Report</a></li>
					<li><a href="<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?clips_overview=true" target="_blank" rel="noreferrer">Clips overview</a></li>
					<li><a href="https://clips.twitch.tv/commanderroot/MakeTwitchGreatAgain" target="_blank" rel="noreferrer">Mass Clips disable tool</a></li>
					<li><a href="https://twitch-desk.rootonline.de/js/better_clip_deletion.user.js" target="_blank" rel="noreferrer" title="Requires Greasemonkey (Firefox) or Tampermonkey (Chrome)">Mass Clips disable tool script (needed to use the tool)</a></li>
					<li><a href="/url_resolver.php" target="_blank" rel="noreferrer">URL resolver</a></li>
					<li class="divider"></li>
					<li><a href="https://tools.tmod.xyz/chatlog/" target="_blank" rel="noreferrer">Chat logs</a></li>
					<li><a href="/chatlogs/" target="_blank" rel="noreferrer">Chat logs by Root</a></li>
					<li><a href="https://bashtech.net/twitch/profile.php" target="_blank" rel="noreferrer">Profile viewer</a></li>
					<li class="divider"></li>
					<li><a href="https://docs.google.com/a/mods.twitch.tv/document/d/1qzl10p2YaTW7H10kSp7_-jBzZXlxNuHUV-Hf5oz5usI/edit" target="_blank" rel="noreferrer">ROE</a></li>
					<li><a href="https://docs.google.com/a/mods.twitch.tv/spreadsheets/d/1My3FiIdXQnP0nSY8MjPqCUodNybwJMPiRezG7A2821g/edit" target="_blank" rel="noreferrer">Suspensions Guide</a></li>
					<li><a href="https://sites.google.com/a/mods.twitch.tv/moderation/Team-Roster" target="_blank" rel="noreferrer">Admin Team Roster</a></li>
					<li><a href="http://twitch-desk.rootonline.de/js/better_report_reasons.user.js" target="_blank" rel="noreferrer" title="Requires Greasemonkey (Firefox) or Tampermonkey (Chrome)">Better Report reasons selector script</a></li>
					<li><a href="/name_violations.php" target="_blank" rel="noreferrer">Name violation bot speed setter</a></li>
					<li class="divider"></li>
					<li><a href="//twitch-tools.rootonline.de/display_chatter_count.php" target="_blank" rel="noreferrer">Chatter list</a></li>
					<li><a href="//twitch-tools.rootonline.de/show_all_channel_previews.php?filter=all" target="_blank" rel="noreferrer">Non-gaming streams</a></li>
					<li class="divider"></li>
					<li><a href="/chatlogs/?chat_activity_checker" target="_blank" rel="noreferrer">Chat activity checker</a></li>
					<li><a href="//twitch-desk.rootonline.de/whisper_report_history.php" target="_blank" rel="noreferrer">Whisper report history checker</a></li>
					<li><a href="//twitch-tools.rootonline.de/compare_lists.php" target="_blank" rel="noreferrer">Compare 2 lists</a></li>
					<li><a href="/screenshot_upload.php" target="_blank" rel="noreferrer">Screenshot uploader</a></li>
					<li><a href="/screenshot_upload.php?history" target="_blank" rel="noreferrer">Screenshot upload - History</a></li>
					<li><a href="<?php echo $http_or_https; ?>://<?php echo $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?session_stats_history" target="_blank" rel="noreferrer">Session stats history</a></li>
				</ul>
			</div>
			<a class="btn btn-default" href="<?php echo $GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']; ?>?logout&amp;csrf_token=<?php if(isset($_SESSION['csrf_token']) && !empty($_SESSION['csrf_token'])) echo rawurlencode($_SESSION['csrf_token']); ?>" onclick="return confirm('Are you sure?')">Sign out</a>
		</div>
	</div>
</nav>
<br><br><br><br>
<div class="container-fluid" id="body-container">
<?php
if(isset($curl_error_string) && !empty($curl_error_string))
{
	echo '<div class="alert alert-danger alert-dismissible" id="curl_error_string" role="alert">'.PHP_EOL;
	echo '<button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>'.PHP_EOL;
	echo $curl_error_string;
	echo '</div>'.PHP_EOL;
}
if(isset($_SESSION['error_msg']) && !empty($_SESSION['error_msg']))
{
	echo '<div class="alert alert-danger alert-dismissible" id="error_msg" role="alert">'.PHP_EOL;
	echo '<button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>'.PHP_EOL;
	echo $_SESSION['error_msg'];
	echo '</div>'.PHP_EOL;
	// Clear error_msg so we just display it once
	$_SESSION['error_msg'] = '';
}
if(!empty($warning_string))
{
	echo '<div class="alert alert-warning alert-dismissible" id="case_notices" role="alert">'.PHP_EOL;
	echo '<button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>'.PHP_EOL;
	echo $warning_string;
	echo '</div>'.PHP_EOL;
}
?>
	<div class="row">
		<div class="col-md-9">
			<?php echo $cases_html_output; ?>
		</div>
		<?php if(	isset($_SESSION['do_not_autoresolve_by_reporter_array']) ||
					(isset($_SESSION['auto_resolve_by_subject_array']) && count($_SESSION['auto_resolve_by_subject_array']) > 0) ||
					(isset($_SESSION['auto_resolve_by_reporter_array']) && count($_SESSION['auto_resolve_by_reporter_array']) > 0) ||
					(isset($_SESSION['hold_caseID_array']) && count($_SESSION['hold_caseID_array']) > 0) ||
					$show_session_stats === true) { ?>
		<div class="col-md-3">
		<?php if(isset($_SESSION['do_not_autoresolve_by_reporter_array'])) { ?>
			<div class="panel panel-default">
				<div class="panel-heading">
					<span class="label label-default" style="margin-right: 5px;">Do NOT Auto-Resolve</span> <b>Reporter</b><a href="#" onclick="bootbox.prompt({title: 'Add reporter to the &quot;Do NOT Auto-Resolve&quot; list.', value: '', callback: function(result) { if (result !== null && result.length > 0) { add_do_not_autoresolve_reporter(result); } }});"><span class="glyphicon glyphicon-plus pull-right"></span></a>
				</div>
				<?php if(count($_SESSION['do_not_autoresolve_by_reporter_array']) > 0) { ?>
				<ul class="list-group">
				<?php
					foreach($_SESSION['do_not_autoresolve_by_reporter_array'] as $reporter => $resolve_until)
					{
						echo '<li class="list-group-item">'.PHP_EOL;
						echo '<a href="https://www-origin.twitch.tv/'.rawurlencode($reporter).'" target="_blank" rel="noreferrer">';
						echo htmlspecialchars($reporter, ENT_QUOTES|ENT_HTML5);
						echo '</a>';
						if($resolve_until > 0)
						{
							echo '<div class="time-exact" data-unixtime="'.$resolve_until.'" style="display:inline;"></div> <div class="time-friendly" style="display:inline;">('.sec_to_nice_time($resolve_until - time()).')</div>';
						}
						echo PHP_EOL;
						echo '<a href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?do_not_autoresolve_reporter_remove='.rawurlencode($reporter).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'"><span class="glyphicon glyphicon-remove pull-right"></span></a>'.PHP_EOL;
						echo '</li>'.PHP_EOL;
					}
				?>
				</ul>
				<?php } ?>
			</div>
			<hr>
		<?php } ?>
		<?php if(isset($_SESSION['auto_resolve_by_subject_array']) && count($_SESSION['auto_resolve_by_subject_array']) > 0) { ?>
			<div class="panel panel-default">
				<div class="panel-heading">
					<span class="label label-default" style="margin-right: 5px;">Auto-Resolve</span> <b>Reported Channel</b>
				</div>
				<ul class="list-group">
				<?php
					foreach($_SESSION['auto_resolve_by_subject_array'] as $subject => $resolve_until)
					{
						echo '<li class="list-group-item">'.PHP_EOL;
						if(strpos($subject, 'Abuse report concerning ') !== false)
						{
							$subject_explode = explode(' ', trim($subject));
							echo '<a href="https://player.twitch.tv/?channel='.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">';
							echo htmlspecialchars(str_replace('Abuse report concerning ', '', str_replace('[xbox]', '', $subject)), ENT_QUOTES|ENT_HTML5);
							echo '</a>';
							unset($subject_explode);
						}
						elseif(strpos($subject, 'Whisper Report concerning ') !== false)
						{
							$subject_explode = explode(' ', trim($subject));
							echo '<a href="https://www-origin.twitch.tv/'.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">';
							echo htmlspecialchars($subject, ENT_QUOTES|ENT_HTML5);
							echo '</a>';
							unset($subject_explode);
						}
						elseif(strpos($subject, 'Channel feed report concerning ') !== false)
						{
							$subject_explode = explode(' ', trim($subject));
							echo '<a href="https://www-origin.twitch.tv/'.rawurlencode($subject_explode[(count($subject_explode) - 1)]).'" target="_blank" rel="noreferrer">';
							echo htmlspecialchars($subject, ENT_QUOTES|ENT_HTML5);
							echo '</a>';
							unset($subject_explode);
						}
						else
						{
							echo htmlspecialchars($subject, ENT_QUOTES|ENT_HTML5);
						}
						if($resolve_until > 0)
						{
							echo '<div class="time-exact" data-unixtime="'.$resolve_until.'" style="display:inline;"></div> <div class="time-friendly" style="display:inline;">('.sec_to_nice_time($resolve_until - time()).')</div>';
						}
						echo PHP_EOL;
						echo '<a href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_subject_remove='.rawurlencode($subject).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'"><span class="glyphicon glyphicon-remove pull-right"></span></a>'.PHP_EOL;
						echo '</li>'.PHP_EOL;
					}
				?>
				</ul>
			</div>
			<hr>
			<?php } ?>
			<?php if(isset($_SESSION['auto_resolve_by_reporter_array']) && count($_SESSION['auto_resolve_by_reporter_array']) > 0) { ?>
			<div class="panel panel-default">
				<div class="panel-heading">
					<span class="label label-default" style="margin-right: 5px;">Auto-Resolve</span> <b>Reporters</b>
				</div>
				<ul class="list-group">
				<?php
					foreach($_SESSION['auto_resolve_by_reporter_array'] as $reporter => $resolve_until)
					{
						echo '<li class="list-group-item">'.PHP_EOL;
						echo '<a href="https://www-origin.twitch.tv/'.rawurlencode($reporter).'" target="_blank" rel="noreferrer">';
						echo htmlspecialchars($reporter, ENT_QUOTES|ENT_HTML5);
						echo '</a>';
						if($resolve_until > 0)
						{
							echo '<div class="time-exact" data-unixtime="'.$resolve_until.'" style="display:inline;"></div> <div class="time-friendly" style="display:inline;">('.sec_to_nice_time($resolve_until - time()).')</div>';
						}
						echo PHP_EOL;
						echo '<a href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?auto_resolve_reporter_remove='.rawurlencode($reporter).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'"><span class="glyphicon glyphicon-remove pull-right"></span></a>'.PHP_EOL;
						echo '</li>'.PHP_EOL;
					}
				?>
				</ul>
			</div>
			<hr>
			<?php } ?>
			<?php if(isset($_SESSION['hold_caseID_array']) && count($_SESSION['hold_caseID_array']) > 0) { ?>
			<div class="panel panel-default">
				<div class="panel-heading">
					<span class="label label-default" style="margin-right: 5px;">Case hold list</span>
				</div>
				<ul class="list-group">
				<?php
					foreach($_SESSION['hold_caseID_array'] as $caseID => $hold)
					{
						// Old type hold conversion
						if(!is_array($hold))
						{
							$old_hold_var = $hold;
							$hold = array();
							$hold['hold_until'] = $old_hold_var;
							unset($old_hold_var);
						}
						echo '<li class="list-group-item">'.PHP_EOL;
						echo '<a href="https://help.twitch.tv/agent/case/'.rawurlencode($caseID).'" target="_blank" rel="noreferrer">';
						if(!isset($hold['subject']) || empty($hold['subject']))
						{
							echo htmlspecialchars('('.$caseID.')', ENT_QUOTES|ENT_HTML5);
						}
						else
						{
							if(strpos($hold['subject'], 'Abuse report concerning ') !== false)
							{
								echo htmlspecialchars(str_replace('Abuse report concerning ', '', str_replace('[xbox]', '', $hold['subject'])).' ('.$caseID.')', ENT_QUOTES|ENT_HTML5);
							}
							else
							{
								echo htmlspecialchars($hold['subject'].' ('.$caseID.')', ENT_QUOTES|ENT_HTML5);
							}
						}
						echo '</a>';
						if($hold['hold_until'] > 0)
						{
							echo '<div class="time-exact" data-unixtime="'.$hold['hold_until'].'" style="display:inline;"></div> <div class="time-friendly" style="display:inline;">('.sec_to_nice_time($hold['hold_until'] - time()).')</div>';
						}
						echo PHP_EOL;
						echo '<a href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?hold_caseID_remove='.rawurlencode($caseID).'&amp;csrf_token='.rawurlencode($_SESSION['csrf_token']).'"><span class="glyphicon glyphicon-remove pull-right"></span></a>'.PHP_EOL;
						echo '</li>'.PHP_EOL;
					}
				?>
				</ul>
			</div>
			<hr>
			<?php } ?>
			<?php if($show_session_stats === true) { ?>
			<div class="panel panel-default">
				<div class="panel-heading">
					<span class="label label-default" style="margin-right: 5px;">Session Stats</span>
				</div>
				<ul class="list-group">
					<!-- <li class="list-group-item">Total cases: <span class="badge"><?php echo count($_SESSION['session_stats']['cases_overall']); ?></span></li> -->
					<li class="list-group-item">Unique cases: <span class="badge"><?php echo (count($_SESSION['session_stats']['cases_overall']) - count($_SESSION['session_stats']['duplicate_cases'])); ?></span></li>
					<!-- <li class="list-group-item">Duplicate cases: <span class="badge"><?php echo count($_SESSION['session_stats']['duplicate_cases']); ?></span></li> -->
					<!-- <li class="list-group-item">Report cases: <span class="badge"><?php echo count($_SESSION['session_stats']['report_cases']); ?></span></li> -->
					<li class="list-group-item">Report cases: <span class="badge"><?php echo (count($_SESSION['session_stats']['report_cases']) - count($_SESSION['session_stats']['duplicate_cases'])); ?></span></li>
					<li class="list-group-item">Whisper cases: <span class="badge"><?php echo count($_SESSION['session_stats']['whisper_cases']); ?></span></li>
					<li class="list-group-item">Channel feed cases: <span class="badge"><?php echo count($_SESSION['session_stats']['channel_feed_cases']); ?></span></li>
					<li class="list-group-item">Clip cases: <span class="badge"><?php echo count($_SESSION['session_stats']['clip_cases']); ?></span></li>
					<li class="list-group-item">Other cases: <span class="badge"><?php echo count($_SESSION['session_stats']['cases_overall']) - (count($_SESSION['session_stats']['report_cases']) + count($_SESSION['session_stats']['whisper_cases']) + count($_SESSION['session_stats']['channel_feed_cases']) + count($_SESSION['session_stats']['clip_cases'])); ?></span></li>
					<li class="list-group-item"></li>
					<li class="list-group-item">Auto resolved by channel: <span class="badge"><?php echo count($_SESSION['session_stats']['auto_resolved_subject_cases']); ?></span></li>
					<li class="list-group-item">Auto resolved by reporter: <span class="badge"><?php echo count($_SESSION['session_stats']['auto_resolved_reporter_cases']); ?></span></li>
					<li class="list-group-item">Auto resolved own strikes: <span class="badge"><?php echo count($_SESSION['session_stats']['auto_resolved_own_tos_cases']); ?></span></li>
					<li class="list-group-item">Auto resolved by age: <span class="badge"><?php echo count($_SESSION['session_stats']['auto_resolved_by_age_cases']); ?></span></li>
					<li class="list-group-item"></li>
					<li class="list-group-item">Resolved cases: <span class="badge"><?php echo count($_SESSION['session_stats']['resolved_cases']); ?></span></li>
					<li class="list-group-item">Banned cases: <span class="badge"><?php echo count($_SESSION['session_stats']['TOSd_cases']); ?></span></li>
					<li class="list-group-item">PM checked cases: <span class="badge"><?php echo count($_SESSION['session_stats']['staff_assigned_pm_check_cases']); ?></span></li>
				</ul>
			</div>
			<hr>
			<?php } ?>
		</div>
		<?php } ?>
	</div>
	<div class="row">
	<?php echo 'Page generated in '.round((microtime(true) - $script_start_time), 4).' seconds. (API requests alone took: '.round($global_api_request_time, 4).' seconds)'.PHP_EOL; ?>
	<?php echo '<!-- Session start time: '.round($session_start_time, 4).' seconds -->'.PHP_EOL; ?>
	</div>
</div>
<script type="text/javascript" src="js/bootstrap.min.js"></script>
<script type="text/javascript" src="js/dropdowns-enhancement.js"></script>
<script type="text/javascript" src="js/bootbox.min.js"></script>
<?php
if(isset($_SESSION['show_debug']) && $_SESSION['show_debug'] === true)
{
	if(isset($curl_request_info_string) && !empty($curl_request_info_string)) echo $curl_request_info_string;
	// echo '<!-- '.print_r($_SESSION['session_stats'], true).' -->'.PHP_EOL;
}

// Log debug output if the request takes longer than 60 seconds
if((microtime(true) - $script_start_time) >= 60)
{
	if(isset($curl_request_info_string) && !empty($curl_request_info_string))
	{
		$log_array = array();
		$log_array['time'] = date('c');
		$log_array['loggedin_user_ID'] = $_SESSION['user']['desk_ID'];
		$log_array['loggedin_user_username'] = $_SESSION['user']['username'];
		$log_array['full_request_time'] = round((microtime(true) - $script_start_time), 4);
		$log_array['api_request_time'] = round($global_api_request_time, 4);
		$log_array['session_start_time'] = round($session_start_time, 4);
		$log_array['debug_output'] = $curl_request_info_string;
		// Add log entry
		file_put_contents(__DIR__ . '/long_requests.log', json_encode($log_array).PHP_EOL, FILE_APPEND | LOCK_EX);
	}
}
?>
</body>
</html>
<?php
}
else
{
	// Show login form
	include 'login_form.php';
}
?>