function getNew() {
	'use strict';

	//get root ( Kappa )
	$.ajax({url:"/",
		type: "GET",
		cache: false,
		success:function(d, textStatus, jqXHR){
			check_case_distribution_last_update_difference(jqXHR.getResponseHeader("X-MultiMode"));

			//strip audio tag from raw html... otherwise the audio plays
			//as soon as the element is parsed
			d = d.replace(/<audio.+autoplay.+<\/audio>/g, "");

			//parse html, find the case listing, get it's children
			// filter for only cases, then only cases that actually
			// need to be inserted into the page, then stick all
			// of them in our holding area until we're ready to 
			// populate the on-page listing
			$("body")
				.append(
				$("#airLock")
				.detach()
				.empty()
				.append(
					$($.parseHTML(d))
					.find(".col-md-9")
					.children()
					.filter('.panel'))
			);
			// setTimeout to load the new cases in x seconds again
			setTimeout(function () { getNew(); }, 15000);
		}
	});
}

function setNew() {

	//populate case list with the holding area cases
	$("#airLock")
		.children()
		.filter('.panel')
		.each(function (i, e) {
			// If doesn't exist on the page yet, add it
			if($(".col-md-9").children().filter('#' + e.id).length === 0)
			{
				// Needs cloning else it's moved (and because of that later removed again because it's not here anymore)
				$(e).clone().appendTo($(".col-md-9"));
				// console.log('Adding: ' + e.id);
			}
		});
	
	// Remove cases which are not in the #airLock (except if #airLock is empty)
	if($("#airLock").children().length > 0)
	{
		$(".col-md-9")
			.children()
			.filter('.panel')
			.each(function (i, e) {
				// If it doesn't exist in the #airLock we remove it except if the preview player is running
				if($("#airLock").children().filter('#' + e.id).length != 1)
				{
					var caseID_part = e.id.split("_")[2];
					if($("#stream_preview_" + caseID_part).html() == "")
					{
						$('#' + e.id).remove();
						// console.log('Removing: ' + e.id);
					}
				}
			});
	}
	
	// Empty #airLock now that we are done with adding and checking
	$("#airLock").empty();

	//remove all hr elements so they don't cause sorting issues
	$(".col-md-9")
		.children()
		.filter(function (i, e) {
			return /^desk_case_\d+?_hr$/.test(this.id)
	})
	.remove();

	//set escalations to over-maximum priority
	//so they're always sorted to the top
	$(".escalation-case")
		.data('priority', 11);

	//re-add the escalation sound effect since we /do/ want it
	if ($(".escalation-case")
		.length !== 0) {

		//loop through any on the page
		$(".escalation-case")
			.each(function (i, e) {
				//check to see if they have an audio child already
				if ($(e)
				.find("audio")
				.length === 0) {
				//if they don't, add one
				$(e)
					.append('<audio autoplay><source src="alarm_moderation_escalation.mp3" type="audio/mpeg"></audio>');
				}
			});

	}

	var sort_counter = 1;
	//sort cases by priority then by case ID ( prority then oldest )
	$(".col-md-9")
		.children()
		.filter('.panel')
		.sort(function (a, b) {

			var aP = $(a)
				.data('priority') || 0,
				bP = $(b)
				.data('priority') || 0;

			if (aP > bP) {
				return -1;
			} else if (aP < bP) {
				return 1;
			} else {
				var aID = a.id.split("_")[2],
				bID = b.id.split("_")[2];

				if (aID < bID) {
					return -1;
				} else if (aID > bID) {
					return 1;
				} else {
					return 0;
				}
			}
		})
		.each(function (i, e) {
			// remove the style parameter from every case
			$(e).css("order", "");
		})
		.each(function (i, e) {
			// Only do stuff if it's not already done to it
			if(typeof $(e).css("order") === "undefined" || $(e).css("order") == "0") {
				//set css flex order based on sort order
				$(e).css({
					order: ((sort_counter + 1) * 2) - 1 //multiplied to give room for hr elements
					});
				//generate new hr for each case, stick it in after them with the correct flex order but only if the current case is not hidden or going to be hidden
				if($(e).css("display") == "block" && $(e).css('opacity') == 1) {
					$(e).after('<div style="order: ' + ((sort_counter + 1) * 2) + ';" id="' + e.id + '_hr' + '"><hr><br></div>');
				}
				sort_counter = sort_counter + 1;
				
				// Check for cases from the same channel which aren't already added and add them after
				$(".col-md-9")
					.children()
					.filter('.panel')
					.each(function (ia, ea) {
					// Only do stuff if it's not already done to it
					if((typeof $(ea).css("order") === "undefined" || $(ea).css("order") == "0") && $(e).data('channel') == $(ea).data('channel')) {
						//set css flex order based on sort order
						$(ea).css({
							order: ((sort_counter + 1) * 2) - 1 //multiplied to give room for hr elements
							});
						//generate new hr for each case, stick it in after them with the correct flex order
						$(ea).after('<div style="order: ' + ((sort_counter + 1) * 2) + ';" id="' + ea.id + '_hr' + '"><hr><br></div>');
						sort_counter = sort_counter + 1;						
					}
				});
			}
		});

	//update page title with new case count, ignore hr elements
	window.case_counter = $(".col-md-9")
		.children()
		.filter('.panel')
		.length;
	// update_case_number_in_title();
	check_for_reload();
	check_all_cases_report_description_height();
	update_all_stream_preview_images();
	if(auto_load_tos_history == true) {
		$(".tos_history_link").each(function(i){ this.click(); });
	}
	// Auto load detected content previews
	$(".violating_content_preview_link").each(function(i){ this.click(); });
}

$(function () {
	//my body is ready

	//flex stylings required for sorting
	//try to make alerts always sit at the top
	$('body')
		.append('<style id="flexStyle">\
			.panel { \
				flex: 0 0 auto; \
			} \
			.col-md-9 { \
				display:flex; \
				flex-direction: column; \
			} \
			.alert {\
				order: 0;\
			}\
			#airLock { \
				display:none; \
				text-indent:-9999px; \
			} \
		</style>');

	//holding element for new cases before on-screen population
	$('body')
		.append(
			$("<div>")
			.attr("id", "airLock")
	);

	//update time once per second. performance impact is negligable even at 
	// window.timeTimer = setInterval(updateTime, 1000);
	// window.fetchTimer = setInterval(getNew, 20000);
});

function remove_case_and_resort(case_id) {
	var current_channel_to_remove = $("#desk_case_" + case_id).data('channel');
	if(typeof $("#desk_case_" + case_id).css("order") === "undefined")
	{
		var next_channel_order = 3;
	}
	else
	{
		var current_channel_order = $("#desk_case_" + case_id).css("order");
		var next_channel_order = parseInt(current_channel_order, 10) + 2;
	}
	var next_channel_ID = $('div[style="order: ' + next_channel_order + ';"]').attr('id');
	if(typeof next_channel_ID !== "undefined")
	{
		var next_channel_in_order = $("#" + next_channel_ID).data('channel');
	}
	
	// when both are removed, repopulate the caselist
	$.when($("#desk_case_" + case_id).remove() && $("#desk_case_" + case_id + "_hr").remove())
	.then(
		function () {
				if(typeof next_channel_in_order === "undefined" || $(".col-md-9").children().filter('.panel').length <= 1)
				{
					setNew();
					// console.log('Current: ' + current_channel_to_remove + " -- Next: " + next_channel_in_order + " -- Current channel order: " + current_channel_order);
				}
				else if(current_channel_to_remove != next_channel_in_order)
				{
					setNew();
					// console.log('Current: ' + current_channel_to_remove + " -- Next: " + next_channel_in_order);
				}
				else
				{
					// Just update the case number counter
					window.case_counter = $(".col-md-9")
						.children()
						.filter('.panel')
						.length;
					check_for_reload();
				}
			}
		);
};

function add_cases_and_resort(case_id) {
	var current_channel_to_remove = $("#desk_case_" + case_id).data('channel');
	if(typeof $("#desk_case_" + case_id).css("order") === "undefined")
	{
		var next_channel_order = 3;
	}
	else
	{
		var current_channel_order = $("#desk_case_" + case_id).css("order");
		var next_channel_order = parseInt(current_channel_order, 10) + 2;
	}
	var next_channel_ID = $('div[style="order: ' + next_channel_order + ';"]').attr('id');
	if(typeof next_channel_ID !== "undefined")
	{
		var next_channel_in_order = $("#" + next_channel_ID).data('channel');
	}
	
	// when both are removed, repopulate the caselist
	if(typeof next_channel_in_order === "undefined" || $(".col-md-9").children().filter('.panel').length <= 1)
	{
		setNew();
		// console.log('Current: ' + current_channel_to_remove + " -- Next: " + next_channel_in_order + " -- Current channel order: " + current_channel_order);
	}
	else if(current_channel_to_remove != next_channel_in_order)
	{
		setNew();
		// console.log('Current: ' + current_channel_to_remove + " -- Next: " + next_channel_in_order);
	}
	else
	{
		// Just update the case number counter
		window.case_counter = $(".col-md-9")
				.children()
				.filter('.panel')
				.length;
		check_for_reload();
	}
};