<?php
// äüö - UTF8 FTW
// Only allow including of this file
if(preg_match('/partnerconduct_report\.php/i', $_SERVER['PHP_SELF']) === 1)
{
	exit();
}

function string_to_ahref2($string)
{
	$return = '*"'.$string.'":'.$string.'*';
	return $return;
}

function parse_urls_to_ahref2($message)
{
	$array = explode("\n", $message);
	$return = '';
	foreach($array as $line)
	{
		$words = explode(' ', $line);
		foreach($words as $word)
		{
			if(($parsed_word = parse_url($word)) !== false)
			{
				if(isset($parsed_word['scheme']) && isset($parsed_word['host']) && !empty($parsed_word['scheme']) && !empty($parsed_word['host']))
				{
					// http://blalba.com
					if($parsed_word['scheme'] == 'http' || $parsed_word['scheme'] == 'https')
					{
						$return .= string_to_ahref2($word);
					}
					else
					{
						$return .= $word;
					}
				}
				else
				{
					$return .= $word;
				}
			}
			else
			{
				$return .= $word;
			}
			$return .= ' ';
		}
		$return .= PHP_EOL;
	}
	return $return;
}

function create_new_partnerconduct_case($subject, $message)
{
	$ch = &$GLOBALS['global_curl'];
	// Create the post content
	$post_content_array = array();
	$post_content_array['subject'] = $subject;
	$post_content_array['message']['subject'] = $subject;
	$post_content_array['message']['to'] = 'partnerconduct@twitch.tv'; // partnerconduct@twitch.tv
	$post_content_array['message']['cc'] = 'paid-moderators@mods.twitch.tv'; // paid-moderators@mods.twitch.tv 
	$post_content_array['message']['from'] = 'moderation@twitch.tv';
	$post_content_array['message']['direction'] = 'out';
	$post_content_array['message']['status'] = 'pending';
	$post_content_array['message']['body'] = $message;
	$post_content_array['message']['suppress_rules'] = false;
	$post_content_array['type'] = 'email';
	$post_content_array['status'] = 'resolved';
	$post_content_array['_links']['customer'] = array('class' => 'customer', 'href' => '/api/v2/customers/414234628');
	$post_content_array['_links']['assigned_group'] = array('class' => 'group', 'href' => '/api/v2/groups/576234');
	$post_content_array['_links']['outbound_mailbox'] = array('class' => 'outbound_mailbox', 'href' => '/api/v2/mailboxes/outbound/85518'); // moderation@twitch.tv
	$post_content_array['outbound_mailbox'] = 'moderation@twitch.tv';
	$post_content = json_encode($post_content_array);
	unset($post_content_array);
	
	$request_url = 'https://help.twitch.tv/api/v2/cases';
	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $request_url);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json'));
	if(isset($_SESSION['login_method']) && $_SESSION['login_method'] === 'oauth')
	{
		$oauth_request_header = $GLOBALS['global_oauth']->getRequestHeader('POST', $request_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/json', 'Content-Type: application/json', 'Authorization: '.$oauth_request_header));
	}
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_content);
	
	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_output === false)
	{
		echo 'Curl error on "'.$curl_info['url'].'" => '.curl_error($ch);
	}
	else
	{
		$curl_parse = parse_desk_curl_output($curl_output);
		if($curl_info['http_code'] >= 200 && $curl_info['http_code'] <= 204)
		{
			echo 'Partner conduct report submitted. Now have fun dealing with autoresolves!'.PHP_EOL;
		}
		elseif($curl_info['http_code'] == 304)
		{
			// Never happens as I don't use ETAG's but if I did it would be successful
		}
		elseif($curl_info['http_code'] == 429)
		{
			header('HTTP/1.1 429 Desk Rate Limit', true, 429);
			echo 'DESK: hit rate limit on URL: '.$curl_info['url'];
			exit();
		}
		elseif($curl_info['http_code'] == 422)
		{
			header('HTTP/1.1 422 Unprocessable Entity', true, 422);
			echo 'CURL HTTP error 422 while updating the case'.PHP_EOL;
			exit();
		}
		elseif($curl_info['http_code'] == 409)
		{
			echo 'DESK: Conflict: '.$curl_info['url'].PHP_EOL;
		}
		else
		{
			header('HTTP/1.1 503 Service Unavailable', true, 503);
			// Some other HTTP error => Try again
			echo 'CURL: HTTP ERROR: '.$curl_info['url'].PHP_EOL;
		}
	}	
}

function gen_data_for_violation_report($target_user, $detailed_reason_title, $description)
{
	$case_data = array();
	$case_data['subject'] = '[Violation] [P] '.$target_user.' => '.$detailed_reason_title;
	$case_data['body'] = 'Reporting admin: '.$_SESSION['user']['username'].PHP_EOL;
	$case_data['body'] .= 'Channel URL: *"https://www-origin.twitch.tv/'.$target_user.'":https://www-origin.twitch.tv/'.rawurlencode($target_user).'*'.PHP_EOL;
	if(isset($_POST['reason']) && !empty($_POST['reason']))
	{
		$case_data['body'] .= 'Reason: '.$_POST['reason'].PHP_EOL;
	}
	$case_data['body'] .= parse_urls_to_ahref2($description);
	
	return $case_data;
}

function gen_data_for_escalation_report($target_user, $detailed_reason_title, $description)
{
	$case_data = array();
	$case_data['subject'] = '[Escalation] [P] '.$target_user.' => potential '.$detailed_reason_title;
	$case_data['body'] = 'Reporting admin: '.$_SESSION['user']['username'].PHP_EOL;
	$case_data['body'] .= 'Channel URL: *"https://www-origin.twitch.tv/'.$target_user.'":https://www-origin.twitch.tv/'.rawurlencode($target_user).'*'.PHP_EOL;
	if(isset($_POST['reason']) && !empty($_POST['reason']))
	{
		$case_data['body'] .= 'Reason: '.$_POST['reason'].PHP_EOL;
	}
	$case_data['body'] .= parse_urls_to_ahref2($description);
	
	return $case_data;
}

function gen_data_for_fyi_report($target_user, $subject, $description)
{
	$case_data = array();
	$case_data['subject'] = '[FYI] [P] '.$target_user.' => '.$subject;
	$case_data['body'] = 'Reporting admin: '.$_SESSION['user']['username'].PHP_EOL;
	$case_data['body'] .= 'Channel URL: *"https://www-origin.twitch.tv/'.$target_user.'":https://www-origin.twitch.tv/'.rawurlencode($target_user).'*'.PHP_EOL;
	$case_data['body'] .= '----------------------------------------'.PHP_EOL.PHP_EOL;
	$case_data['body'] .= parse_urls_to_ahref2($description);
	
	return $case_data;
}


if($_SERVER['REQUEST_METHOD'] == 'POST')
{
	$input_error = false;
	$input_error_msg = '';
	// Check if all parts exist
	// CSRF token
	if((!isset($_SESSION['csrf_token']) || empty($_SESSION['csrf_token'])) || (!isset($_POST['csrf_token']) || empty($_POST['csrf_token'])) || validate_csrf_token($_POST['csrf_token']) === false)
	{
		$input_error_msg .= 'Error verifying your request.<br>'.PHP_EOL;
		$input_error = true;
	}
	
	// Target user
	if(isset($_POST['reported_user']) && !empty(trim($_POST['reported_user'])))
	{
		$reported_user = strtolower(trim($_POST['reported_user']));
	}
	else
	{
		$input_error_msg .= 'You need to provide a partner username.<br>'.PHP_EOL;
		$input_error = true;
	}
	
	// Email type
	if(isset($_POST['email_type']) && !empty($_POST['email_type']) && in_array($_POST['email_type'], array('violation', 'escalation', 'fyi')) === true)
	{
		$email_type = $_POST['email_type'];
	}
	else
	{
		$input_error_msg .= 'You need to provide an email type.<br>'.PHP_EOL;
		$input_error = true;
	}
	
	// If it's a violation check if it has all the required parts
	if(isset($email_type) && ($email_type == 'violation' || $email_type == 'escalation'))
	{
		if(isset($_POST['reason']) && !empty($_POST['reason']))
		{
			$reason = $_POST['reason'];
		}
		else
		{
			$input_error_msg .= 'You need to provide a report reason.<br>'.PHP_EOL;
			$input_error = true;
		}
		
		if(isset($_POST['detailed_reason_title']) && !empty($_POST['detailed_reason_title']))
		{
			$detailed_reason_title = $_POST['detailed_reason_title'];
		}
		else
		{
			$input_error_msg .= 'You need to provide a detailed_reason_title.<br>'.PHP_EOL;
			$input_error = true;
		}
	}
	elseif(isset($email_type))
	{
		// Not a violation so it needs a subject
		if(isset($_POST['subject']) && !empty($_POST['subject']))
		{
			$subject = $_POST['subject'];
		}
		else
		{
			$input_error_msg .= 'You need to provide a subject.<br>'.PHP_EOL;
			$input_error = true;
		}
	}
	
	// Always needs a descreption
	if(isset($_POST['description']) && !empty($_POST['description']))
	{
		$description = $_POST['description'];
	}
	else
	{
		$input_error_msg .= 'You need to provide a report description.<br>'.PHP_EOL;
		$input_error = true;
	}
	
	if($input_error === false)
	{
		// We have all the data we need so lets create the case / email
		if(isset($email_type) && $email_type == 'violation')
		{
			$case_data = gen_data_for_violation_report($reported_user, $detailed_reason_title, $description);
		}
		elseif(isset($email_type) && $email_type == 'escalation')
		{
			$case_data = gen_data_for_escalation_report($reported_user, $detailed_reason_title, $description);
		}
		elseif(isset($email_type) && $email_type == 'fyi')
		{
			$case_data = gen_data_for_fyi_report($reported_user, $subject, $description);
		}
		
		// print_r($case_data).PHP_EOL;
		if(isset($case_data))
		{
			create_new_partnerconduct_case($case_data['subject'], $case_data['body']);
		}
		else
		{
			echo 'There was an issue creating the case (insufficient data)'.PHP_EOL;
		}
		exit();
	}
}

?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>Partner Conduct Report</title>
	<script type="text/javascript" src="/js/jquery.min.js"></script>
</head>
<body>
<?php if(isset($input_error) && $input_error === true) echo '<h2><b>'.$input_error_msg.'</b></h2>'.PHP_EOL; ?>
<div>
<div>
<div>
<h4>
<span>
Partner Conduct Report
</span>
</h4>
</div>
<form action="" id="report_form" method="POST">
<input type="hidden" name="csrf_token" value="<?php if(isset($_SESSION['csrf_token']) && !empty($_SESSION['csrf_token'])) echo $_SESSION['csrf_token']; ?>">
<div>
<label for="reported_user">Target Partner: </label>
<input id="reported_user" name="reported_user" type="text" value="<?php if(isset($_GET['target_user']) && !empty(trim($_GET['target_user']))) echo htmlspecialchars(strtolower(trim($_GET['target_user'])), ENT_QUOTES|ENT_HTML5); ?>" required>
</div>
<label for="email_type">Select email type</label>
<div>
<select class="field" id="email_type" name="email_type" required>
<option value="">Select one...</option>
<option value="violation">Violation</option>
<option value="escalation">Escalation</option>
<option value="fyi">FYI</option>
</select>
</div>
</form>
</div>
</div>
<!-- Load the script here so it's done after the html was loaded -->
<script type="text/javascript" src="/js/addon_better_report_reasons.js?_<?php echo time(); ?>"></script>
<script type="text/javascript">
<!--
$('#email_type').change(function() {
	console.log('email_type: ' + $(this).val());
	
	// First remove all possible existing reasons, detailed reasons, ... basically reset the form
	// Reason
	$('#reason_div').remove();
	// Detailed Reason
	$('#detailed_reason_div').remove();
	// Description
	$('#description_div').remove();
	// Suspend options (IP ban, Permanent, ...)
	$('#suspend_options_div').remove();
	// Send Button
	$('#send_button_div').remove();
	// Reset hidden detailed reason input
	$('input[name="detailed_reason_title"]').val('');
	// Subject
	$('#subject_div').remove();
	
	
	// Now add the selector for the reasons of the selected content
	if($(this).val() == 'violation')
	{
		// Show content selector (this way the normal better reason script works)
		$("#content_div").show();
		$("#quickselect_select").show();
	}
	else if($(this).val() == 'escalation')
	{
		// Show content selector (this way the normal better reason script works)
		$("#content_div").show();
		$("#quickselect_select").show();
	}
	else if($(this).val() == 'fyi')
	{
		// Hide content selector
		$("#content_div").hide();
		$("#quickselect_select").hide();
		add_subject_and_description_fields();
	}
	else
	{
		// Hide both
		$("#content_div").hide();
		$("#quickselect_select").hide();
	}
});

function add_subject_and_description_fields()
{
	// Add subject field
	$('#report_form').append('<div id="subject_div"><label for="subject">Subject</label><div><input id="subject" name="subject" type="text" value="" required></div><div>');

	// Add the description box
	$('#report_form').append('<div id="description_div"><label for="description">Description</label><div><textarea autocomplete="off" class="field textarea" id="description" name="description"></textarea></div><div>');
	// Make textarea bigger so you can actually read what's in it
	$('#description').css({'margin': '0px', 'width': '500px', 'height': '220px'});
	// Make description required client side too
	$('#description').attr('required', 'required');
	if($.getUrlVar('description') !== undefined)
	{
		// Add a potentional description from the URL to the input form
		$('#description').text($('#description').text() + "\n\n" + decodeURIComponent($.getUrlVar('description').replace(/\+/g, '%20')));
	}
	
	// Send button
	$('#report_form').append('<div id="send_button_div"><button class="primary button" id="report_form_submit" type="submit"><span>Send</span></button><div>');
	// Add margin-top to the send button so you don't accidentally click "Permanent Ban?" and then the button
	$('#send_button_div').css({'margin-top': '30px'});
	// Disable Send button on Submit and set the other stuff to read only
	$('form#report_form').submit(function() {
		$('#description').attr('readonly', 'readonly');
		$('#report_form_submit').prop('disabled', true);
	});
}

// Hide content selector and quick select by default
$("#content_div").hide();
$("#quickselect_select").hide();

// -->
</script>
</body>
</html>