<?php
// ÜÖÄ UTF8-FTW
ignore_user_abort(false);

require_once __DIR__ . '/RedisSessionHandler.php';
$sessHandler = new RedisSessionHandler(null, null, null, null, true);
session_set_save_handler($sessHandler);
session_start();
// We don't change anything in the session so we can close writes here
@session_write_close();

// header('Cache-Control: no-store, no-cache, must-revalidate');
// header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
// header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
// header('Pragma: no-cache');

function time_to_pst_time($time)
{
	$dateTime = new DateTime(date('c', strtotime($time)), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	// $return = $dateTime->format('r (T)');
	$return = $dateTime->format('Y-m-d H:i:s T');
	return $return;
}

function sec_to_nice_time($seconds, $skip_sec = false)
{
	$days = floor($seconds/60/60/24);
	$hours = floor(($seconds/60/60)%24);
	$min = floor(($seconds/60)%60);
	$sec = floor($seconds%60);
	
	$string = '';
	$started = false;
	if($days > 0)
	{
		$string .= '<b>'.$days.'d</b> ';
		$started = true;
	}
	
	if($hours > 0 || $started == true)
	{
		$string .= $hours.'h ';
		$started = true;
	}
	
	if($min > 0 || $started == true)
	{
		$string .= $min.'m ';
		$started = true;
	}
	
	if(($sec > 0 || $started == true) && $skip_sec == false)
	{
		$string .= $sec.'s';
	}
	
	return $string; 
}

function string_to_ahref($string)
{
	$return = '<a href="'.$string.'" target="_blank" rel="noreferrer">'.htmlspecialchars($string, ENT_QUOTES|ENT_HTML5).'</a>';
	return $return;
}

function parse_urls_to_ahref($array)
{
	$return = '';
	foreach($array as $line)
	{
		// Replace TABS with a space
		$line = str_replace('	', ' ', $line);
		$words = explode(' ', $line);
		foreach($words as $word)
		{
			if(($parsed_word = parse_url($word)) !== false)
			{
				if(isset($parsed_word['scheme']) && isset($parsed_word['host']) && !empty($parsed_word['scheme']) && !empty($parsed_word['host']))
				{
					// http://blalba.com
					if($parsed_word['scheme'] == 'http' || $parsed_word['scheme'] == 'https')
					{
						$return .= string_to_ahref($word);
					}
					else
					{
						$return .= htmlspecialchars($word, ENT_QUOTES|ENT_HTML5);
					}
				}
				else
				{
					$return .= htmlspecialchars($word, ENT_QUOTES|ENT_HTML5);
				}
			}
			else
			{
				$return .= htmlspecialchars($word, ENT_QUOTES|ENT_HTML5);
			}
			$return .= ' ';
		}
		$return .= '<br>'.PHP_EOL;
	}
	return $return;
}

if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true)
{
	if(isset($_GET['user']) && !empty($_GET['user']))
	{
		// mysql connection
		$mysqli = @new mysqli('betterdesk-mysql.cunim1xnmwzu.us-west-1.rds.amazonaws.com', 'twitch_reports_read', '5pcNl7VZ4hrP9s8N', 'twitch_reports');
		if($mysqli->connect_errno)
		{
			echo 'Report history DB is currently not available.';
			// echo 'Connection to database failed: '.$mysqli->connect_error;
			exit();
		}
		// Set charset of the connection to uf8mb4
		$mysqli->set_charset('utf8mb4');
		
		
		if(isset($_GET['manual']) && $_GET['manual'] == 'true')
		{
			echo '<!DOCTYPE html>'.PHP_EOL.'<html>'.PHP_EOL.'<head>';
			if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on')
			{
				echo PHP_EOL.'<link href="css/darkmode.css" rel="stylesheet">'.PHP_EOL;
				echo '<style>a { color: #337ab7; text-decoration: none; background-color: transparent; }</style>'.PHP_EOL;
			}
			echo '</head>'.PHP_EOL.'<body>'.PHP_EOL;
			echo '<div class="well">'.PHP_EOL;
			echo '<form id="tos_history_form" action="" method="GET">'.PHP_EOL;
			echo '<input type="hidden" name="manual" value="true">'.PHP_EOL;
			echo '<input type="text" name="user" value="" size="25" maxlength="250" placeholder="Username">'.PHP_EOL;
			echo '<button type="Submit">Check History</button>'.PHP_EOL;
			echo '</form>'.PHP_EOL;
			echo '<h3>Channel:</h3> <a href="https://www-origin.twitch.tv/'.rawurlencode($_GET['user']).'" target="_blank" rel="noreferrer">'.htmlspecialchars($_GET['user'], ENT_QUOTES|ENT_HTML5).'</a><br><br><hr>'.PHP_EOL;
		}
		
		$db_query = $mysqli->query("SELECT `desk_caseID`,`from_user_username`,`from_admin`,`report_reason`,`report_time`,`report_description` FROM `report_mails` WHERE `target_user` = '".$mysqli->real_escape_string($_GET['user'])."' AND `from_admin` = 'true' AND `is_strike` = 'true' ORDER BY `report_time` DESC");
		$TOS_display_counter = 0;
		if($db_query->num_rows > 0)
		{
			echo '<div class="report-history" style="word-wrap: break-word;">'.PHP_EOL;
			while($row = $db_query->fetch_assoc())
			{
				if((isset($_GET['auto_load']) && $_GET['auto_load'] == 'true' && $TOS_display_counter == 0) || !isset($_GET['auto_load']))
				{
					echo '<div class="well first-tos-history-entry">'.PHP_EOL;
					echo 'From: '.htmlspecialchars($row['from_user_username'], ENT_QUOTES|ENT_HTML5);
					if(!empty($row['desk_caseID']))
					{
						echo ' (<a href="https://help.twitch.tv/agent/case/'.rawurlencode($row['desk_caseID']).'" target="_blank" rel="noreferrer">View in Desk</a>)';
					}
					echo '<br>'.PHP_EOL;
					echo 'Date: '.htmlspecialchars(time_to_pst_time($row['report_time']), ENT_QUOTES|ENT_HTML5).' - ('.sec_to_nice_time(time() - strtotime($row['report_time']), true).' ago)<br>'.PHP_EOL;
					echo 'Reason: '.htmlspecialchars($row['report_reason'], ENT_QUOTES|ENT_HTML5).'<br>'.PHP_EOL;
					echo 'Description:<br>'.PHP_EOL;
					if(isset($_GET['auto_load']) && $_GET['auto_load'] == 'true')
					{
						$max_description_lines = 9;
						if(substr_count(str_replace(array("\r\n", "\r"), "\n", $row['report_description']), "\n") > $max_description_lines)
						{
							echo parse_urls_to_ahref(array_slice(explode("\n", str_replace(array("\r\n", "\r"), "\n", $row['report_description'])), 0, $max_description_lines)).' <b>...</b><br>'.PHP_EOL;
						}
						else
						{
							echo parse_urls_to_ahref(explode("\n", str_replace(array("\r\n", "\r"), "\n", $row['report_description']))).'<br>'.PHP_EOL;
						}
					}
					else
					{
						echo parse_urls_to_ahref(explode("\n", str_replace(array("\r\n", "\r"), "\n", $row['report_description']))).'<br>'.PHP_EOL;
					}
					echo '</div>'.PHP_EOL;
					echo '<hr>'.PHP_EOL;
				}
				elseif(isset($_GET['auto_load']) && $_GET['auto_load'] == 'true' && $TOS_display_counter == 1)
				{
					echo '<div class="well">'.PHP_EOL;
					echo htmlspecialchars('+'.($db_query->num_rows - 1).' other / older TOS reports. Click on the "TOS History" button above to display them.', ENT_QUOTES|ENT_HTML5);
					echo '</div>'.PHP_EOL;
					echo '<hr>'.PHP_EOL;
				}
				$TOS_display_counter = $TOS_display_counter + 1;
			}
			echo '</div>';
		}
		else
		{
			echo 'No TOS found for this user!<br><hr>'.PHP_EOL;
		}
		$db_query->free();
	}
	else
	{
		if(isset($_GET['manual']) && $_GET['manual'] == 'true')
		{
			echo '<!DOCTYPE html>'.PHP_EOL.'<html>'.PHP_EOL.'<head>';
			if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on')
			{
				echo PHP_EOL.'<link href="css/darkmode.css" rel="stylesheet">'.PHP_EOL;
				echo '<style>a { color: #337ab7; text-decoration: none; background-color: transparent; }</style>'.PHP_EOL;
			}
			echo '</head>'.PHP_EOL.'<body>'.PHP_EOL;
			echo '<div class="well">'.PHP_EOL;
		}
		
		if(isset($_GET['user']))
		{
			echo 'No username for lookup provided!<br>'.PHP_EOL;
		}
		echo '<form id="tos_history_form" action="" method="GET">'.PHP_EOL;
		echo '<input type="hidden" name="manual" value="true">'.PHP_EOL;
		echo '<input type="text" name="user" value="" size="25" maxlength="250" placeholder="Username">'.PHP_EOL;
		echo '<button type="Submit">Check History</button>'.PHP_EOL;
		echo '</form>'.PHP_EOL;
		echo '<hr>'.PHP_EOL;
	}
	
	if(isset($_GET['manual']) && $_GET['manual'] == 'true')
	{
		echo '</div>'.PHP_EOL.'</body>'.PHP_EOL.'</html>';
	}
}
else
{
	echo 'Authentication failed!<br>'.PHP_EOL;
	echo 'Please <a href="index.php?login_redirect=report_history">login</a><br><hr>'.PHP_EOL;
}
?>