<?php
// ÜÖÄ UTF8-FTW
require_once __DIR__ . '/RedisSessionHandler.php';
$sessHandler = new RedisSessionHandler(null, null, null, null, true);
session_set_save_handler($sessHandler);
session_start();
// We don't change anything in the session so we can close writes here
@session_write_close();

header('Cache-Control: no-store, no-cache, must-revalidate');
header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
header('Pragma: no-cache');
$http_or_https = '';
if(!empty($_SERVER['HTTPS']))
{
	$http_or_https = 'https';
}
else
{
	$http_or_https = 'http';
}

require_once '_functions.php';
require __DIR__ . '/libs/aws-autoloader.php';
use Aws\S3\S3Client;


function get_current_pst_time($exact = false)
{
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));
	if($exact === true)
	{
		$return = $dateTime->format('r (T)');
	}
	else
	{
		$return = $dateTime->format('Y-m-d');
	}
	return $return;
}

function create_info_img_for_channel_image($file_name, $username, $image_type_string)
{
	$font_file = __DIR__ . '/fonts/consola.ttf';
	$file_info = getimagesize($file_name);

	// Couldn't get the image info
	if($file_info === false)
	{
		return;
	}

	// If it's not the right size don't do anything
	if($file_info[0] <= 0 || $file_info[1] <= 0)
	{
		return;
	}

	if($file_info[2] === IMG_GIF)
	{
		$org_img = imagecreatefromgif($file_name);
	}
	elseif($file_info[2] === IMG_JPG)
	{
		$org_img = imagecreatefromjpeg($file_name);
	}
	elseif($file_info[2] === IMG_PNG || $file_info[2] === 3 /* 3 and 4 (IMG_PNG) are png for some reason */)
	{
		$org_img = imagecreatefrompng($file_name);
	}
	else
	{
		return;
	}

	if($org_img === false)
	{
		// Error loading org file
		return;
	}

	// Create image and colors
	$new_size['x'] = $file_info[0] + 20;
	if($new_size['x'] < 360)
	{
		// We need this size if we have 25 char usernames
		$new_size['x'] = 360;
	}
	$new_size['y'] = $file_info[1] + 60;
	$new_img = imagecreatetruecolor($new_size['x'], $new_size['y']);
	// Allocate colors
	$color[0] = imagecolorallocate($new_img, 210, 210, 210); // light gray
	$color[1] = imagecolorallocate($new_img, 180, 180, 180); // darker gray


	// Add "info" text -------------
	// User:
	imagettftext($new_img, 17, 0, 5, 18, $color[0], $font_file, 'User:');
	// User value
	imagettftext($new_img, 15, 0, 70, 18, $color[1], $font_file, $username);
	// Offline image:
	imagettftext($new_img, 17, 0, 5, 42, $color[0], $font_file, $image_type_string);

	// Transparent Background (so that offline images display correctly)
	imagealphablending($new_img, false);
	imagesavealpha($new_img, true);

	// Copy original
	imagecopy($new_img, $org_img, (10 + round(($new_size['x'] - ($file_info[0] + 20)) / 2)), 50, 0, 0, $file_info[0], $file_info[1]);

	if($file_info[2] === IMG_GIF)
	{
		imagegif($new_img, $file_name);
	}
	elseif($file_info[2] === IMG_JPG)
	{
		imagejpeg($new_img, $file_name, 100);
	}
	elseif($file_info[2] === IMG_PNG || $file_info[2] === 3 /* 3 and 4 (IMG_PNG) are png for some reason */)
	{
		imagepng($new_img, $file_name);
	}
	imagedestroy($new_img);
}

function gen_random_string($length)
{
	static $abc = array('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
						'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
						'0','1','2','3','4','5','6','7','8','9');
	$string = '';
	$counter = 0;
	for($i = 0; $i < $length; $i++)
	{
		$string .= $abc[mt_rand(0, count($abc) - 1)];
	}
	return $string;
}


// Screenshot upload history
if(isset($_GET['history']))
{
	if(isset($_SESSION['auth']) && $_SESSION['auth'] === true)
	{
		$upload_history_array = array();
		$fp = fopen(__DIR__ . '/screenshot_upload_s3.log', 'rb');
		$pos = 0;
		$history_display_limit = 100;

		$history_counter = 0;
		$currentLine = '';
		while(-1 !== fseek($fp, $pos, SEEK_END))
		{
			$char = fgetc($fp);
			if(PHP_EOL == $char)
			{
				if(!empty(trim($currentLine)) && $history_counter < $history_display_limit)
				{
					// echo $currentLine.PHP_EOL;
					$currentLine_json = json_decode($currentLine, true);
					$upload_history_array[] = array('url' => $currentLine_json['final_upload_url'], 'uploader' => $currentLine_json['by_user'], 'timestamp' => $currentLine_json['timestamp']);
					$history_counter++;
				}
				$currentLine = '';
			}
			else
			{
				$currentLine = $char . $currentLine;
			}
			$pos--;
		}
		// output first line of the file
		if(!empty(trim($currentLine)) && $history_counter < $history_display_limit)
		{
			// echo $currentLine.PHP_EOL;
			$currentLine_json = json_decode($currentLine, true);
			$upload_history_array[] = array('url' => $currentLine_json['final_upload_url'], 'uploader' => $currentLine_json['by_user'], 'timestamp' => $currentLine_json['timestamp']);
		}
		// print_r($upload_history_array);

		if(count($upload_history_array) > 0)
		{
?><!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="referrer" content="origin">
<link id="favicon" rel="icon" type="image/x-icon" href="favicon.ico">
<title>Screenshot upload - History</title>
</head>
<body>
<table border="1">
<thead>
	<tr>
		<th style="max-width:300px;width:200px;text-align:left;">Image</th>
		<th style="max-width:200px;width:200px;text-align:center;">Channel</th>
		<th style="max-width:200px;width:200px;text-align:center;">Uploaded by</th>
		<th style="max-width:200px;width:200px;text-align:center;">Timestamp</th>
	</tr>
</thead>
<tbody>
<?php
			foreach($upload_history_array as $history_entry)
			{
				echo '<tr>';
				echo '<td style="max-width:300px;width:200px;text-align:left;"><a href="'.$history_entry['url'].'" rel="noreferrer"><img src="'.$history_entry['url'].'" style="max-height:100px;max-width:295px"></a></td>';
				echo '<td style="max-width:200px;width:200px;text-align:center;">'.htmlspecialchars(explode('-', basename($history_entry['url']))[0], ENT_QUOTES|ENT_HTML5).'</td>';
				echo '<td style="max-width:200px;width:200px;text-align:center;">'.htmlspecialchars($history_entry['uploader'], ENT_QUOTES|ENT_HTML5).'</td>';
				echo '<td style="max-width:200px;width:200px;text-align:right;">'.time_to_pst_time($history_entry['timestamp']).'</td>';
				echo '</tr>'.PHP_EOL;
			}
?>
</tbody>
</table>
<br>
</body>
</html>
<?php
		}
		else
		{
			echo 'No file has been uploaded yet.'.PHP_EOL;
		}
	}
	else
	{
		echo 'You need to <a href="/">login</a> to view the screenshot upload history!'.PHP_EOL;
	}
	exit();
}


/*
if()
{
*/
	$upload_done = false;
	$channel_is_partner = false;
	if($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST))
	{
		// Set redirect cookie
		if(!isset($_POST['ajax']) || $_POST['ajax'] != 'true')
		{
			if(isset($_POST['redirect_to_report']) && $_POST['redirect_to_report'] == 'true')
			{
				setcookie('redirect_after_upload', 'true', time()+60*60*24*365);
				// Change it for the script because we might use it later
				$_COOKIE['redirect_after_upload'] = 'true';
			}
			else
			{
				setcookie('redirect_after_upload', 'false', time()+60*60*24*365);
				// Change it for the script because we might use it later
				$_COOKIE['redirect_after_upload'] = 'false';
			}
		}


		$error_msg = '';
		if(empty(trim($_POST['channel'])))
		{
			$error_msg .= 'You need to enter a channel.<br>'.PHP_EOL;
		}
		if(!empty(trim($_POST['channel'])) && preg_match('/[^a-zA-Z0-9_]/', trim($_POST['channel'])) === 1)
		{
			$error_msg .= 'This is not a valid channel name ...<br>'.PHP_EOL;
		}
		if(empty($_POST['image']) && $_FILES['file_data']['error'] != 0 && empty($_POST['url']))
		{
			$error_msg .= 'You need to insert an image, file or URL.<br>'.PHP_EOL;
		}
		// Only check if the user is logged in (because it doesn't matter for anonymouse anyway)
		if(isset($_SESSION['auth']) && $_SESSION['auth'] === true)
		{
			if(!isset($_POST['csrf_token']) || validate_csrf_token($_POST['csrf_token']) === false)
			{
				$error_msg .= 'Could not verify your request.<br>'.PHP_EOL;
			}
		}

		if(empty($error_msg))
		{
			$log_array = array();
			if($_FILES['file_data']['error'] === 0)
			{
				// Use the selected / uploaded file
				$temp_file_name = $_FILES['file_data']['tmp_name'];
				$file_ext = explode('/', $_FILES['file_data']['type'])[1];
				$log_array['type'] = 'file';
			}
			elseif(isset($_POST['url']) && !empty($_POST['url']))
			{
				// Downloaden
				$log_array['type'] = 'url';
				$log_array['url'] = $_POST['url'];
				
				// Check if the URL is allowed
				$parsed_url = parse_url($_POST['url']);
				if($parsed_url === false || !in_array($parsed_url['host'], array('www-origin.twitch.tv', 'www.twitch.tv', 'twitch.tv', 'twitch-images.rootonline.de', 'static-cdn.jtvnw.net', 'static.justin.tv', 'twitch-desk.rootonline.de', 'web-cdn.ttvnw.net', 's3.amazonaws.com')))
				{
					$error_msg .= 'This URL is not whitelisted. Due to NDA restrictions you shouldn&#039;t use 3rd party sites to upload your screenshots anyway.<br>'.PHP_EOL;
					goto end_of_upload;
				}
				$curl_download_time_start = microtime(true);
				$temp_file_name = tempnam('/tmp', 'php');
				$handle = fopen($temp_file_name, 'wb');
				if($handle === false)
				{
					echo 'Error while creating temp file!';
					exit;
				}

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_FILE, $handle);
				curl_setopt($ch, CURLOPT_TIMEOUT, 20);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
				curl_setopt($ch, CURLOPT_HEADER, false);
				curl_setopt($ch, CURLOPT_ENCODING, '');
				curl_setopt($ch, CURLOPT_URL, $_POST['url']);
				curl_exec($ch);

				$curl_info = curl_getinfo($ch);
				if($curl_info['content_type'] == 'image/jpeg')
				{
					$file_ext = 'jpg';
				}
				elseif($curl_info['content_type'] == 'image/gif')
				{
					$file_ext = 'gif';
				}
				elseif($curl_info['content_type'] == 'image/png')
				{
					$file_ext = 'png';
				}
				else
				{
					$error_msg .= 'Could not download a valid image, please try again.<br>'.PHP_EOL;
					$log_array['url_download_curl_info_array'] = $curl_info;
					goto end_of_upload;
				}

				curl_close($ch);
				fclose($handle);

				$log_array['url_download_time'] = microtime(true) - $curl_download_time_start;
				$log_array['url_download_time_curl'] = $curl_info['total_time'];

				// Check if it's a profile image and if so create the "screenshot"
				$preg_match_matches = null;
				if(preg_match('/^http[s]?:\/\/(static\-cdn\.jtvnw\.net|twitch\-images\.rootonline\.de\/cdn\-proxy|twitch\-desk\.rootonline\.de\/stream\-preview\-image)\/jtv_user_pictures\/([a-z0-9_]+)\-profile_image\-[a-z0-9]+\-600x600\.[a-z]+$/i', $_POST['url'], $preg_match_matches) === 1)
				{
					$placeholder_string = 'profile image';
					$new_img_create_time_start = microtime(true);
					create_info_img_for_channel_image($temp_file_name, $preg_match_matches[2], 'Profile image:');
					$log_array['new_img_create_time'] = microtime(true) - $new_img_create_time_start;
				}
				elseif(preg_match('/^http[s]?:\/\/(static\-cdn\.jtvnw\.net|twitch\-images\.rootonline\.de\/cdn\-proxy|twitch\-desk\.rootonline\.de\/stream\-preview\-image)\/jtv_user_pictures\/([a-z0-9_]+)\-profile_banner\-[a-z0-9]+\-[0-9]+\.[a-z]+$/i', $_POST['url'], $preg_match_matches) === 1)
				{
					$placeholder_string = 'profile banner';
					$new_img_create_time_start = microtime(true);
					create_info_img_for_channel_image($temp_file_name, $preg_match_matches[2], 'Profile banner:');
					$log_array['new_img_create_time'] = microtime(true) - $new_img_create_time_start;
				}
				elseif(preg_match('/^http[s]?:\/\/(static\-cdn\.jtvnw\.net|twitch\-images\.rootonline\.de\/cdn\-proxy|twitch\-desk\.rootonline\.de\/stream\-preview\-image)\/jtv_user_pictures\/([a-z0-9_]+)\-channel_offline_image\-[a-z0-9]+\-[0-9]+x[0-9]+\.[a-z]+$/i', $_POST['url'], $preg_match_matches) === 1)
				{
					$placeholder_string = 'offline image';
					$new_img_create_time_start = microtime(true);
					create_info_img_for_channel_image($temp_file_name, $preg_match_matches[2], 'Offline image:');
					$log_array['new_img_create_time'] = microtime(true) - $new_img_create_time_start;
				}
			}
			else
			{
				$log_array['type'] = 'paste';
				// Use the pasted image
				// No error so generate the file to upload
				$temp_file_name = tempnam('/tmp', 'php');
				$handle = fopen($temp_file_name, 'wb');

				$file_binary = base64_decode(explode(',', $_POST['image'])[1]);
				if($file_binary === false)
				{
					$error_msg .= 'This is not a valid image / file.<br>'.PHP_EOL;
					goto end_of_upload;
				}
				fwrite($handle, $file_binary);
				unset($file_binary);
				fclose($handle);

				$file_ext = explode(';', explode('/', explode(',', $_POST['image'])[0])[1])[0];

				unset($_POST['image']);
			}

			if(empty($file_ext))
			{
				$error_msg .= 'Couldn\'t get the file extension of the upload.<br>'.PHP_EOL;
				goto end_of_upload;
			}

			// Create S3 client
			$s3Client = new S3Client([
				'version'     => 'latest',
				'region'      => 'us-west-1',
				'credentials' => [
					'key'    => 'AKIAJNUJ4XQPWP5EO7YA',
					'secret' => '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',
				],
			]);

			// Target filename after upload
			$target_filename = 'screenshots/'.gen_random_string(16).'/'.mb_strtolower(trim($_POST['channel'])).'--'.get_current_pst_time().'.'.$file_ext;

			if($file_ext == 'png' || $file_ext == 'gif')
			{
				$upload_content_type = 'image/'.$file_ext;
			}
			elseif($file_ext == 'jpg')
			{
				$upload_content_type = 'image/jpeg';
			}
			else
			{
				$upload_content_type = 'application/octet-stream';
			}

			$upload_time_start = microtime(true);
			$result = $s3Client->putObject(array(
					'Bucket'     => 'ttv-moderation',
					'Key'        => $target_filename,
					'SourceFile' => $temp_file_name,
					'ContentType' => $upload_content_type,
					'ACL' => 'public-read'
			));

			// We can poll the object until it is accessible
			$s3Client->waitUntil('ObjectExists', array(
				'Bucket' => 'ttv-moderation',
				'Key' => $target_filename
			));
			$log_array['file_upload_time'] = microtime(true) - $upload_time_start;
			$final_upload_url = $result['ObjectURL'];

			if(empty($final_upload_url))
			{
				$error_msg .= 'Couldn\'t get the file upload URL.<br>'.PHP_EOL;
				goto end_of_upload;
			}
			else
			{
				$log_array['final_upload_url'] = $final_upload_url;
				// Reset error_msg so we don't display it if it worked after a few tries
				$error_msg = '';
			}

			$upload_done = true;

			$ch = curl_init();
			// Check if channel is partnered
			$curl_partner_check_time_start = microtime(true);
			curl_reset($ch);
			$url = 'https://api.twitch.tv/channels/'.rawurlencode(mb_strtolower(trim($_POST['channel'])));
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_TIMEOUT, 25);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:', 'Accept: application/vnd.twitchtv.v3+json'));
			curl_setopt($ch, CURLOPT_ENCODING, '');
			$curl_exec = curl_exec($ch);
			$curl_info = curl_getinfo($ch);

			$json_decode = json_decode($curl_exec, true);
			if($json_decode !== NULL && isset($json_decode['_id']) && isset($json_decode['partner']))
			{
				$channel_is_partner = $json_decode['partner'];
			}
			$log_array['partner_check_time'] = microtime(true) - $curl_partner_check_time_start;
			$log_array['partner_check_time_curl'] = $curl_info['total_time'];

			curl_close($ch);

			end_of_upload:
			if(isset($temp_file_name) && file_exists($temp_file_name)) unlink($temp_file_name);

			if(isset($_SESSION['auth']) && $_SESSION['auth'] === true && isset($_SESSION['user']['username']) && !empty($_SESSION['user']['username']))
			{
				$log_array['by_user'] = $_SESSION['user']['username'];
			}
			$log_array['timestamp'] = date('c');
			if(isset($error_msg) && !empty($error_msg))
			{
				$log_array['error_msg'] = $error_msg;
			}
			// Add log entry
			file_put_contents(__DIR__ . '/screenshot_upload_s3.log', json_encode($log_array).PHP_EOL, FILE_APPEND | LOCK_EX);

		}

		// var_dump($_POST);
	}
	if($upload_done === false)
	{
?><!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="referrer" content="origin">
<link id="favicon" rel="icon" type="image/x-icon" href="favicon.ico">
<title>Paste to upload</title>
<?php if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on') echo '<link href="css/darkmode.css" rel="stylesheet">'.PHP_EOL; ?>
<script type="text/javascript" src="js/jquery.min.js"></script>
<script type='text/javascript'>
function Upload()
{
	button = document.getElementById("uploadbutton");
	// button.style.fontWeight = "normal";
	$("#upload-form")[0].submit();
	button.value = " Uploading... ";
	button.disabled = true;
}

if(navigator.userAgent.toLowerCase().indexOf('firefox') > -1)
{
	/* Handle paste events */
	function pasteHandler(e) {
		// We need to check if event.clipboardData is supported (Chrome)
		if (e.clipboardData) {
			// Get the items from the clipboard
			var items = e.clipboardData.items;
				if (items) {
				// Loop through all items, looking for any kind of image
				for (var i = 0; i < items.length; i++) {
					if (items[i].type.indexOf("image") !== -1) {
					   // We need to represent the image as a file,
					   var blob = items[i].getAsFile();
					   // and use a URL or webkitURL (whichever is available to the browser)
					   // to create a temporary URL to the object
					   var URLObj = window.URL || window.webkitURL;
					   var source = URLObj.createObjectURL(blob);

					   // The URL can then be used as the source of an image
					   createImage(source);
					}
				}
			}
		// If we can't handle clipboard data directly (Firefox),
		// we need to read what was pasted from the contenteditable element
		}
		// else {
			// This is a cheap trick to make sure we read the data
			// AFTER it has been inserted.
			setTimeout(checkInput, 1);
		// }
	}

	/* Parse the input in the paste catcher element */
	function checkInput() {
		var pasteCatcher = document.getElementById("paste_area");
		// Store the pasted content in a variable
		var child = pasteCatcher.childNodes[0];
		console.log(child.src);
		// Clear the inner html to make sure we're always
		// getting the latest inserted content
		pasteCatcher.innerHTML = "";

		document.getElementById('image_paste').value = child.src;
		document.getElementById('pasted_image').src = child.src;
		document.getElementById("paste_area").remove();

		/*
		if (child) {
			// If the user pastes an image, the src attribute
			// will represent the image as a base64 encoded string.
			if (child.tagName === "IMG") {
			 createImage(child.src);
			}
		}
		*/
	}

	/* Creates a new image from a given source */
	function createImage(source) {
		var pastedImage = new Image();
		pastedImage.onload = function() {
			// You now have the image!
		}
		pastedImage.src = source;
	}

	// Add the paste event listener
	window.addEventListener("paste", pasteHandler);
}

$(document).ready(function () {
	$(document).keypress(function(ev){
		if (ev.keyCode == 13) {
			$("#upload-form")[0].submit();
		}
	});
});
</script>
</head>
<body>
<?php
	if(isset($error_msg) && !empty($error_msg))
	{
		echo '<h2><span class="col-md-9">'.PHP_EOL.$error_msg.'</span></h2>'.PHP_EOL.'<br>'.PHP_EOL;
	}
?>
<h4><span class="col-md-9">It's easy, just fill out the channel, click into the box right to Image and "Right click => paste" or "Ctrl + v" and the image should appear on the screen.<br>
Then click upload and you will get the link of the file and also a quick report link too.</span></h4><br>
<table>
<form method="post" id="upload-form" enctype="multipart/form-data" action="" onsubmit="javascript:Upload(); return true;">
<input type="hidden" name="csrf_token" value="<?php if(isset($_SESSION['csrf_token']) && !empty($_SESSION['csrf_token'])) echo $_SESSION['csrf_token']; ?>">
<input type="hidden" id="image_paste" name="image" value="">
<tr>
	<td class="left"><span class="col-md-9">Channel:</span></td>
	<td class="right"><input name="channel" type="text" pattern="[a-zA-Z0-9_]{1,50}" value="<?php if(isset($_POST['channel']) && !empty($_POST['channel'])) { echo htmlspecialchars(mb_strtolower(trim($_POST['channel'])), ENT_QUOTES|ENT_HTML5); } else if (isset($_GET['channel']) && !empty($_GET['channel'])) { echo htmlspecialchars(mb_strtolower(trim($_GET['channel'])), ENT_QUOTES|ENT_HTML5); }?>" size="30" required></td>
</tr>
<tr>
	<td class="left"><span class="col-md-9">Image:</span></td>
	<td class="right"><div id="paste_area" contenteditable="true" style="width:350px; height:230px;background-color:#E6E6E6;"></div><img id="pasted_image" alt="" style="max-height: 245px;"></td>
</tr>
<tr>
	<td class="left"><span class="col-md-9">Or file:</span></td>
	<td class="right"><input name="file_data" type="file" size="25" accept="image/*"></td>
</tr>
<tr>
	<td class="left"><span class="col-md-9">Or URL:</span></td>
	<td class="right"><input name="url" type="url" size="45"></td>
</tr>
<tr>
	<td class="left"><span class="col-md-9">Redirect to<br>report form:</span></td>
	<td class="right"><br><input type="checkbox" name="redirect_to_report" value="true" <?php if(isset($_COOKIE['redirect_after_upload']) && $_COOKIE['redirect_after_upload'] == 'true') echo 'checked'; ?>></td>
</tr>
<tr>
	<td></td>
	<td class="right"><br>
		<input type="submit" id="uploadbutton" value="Upload"><br><br>
	</td>
</tr>
</form>
</table>
<script type='text/javascript'>
window.onload=function() {
	if(navigator.userAgent.toLowerCase().indexOf('firefox') > -1)
	{
		// Nothing
	}
	else
	{
		// Chrome which is working
		document.getElementById('paste_area').onpaste = function (event) {
			// use event.originalEvent.clipboard for newer chrome versions
			var items = (event.clipboardData  || event.originalEvent.clipboardData).items;
			// console.log(JSON.stringify(items)); // will give you the mime types
			// find pasted image among pasted items
			var blob;
			for (var i = 0; i < items.length; i++) {
				if (items[i].type.indexOf("image") === 0) {
					blob = items[i].getAsFile();
				}
			}
			// load image if there is a pasted image
			if (blob !== null) {
				var reader = new FileReader();
				reader.onload = function(event) {
					console.log(event.target.result); // data url!
					document.getElementById('image_paste').value = event.target.result;
					document.getElementById('pasted_image').src = event.target.result;
					document.getElementById("paste_area").remove();
				};
				reader.readAsDataURL(blob);
			}
		}
	}
}
</script>
</body>
</html>
<?php
	}
	else
	{
		if(isset($_POST['ajax']) && $_POST['ajax'] == 'true') /* Only used for channel images atm, if used for something else the content, reason and detailed reason should be removed from the link */
		{
			if(!isset($placeholder_string) || empty($placeholder_string)) $placeholder_string = '';
			if($channel_is_partner === false)
			{
				echo '<a class="btn btn-default btn-link" href="https://www-origin.twitch.tv/'.rawurlencode(mb_strtolower(trim($_POST['channel']))).'/report_form?tos_ban=true&amp;quick-select=channel_images-porn-sexual_suggestive_content&amp;placeholder[LOCATION_OF_CONTENT]='.rawurlencode($placeholder_string).'&amp;description='.rawurlencode($final_upload_url).'" target="_blank" rel="noreferrer">Report Link</a>';
			}
			else
			{
				echo '<a class="btn btn-default btn-link" href="'.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].'/index.php?partnerconduct_report=true&amp;target_user='.rawurlencode(mb_strtolower(trim($_POST['channel']))).'&amp;placeholder[LOCATION_OF_CONTENT]='.rawurlencode($placeholder_string).'&amp;description='.rawurlencode($final_upload_url).'" target="_blank" rel="noreferrer">PartnerConduct Link</a>';
			}
			exit();
		}
		elseif(isset($_COOKIE['redirect_after_upload']) && $_COOKIE['redirect_after_upload'] == 'true')
		{
			if($channel_is_partner === false)
			{
				header('Location: https://www-origin.twitch.tv/'.rawurlencode(mb_strtolower(trim($_POST['channel']))).'/report_form?tos_ban=true&description='.rawurlencode($final_upload_url), true, 302);
			}
			else
			{
				header('Location: '.$GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST'].'/index.php?partnerconduct_report=true&target_user='.rawurlencode(mb_strtolower(trim($_POST['channel']))).'&description='.rawurlencode($final_upload_url), true, 302);
			}
			exit();
		}
		else
		{
?><!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="referrer" content="origin">
<link id="favicon" rel="icon" type="image/x-icon" href="favicon.ico">
<title>File successfully uploaded</title>
<?php if(isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] == 'on') echo '<link href="css/darkmode.css" rel="stylesheet">'.PHP_EOL; ?>
</head>
<body>
<?php
	if(isset($error_msg) && !empty($error_msg))
	{
		echo '<h2><span class="col-md-9">'.PHP_EOL.$error_msg.'</span></h2>'.PHP_EOL.'<br>'.PHP_EOL;
	}
?>
<span class="col-md-9">
Your file has been successfully uploaded! (<a class="btn-default" href="">Upload more</a>)<br>
URL: <a class="btn-default" href="<?php echo $final_upload_url; ?>" target="_blank" rel="noreferrer"><?php echo htmlspecialchars($final_upload_url, ENT_QUOTES|ENT_HTML5); ?></a><br>
URL in a box: <input type="text" readonly="readonly" onclick="javascript:this.focus(); this.select();" size="110" value="<?php echo htmlspecialchars($final_upload_url, ENT_QUOTES|ENT_HTML5); ?>"><br>
<?php
	if($channel_is_partner === false)
	{
?>
Report link: <a class="btn-default" href="https://www-origin.twitch.tv/<?php echo rawurlencode(mb_strtolower(trim($_POST['channel']))); ?>/report_form?tos_ban=true&amp;description=<?php echo rawurlencode($final_upload_url); ?>" target="_blank" rel="noreferrer">Click me</a><br>
Report link in a box: <input type="text" readonly="readonly" onclick="javascript:this.focus(); this.select();" size="90" value="https://www-origin.twitch.tv/<?php echo rawurlencode(mb_strtolower(trim($_POST['channel']))); ?>/report_form?tos_ban=true&amp;description=<?php echo rawurlencode($final_upload_url); ?>"><br>
<?php
	}
	else
	{
?>
PartnerConduct link: <a class="btn-default" href="/index.php?partnerconduct_report=true&amp;target_user=<?php echo rawurlencode(mb_strtolower(trim($_POST['channel']))); ?>&amp;description=<?php echo rawurlencode($final_upload_url); ?>" target="_blank" rel="noreferrer">Click me</a><br>
PartnerConduct link in a box: <input type="text" readonly="readonly" onclick="javascript:this.focus(); this.select();" size="90" value="<?php echo $GLOBALS['http_or_https'].'://'.$_SERVER['HTTP_HOST']; ?>/index.php?partnerconduct_report=true&amp;target_user=<?php echo rawurlencode(mb_strtolower(trim($_POST['channel']))); ?>&amp;description=<?php echo rawurlencode($final_upload_url); ?>"><br>
<?php
	}
?>
Preview:<br>
<img src="<?php echo $final_upload_url; ?>"><br>
</span>
</body>
</html>
<?php
		}
	}
/*
}
else
{
	// Show login form
	include 'login_form.php';
}
*/
?>