<?php
// äüö UTF8-FTW
set_time_limit(30);

// General settings
$team_id = 'T1YRBFJNT';
$admin_room_id = 'G1ZFUGXU6';
$general_room_id = 'G1ZG2HADB';
$allowed_tokens = array('XfnQ3d4iSmMgLYdC9W8HBKx4' /* /duty */,
						'TYccA5utJfqk85Oumbiz02T2' /* /duty2 */,
						'WXYoS0AI6H6Zv1DKa3G6cvzZ' /* /time */);
$bot_token = 'xoxb-68273290868-rsnBbI1yEwwa5gsR9mkljG6N';


// Connect to DB to do our stuff
$mysqli = new mysqli('betterdesk-mysql.cunim1xnmwzu.us-west-1.rds.amazonaws.com', 'twitch_slack', '1QVOjPucJT0EwCyU', 'twitch_slack');
if($mysqli->connect_error)
{
	echo 'The duty reminder is currently not available, please try again later.';
	exit();
}


function get_current_onDuty_from_DB() {
	$array = array('primary' => array('current' => '', 'next' => ''), 'secondary' => array('current' => '', 'next' => ''));

	// Mysql query
	$result = $GLOBALS['mysqli']->query("SELECT `type`,`current`, `next` FROM `currents` WHERE `type` IN ('primary','secondary')");
	if($result && $result->num_rows > 0)
	{
		while($row = $result->fetch_assoc())
		{
			$array[$row['type']]['current'] = $row['current'];
			$array[$row['type']]['next'] = $row['next'];
		}
		// free result set
		$result->close();
	}

	return $array;
}

function set_onDuty_topics()
{
	$ch = curl_init();

	$db_current_onDuty = get_current_onDuty_from_DB();

	$topic = 'Current: 1. '.$db_current_onDuty['primary']['current'].', 2. '.$db_current_onDuty['secondary']['current'].' - Next: 1. '.$db_current_onDuty['primary']['next'].', 2. '.$db_current_onDuty['secondary']['next'].' @ '.get_next_primary_time().':00 '.get_timezone_string().', '.get_next_secondary_time().':00 '.get_timezone_string();

	// Admins group
	admins_channel:
	curl_reset($ch);
	$post_content = array('token' => $GLOBALS['bot_token'], 'channel' => $GLOBALS['admin_room_id'], 'topic' => $topic);
	curl_setopt($ch, CURLOPT_URL, 'https://slack.com/api/groups.setTopic');
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:'));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
	curl_setopt($ch, CURLOPT_ENCODING, '');
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_content);
	$curl_exec = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_info['http_code'] == 200)
	{
		$json_decode = json_decode($curl_exec, true);
		if($json_decode !== NULL && isset($json_decode['ok']) && $json_decode['ok'] === true)
		{
			// echo 'Updated topic for the "admins" private group';
		}
		else
		{
			sleep(1);
			goto admins_channel;
		}
	}
	else
	{
		sleep(1);
		goto admins_channel;
	}


	// #moderation channel
	moderation_channel:
	curl_reset($ch);
	$post_content = array('token' => $GLOBALS['bot_token'], 'channel' => $GLOBALS['general_room_id'], 'topic' => $topic);
	curl_setopt($ch, CURLOPT_URL, 'https://slack.com/api/groups.setTopic');
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:'));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
	curl_setopt($ch, CURLOPT_ENCODING, '');
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_content);
	$curl_exec = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_info['http_code'] == 200)
	{
		$json_decode = json_decode($curl_exec, true);
		if($json_decode !== NULL && isset($json_decode['ok']) && $json_decode['ok'] === true)
		{
			// echo 'Updated topic for the "#moderation" channel';
		}
		else
		{
			sleep(1);
			goto moderation_channel;
		}
	}
	else
	{
		sleep(1);
		goto moderation_channel;
	}

	curl_close($ch);
}

function get_next_primary_time() {
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	$current_hour_in_day = $dateTime->format('G');
	if($current_hour_in_day >= 20)
	{
		$shift_start_hour = 0;
	}
	elseif($current_hour_in_day >= 16)
	{
		$shift_start_hour = 20;
	}
	elseif($current_hour_in_day >= 12)
	{
		$shift_start_hour = 16;
	}
	elseif($current_hour_in_day >= 8)
	{
		$shift_start_hour = 12;
	}
	elseif($current_hour_in_day >= 4)
	{
		$shift_start_hour = 8;
	}
	elseif($current_hour_in_day >= 0)
	{
		$shift_start_hour = 4;
	}
	$dateTime->setTime($shift_start_hour, 0, 0);

	$return = $dateTime->format('H');
	return $return;
}

function get_next_secondary_time() {
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	$current_hour_in_day = $dateTime->format('G');
	if($current_hour_in_day >= 22)
	{
		$shift_start_hour = 2;
	}
	elseif($current_hour_in_day >= 18)
	{
		$shift_start_hour = 22;
	}
	elseif($current_hour_in_day >= 14)
	{
		$shift_start_hour = 18;
	}
	elseif($current_hour_in_day >= 10)
	{
		$shift_start_hour = 14;
	}
	elseif($current_hour_in_day >= 6)
	{
		$shift_start_hour = 10;
	}
	elseif($current_hour_in_day >= 2)
	{
		$shift_start_hour = 6;
	}
	$dateTime->setTime($shift_start_hour, 0, 0);

	$return = $dateTime->format('H');
	return $return;
}

function get_current_pst_time() {
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));
	$return = $dateTime->format('Y-m-d H:i:s T');
	return $return;
}

function get_timezone_string() {
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));
	$return = $dateTime->format('T');
	return $return;
}

function get_next_primary_ping_time() {
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	$current_hour_in_day = $dateTime->format('G');
	if($current_hour_in_day >= 20)
	{
		$shift_start_hour = 0;
	}
	elseif($current_hour_in_day >= 16)
	{
		$shift_start_hour = 20;
	}
	elseif($current_hour_in_day >= 12)
	{
		$shift_start_hour = 16;
	}
	elseif($current_hour_in_day >= 8)
	{
		$shift_start_hour = 12;
	}
	elseif($current_hour_in_day >= 4)
	{
		$shift_start_hour = 8;
	}
	elseif($current_hour_in_day >= 0)
	{
		$shift_start_hour = 4;
	}

	if($shift_start_hour == 0)
	{
		$dateTime->setTime(23, 45, 0);
	}
	else
	{
		$dateTime->setTime(($shift_start_hour - 1), 45, 0);
	}

	$return = $dateTime->getTimestamp();
	return $return;
}

function get_next_secondary_ping_time() {
	$dateTime = new DateTime(date('c'), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	$current_hour_in_day = $dateTime->format('G');
	if($current_hour_in_day >= 22 || $current_hour_in_day < 2)
	{
		$shift_start_hour = 2;
	}
	elseif($current_hour_in_day >= 18)
	{
		$shift_start_hour = 22;
	}
	elseif($current_hour_in_day >= 14)
	{
		$shift_start_hour = 18;
	}
	elseif($current_hour_in_day >= 10)
	{
		$shift_start_hour = 14;
	}
	elseif($current_hour_in_day >= 6)
	{
		$shift_start_hour = 10;
	}
	elseif($current_hour_in_day >= 2)
	{
		$shift_start_hour = 6;
	}

	if($shift_start_hour == 2)
	{
		// Next day 1:45
		if($current_hour_in_day >= 22)
		{
			$org_timezone = date_default_timezone_get();
			date_default_timezone_set('America/Los_Angeles');
			$dateTime->setTimestamp(strtotime('tomorrow 01:45:00 am'));
			date_default_timezone_set($org_timezone);
		}
		else
		{
			// Same day
			$dateTime->setTime(($shift_start_hour - 1), 45, 0);
		}
	}
	else
	{
		$dateTime->setTime(($shift_start_hour - 1), 45, 0);
	}

	$return = $dateTime->getTimestamp();
	return $return;
}


// First check if it has all the data
if(isset($_POST['token'], $_POST['team_id'], $_POST['team_domain'], $_POST['channel_id'], $_POST['user_name'], $_POST['command'], $_POST['text']))
{
	// Check if it's the right token, team_id and channel
	if(in_array($_POST['token'], $allowed_tokens) && $_POST['team_id'] == $team_id && $_POST['channel_id'] == $admin_room_id && in_array($_POST['command'], array('/duty', '/duty2')) && !empty(trim($_POST['text'])))
	{
		$set_new_duty = false;

		$message = str_replace('	', ' ', $_POST['text']);
		$message = trim(preg_replace('/^[\pZ\pC]+|[\pZ\pC]+$/u', ' ', $message));
		$message = str_replace('?', '', utf8_decode($message));
		$message = str_replace('@', '', $message);
		$message = trim($message);

		$message_explode = explode(' ', $message);
		if(count($message_explode) == 1 && !empty($message_explode[0]))
		{
			$onDuty = $_POST['user_name'];
			$next_onDuty = $message_explode[0];
			$set_new_duty = true;
		}
		elseif(count($message_explode) == 2 && !empty($message_explode[0]) && !empty($message_explode[1]))
		{
			$onDuty = $message_explode[1];
			$next_onDuty = $message_explode[0];
			$set_new_duty = true;
		}
		else
		{
			echo 'Invalid formatting used.';
		}

		if($set_new_duty === true)
		{
			if($_POST['command'] == '/duty')
			{
				// Remove possible old reminder timings out of the DB
				$mysqli->query("DELETE FROM `reminders` WHERE `type` = 'primary-report-shift-change'");

				// Add new reminder timings to the DB
				// 15 min before
				$mysqli->query("INSERT INTO `reminders` (`type`, `channel`, `text`, `timestamp`) VALUES ('primary-report-shift-change', '".$mysqli->real_escape_string($admin_room_id)."', '".$mysqli->real_escape_string('Primary shift change shortly: @'.strtolower($next_onDuty).' will replace @'.strtolower($onDuty).' . Please confirm that you are ready to take over.')."', FROM_UNIXTIME(".get_next_primary_ping_time()."))");
				// OnChange
				$mysqli->query("INSERT INTO `reminders` (`type`, `channel`, `text`, `timestamp`) VALUES ('primary-report-shift-change', '".$mysqli->real_escape_string($admin_room_id)."', '".$mysqli->real_escape_string('Primary shift change: @'.strtolower($next_onDuty).' replaces @'.strtolower($onDuty).' . Please don\'t forget to set the next shift with /duty.')."', FROM_UNIXTIME(".(get_next_primary_ping_time() + (15 * 60) /* + 15 min */)."))");
				// 5 min after
				$mysqli->query("INSERT INTO `reminders` (`type`, `channel`, `text`, `timestamp`) VALUES ('primary-report-shift-change', '".$mysqli->real_escape_string($admin_room_id)."', '".$mysqli->real_escape_string('Hey @'.strtolower($next_onDuty).': Wake up and do your /duty! cc: @s0n0s')."', FROM_UNIXTIME(".(get_next_primary_ping_time() + (20 * 60) /* + 20 min (5 min after the shift start) */)."))");

				// Update the currents table
				$mysqli->query("UPDATE `currents` SET `current` = '".$mysqli->real_escape_string(strtolower($onDuty))."', `next` = '".$mysqli->real_escape_string(strtolower($next_onDuty))."' WHERE `type` = 'primary'");

				// Update Slack topics
				set_onDuty_topics();

				echo 'Successfully set "'.$next_onDuty.'" as next primary onDuty and "'.$onDuty.'" as current primary onDuty.';
			}
			elseif($_POST['command'] == '/duty2')
			{
				// Remove possible old reminder timings out of the DB
				$mysqli->query("DELETE FROM `reminders` WHERE `type` = 'secondary-report-shift-change'");

				// Add new reminder timings to the DB
				// 15 min before
				$mysqli->query("INSERT INTO `reminders` (`type`, `channel`, `text`, `timestamp`) VALUES ('secondary-report-shift-change', '".$mysqli->real_escape_string($admin_room_id)."', '".$mysqli->real_escape_string('Secondary shift change shortly: @'.strtolower($next_onDuty).' will replace @'.strtolower($onDuty).' . Please confirm that you are ready to take over.')."', FROM_UNIXTIME(".get_next_secondary_ping_time()."))");
				// OnChange
				$mysqli->query("INSERT INTO `reminders` (`type`, `channel`, `text`, `timestamp`) VALUES ('secondary-report-shift-change', '".$mysqli->real_escape_string($admin_room_id)."', '".$mysqli->real_escape_string('Secondary shift change: @'.strtolower($next_onDuty).' replaces @'.strtolower($onDuty))."', FROM_UNIXTIME(".(get_next_secondary_ping_time() + (15 * 60) /* + 15 min */)."))");
				// 5 min after
				$mysqli->query("INSERT INTO `reminders` (`type`, `channel`, `text`, `timestamp`) VALUES ('secondary-report-shift-change', '".$mysqli->real_escape_string($admin_room_id)."', '".$mysqli->real_escape_string('Hey @'.strtolower($next_onDuty).': Wake up and do your /duty2! cc: @s0n0s')."', FROM_UNIXTIME(".(get_next_secondary_ping_time() + (20 * 60) /* + 20 min (5 min after the shift start) */)."))");

				// Update the currents table
				$mysqli->query("UPDATE `currents` SET `current` = '".$mysqli->real_escape_string(strtolower($onDuty))."', `next` = '".$mysqli->real_escape_string(strtolower($next_onDuty))."' WHERE `type` = 'secondary'");

				// Update Slack topics
				set_onDuty_topics();

				echo 'Successfully set "'.$next_onDuty.'" as next secondary onDuty and "'.$onDuty.'" as current secondary onDuty.';
			}
		}
		unset($message, $message_explode, $onDuty, $next_onDuty);
	}
	elseif(in_array($_POST['token'], $allowed_tokens) && $_POST['team_id'] == $team_id && $_POST['channel_id'] != $admin_room_id && in_array($_POST['command'], array('/duty', '/duty2')) && !empty(trim($_POST['text'])))
	{
		// Don't allow setting duty or duty2 when the command is send from another channel than the admins channel
		echo 'This command only works in the "admins" channel.';
	}
	elseif(in_array($_POST['token'], $allowed_tokens) && $_POST['team_id'] == $team_id && in_array($_POST['command'], array('/duty', '/duty2')) && empty(trim($_POST['text'])))
	{
		// Display the current onduty / onduty2 to the user if no username was send via the command
		$db_current_onDuty = get_current_onDuty_from_DB();
		if($_POST['command'] == '/duty')
		{
			echo 'The current primary onDuty is "'.$db_current_onDuty['primary']['current'].'" and the next is "'.$db_current_onDuty['primary']['next'].'"';
		}
		elseif($_POST['command'] == '/duty2')
		{
			echo 'The current secondary onDuty is "'.$db_current_onDuty['secondary']['current'].'" and the next is "'.$db_current_onDuty['secondary']['next'].'"';
		}
	}
	elseif(in_array($_POST['token'], $allowed_tokens) && $_POST['team_id'] == $team_id && $_POST['command'] == '/time')
	{
		// Time command
		echo 'Current time: '.get_current_pst_time();
	}
	else
	{
		echo 'Unknown command.';
	}
}
else
{
	echo 'Slack didn\'t provide the info we needed!';
}

// Add log entry
if(isset($_POST) && is_array($_POST) && count($_POST) > 0)
{
	// file_put_contents(__DIR__ . '/slack_webhooks.log', json_encode(array('time' => date('c'), 'post' => $_POST)).PHP_EOL, FILE_APPEND | LOCK_EX);
}
?>