<?php
ini_set('max_execution_time', '0');
require_once __DIR__ . '/_mysql.php';
$do_db_query = true;


// Redis
$redis_key = 'twitchstats:admin_strikes_per_day_detailed';
$redis = new Redis();
$found_in_redis = false;
$redis->connect('better-desk.8rs2gm.0001.usw1.cache.amazonaws.com', 6379, 2.5);
redis_key_check:
$redis_json = $redis->get($redis_key);
if($redis_json !== false)
{
	if($redis_json == 'generating')
	{
		for($i = 0; $i < 100; $i++)
		{
			// Wait 1 second and try again
			sleep(1);
			$redis_json = $redis->get($redis_key);
			if($redis_json === false)
			{
				break;
			}
			elseif($redis_json !== false && $redis_json != 'generating')
			{
				$found_in_redis = true;
				$do_db_query = false;
				break;
			}
		}
	}
	else
	{
		$found_in_redis = true;
		$do_db_query = false;
	}
}

// $do_db_query = true;
header('Content-type: application/json');
if($do_db_query === true)
{
	if($redis->set($redis_key, 'generating', array('nx', 'ex' => 120)) !== true)
	{
		goto redis_key_check;
	}

	$db_reports_per_hour_array = array();
	// New
	$db_reports_per_hour_array[0] = array('name' => 'tos_ban_evasion', 'data' => array());
	$db_reports_per_hour_array[1] = array('name' => 'chat_ban_evasion', 'data' => array());
	$db_reports_per_hour_array[2] = array('name' => 'selfharm', 'data' => array());
	$db_reports_per_hour_array[3] = array('name' => 'harm', 'data' => array());
	$db_reports_per_hour_array[4] = array('name' => 'harassment', 'data' => array());
	$db_reports_per_hour_array[5] = array('name' => 'hate_speech', 'data' => array());
	$db_reports_per_hour_array[6] = array('name' => 'offensive_username', 'data' => array());
	$db_reports_per_hour_array[7] = array('name' => 'impersonation', 'data' => array());
	$db_reports_per_hour_array[8] = array('name' => 'spam', 'data' => array());
	$db_reports_per_hour_array[9] = array('name' => 'porn', 'data' => array());
	$db_reports_per_hour_array[10] = array('name' => 'gore', 'data' => array());
	$db_reports_per_hour_array[11] = array('name' => 'underaged', 'data' => array());
	$db_reports_per_hour_array[12] = array('name' => 'cheating', 'data' => array());
	$db_reports_per_hour_array[13] = array('name' => 'prohibited', 'data' => array());
	$db_reports_per_hour_array[14] = array('name' => 'nongaming', 'data' => array());
	$db_reports_per_hour_array[15] = array('name' => 'creative_conduct', 'data' => array());
	$db_reports_per_hour_array[16] = array('name' => 'music_conduct', 'data' => array());
	$db_reports_per_hour_array[17] = array('name' => 'bits_violation', 'data' => array());
	$db_reports_per_hour_array[18] = array('name' => 'social_eating_violation', 'data' => array());
	$db_reports_per_hour_array[19] = array('name' => 'other', 'data' => array());
	// Old
	$db_reports_per_hour_array[20] = array('name' => 'ban_evasion', 'data' => array());
	$db_reports_per_hour_array[21] = array('name' => 'ddos', 'data' => array());
	$db_reports_per_hour_array[22] = array('name' => 'staff_impersonation', 'data' => array());
	$db_reports_per_hour_array[23] = array('name' => 'overall', 'data' => array());
	
	for($i = strtotime('2016-01-01T09:00:00+02:00'); $i < time(); $i = $i + 86400)
	{
		$temp_array = array('tos_ban_evasion' => 0, 'chat_ban_evasion' => 0, 'selfharm' => 0, 'harm' => 0, 'harassment' => 0, 'hate_speech' => 0, 'offensive_username' => 0, 'impersonation' => 0, 'spam' => 0,
							'porn' => 0, 'gore' => 0, 'underaged' => 0, 'cheating' => 0, 'prohibited' => 0, 'nongaming' => 0, 'creative_conduct' => 0, 'music_conduct' => 0, 'bits_violation' => 0, 'social_eating_violation' => 0,
							'other' => 0, 'ban_evasion' => 0, 'ddos' => 0, 'staff_impersonation' => 0);
		$db_query = $mysqli->query("SELECT COUNT(*) AS `count`, `report_reason` FROM `report_mails` WHERE `report_time` >= FROM_UNIXTIME(".$i.") AND `report_time` < FROM_UNIXTIME(".($i + 86400).") AND `from_admin` = 'true' AND `is_strike` = 'true' GROUP BY `report_reason`");
		if($db_query->num_rows > 0)
		{
			while($row = $db_query->fetch_assoc())
			{
				$temp_array[strtolower($row['report_reason'])] = $row['count'];
			}
		}
		
		foreach($temp_array as $reason => $value)
		{
			if($reason == 'tos_ban_evasion')
			{
				$ID = 0;
			}
			elseif($reason == 'chat_ban_evasion')
			{
				$ID = 1;
			}
			elseif($reason == 'selfharm')
			{
				$ID = 2;
			}
			elseif($reason == 'harm')
			{
				$ID = 3;
			}
			elseif($reason == 'harassment')
			{
				$ID = 4;
			}
			elseif($reason == 'hate_speech')
			{
				$ID = 5;
			}
			elseif($reason == 'offensive_username')
			{
				$ID = 6;
			}
			elseif($reason == 'impersonation')
			{
				$ID = 7;
			}
			elseif($reason == 'spam')
			{
				$ID = 8;
			}
			elseif($reason == 'porn')
			{
				$ID = 9;
			}
			elseif($reason == 'gore')
			{
				$ID = 10;
			}
			elseif($reason == 'underaged')
			{
				$ID = 11;
			}
			elseif($reason == 'cheating')
			{
				$ID = 12;
			}
			elseif($reason == 'prohibited')
			{
				$ID = 13;
			}
			elseif($reason == 'nongaming')
			{
				$ID = 14;
			}
			elseif($reason == 'creative_conduct')
			{
				$ID = 15;
			}
			elseif($reason == 'music_conduct')
			{
				$ID = 16;
			}
			elseif($reason == 'bits_violation')
			{
				$ID = 17;
			}
			elseif($reason == 'social_eating_violation')
			{
				$ID = 18;
			}
			elseif($reason == 'other')
			{
				$ID = 19;
			}
			elseif($reason == 'ban_evasion')
			{
				$ID = 20;
			}
			elseif($reason == 'ddos')
			{
				$ID = 21;
			}
			elseif($reason == 'staff_impersonation')
			{
				$ID = 22;
			}
			else
			{
				continue;
			}
			$db_reports_per_hour_array[$ID]['data'][] = array(($i * 1000), intval($value));
		}
		
		// Add the overall count
		$overall_count = 0;
		foreach($temp_array as $reason => $value)
		{
			$overall_count = $overall_count + $value;
		}
		$db_reports_per_hour_array[23]['data'][] = array(($i * 1000), intval($overall_count));
		unset($temp_array);
	}
}

if(isset($_GET['callback'])) echo $_GET['callback'].'(';
if($do_db_query === true)
{
	$json_encode = json_encode($db_reports_per_hour_array);
	unset($db_reports_per_hour_array);
	$redis->setex($redis_key, 1800, gzcompress($json_encode));
	echo $json_encode;
}
elseif($found_in_redis === true)
{
	echo gzuncompress($redis_json);
}
if(isset($_GET['callback'])) echo ')';
?>