<?php
ini_set('max_execution_time', '0');
require_once __DIR__ . '/_mysql.php';
$do_db_query = true;


// Redis
$redis_key = 'twitchstats:desk_rate_limits';
$redis = new Redis();
$found_in_redis = false;
$redis->connect('better-desk.8rs2gm.0001.usw1.cache.amazonaws.com', 6379, 2.5);
redis_key_check:
$redis_json = $redis->get($redis_key);
if($redis_json !== false)
{
	if($redis_json == 'generating')
	{
		for($i = 0; $i < 100; $i++)
		{
			// Wait 1 second and try again
			sleep(1);
			$redis_json = $redis->get($redis_key);
			if($redis_json === false)
			{
				break;
			}
			elseif($redis_json !== false && $redis_json != 'generating')
			{
				$found_in_redis = true;
				$do_db_query = false;
				break;
			}
		}
	}
	else
	{
		$found_in_redis = true;
		$do_db_query = false;
	}
}

// $do_db_query = true;
header('Content-type: application/json');
if($do_db_query === true)
{
	if($redis->set($redis_key, 'generating', array('nx', 'ex' => 120)) !== true)
	{
		goto redis_key_check;
	}

	$db_rate_limits_array = array();
	$db_rate_limits_array[0] = array('name' => 'limit', 'data' => array());
	$db_rate_limits_array[1] = array('name' => 'used', 'data' => array());

	$temp_array = array();

	$db_query = $mysqli->query("SELECT `limit`, MIN(`remaining`) as `remaining`, FLOOR(UNIX_TIMESTAMP(`timestamp`) / 60) as `timestamps` FROM `desk_rate_limits` GROUP BY `timestamps` ORDER BY `timestamps` ASC");
	if($db_query->num_rows > 0)
	{
		while($row = $db_query->fetch_assoc())
		{
			$temp_array[$row['timestamps']] = array($row['limit'], $row['remaining']);
		}
	}
	// Free resources
	$db_query->close();

	foreach($temp_array as $timestamp => $value_array)
	{
		$db_rate_limits_array[0]['data'][] = array((intval($timestamp * 60) * 1000), intval($value_array[0]));
		$db_rate_limits_array[1]['data'][] = array((intval($timestamp * 60) * 1000), intval(intval($value_array[0]) - intval($value_array[1])));
	}
	unset($temp_array);
}

if(isset($_GET['callback'])) echo $_GET['callback'].'(';
if($do_db_query === true)
{
	$json_encode = json_encode($db_rate_limits_array);
	unset($db_rate_limits_array);
	$redis->setex($redis_key, (10 * 60), gzcompress($json_encode));
	echo $json_encode;
}
elseif($found_in_redis === true)
{
	echo gzuncompress($redis_json);
}
if(isset($_GET['callback'])) echo ')';
?>