<?php
ini_set('max_execution_time', '0');
require_once __DIR__ . '/_mysql.php';
$do_db_query = true;

function array_median($array) {
	$iCount = count($array);
	$middle_index = floor($iCount / 2);
	sort($array, SORT_NUMERIC);
	$median = $array[$middle_index]; // assume an odd # of items
	// Handle the even case by averaging the middle 2 items
	if ($iCount % 2 == 0) {
		$median = ($median + $array[$middle_index - 1]) / 2;
	}
	return round($median);
}

// Redis
$redis_key = 'twitchstats:reports_into_desk';
$redis = new Redis();
$found_in_redis = false;
$redis->connect('better-desk.8rs2gm.0001.usw1.cache.amazonaws.com', 6379, 2.5);
redis_key_check:
$redis_json = $redis->get($redis_key);
if($redis_json !== false)
{
	if($redis_json == 'generating')
	{
		for($i = 0; $i < 100; $i++)
		{
			// Wait 1 second and try again
			sleep(1);
			$redis_json = $redis->get($redis_key);
			if($redis_json === false)
			{
				break;
			}
			elseif($redis_json !== false && $redis_json != 'generating')
			{
				$found_in_redis = true;
				$do_db_query = false;
				break;
			}
		}
	}
	else
	{
		$found_in_redis = true;
		$do_db_query = false;
	}
}


header('Content-type: application/json');
if($do_db_query === true)
{
	if($redis->set($redis_key, 'generating', array('nx', 'ex' => 120)) !== true)
	{
		goto redis_key_check;
	}

	$db_mail_delay_array = array();
	$db_mail_delay_array[] = array('name' => 'min', 'yAxis' => 0, 'data' => array());
	$db_mail_delay_array[] = array('name' => 'max', 'yAxis' => 0, 'data' => array());
	$db_mail_delay_array[] = array('name' => 'avg', 'yAxis' => 0, 'data' => array());
	$db_mail_delay_array[] = array('name' => 'median', 'yAxis' => 0, 'data' => array());
	$db_mail_delay_array[] = array('name' => 'mail count', 'yAxis' => 1, 'data' => array());
	$last_mail_start_time = 0;
	
	for($i = strtotime('2015-08-20T09:00:00+02:00'); $i < time(); $i = $i + 600)
	{
		$result = $mysqli->query("SELECT `send_to_desk_create_delay` FROM `desk_email_receive_delay` WHERE `mail_send_date` >= FROM_UNIXTIME(".$i.") AND `mail_send_date` < FROM_UNIXTIME(".($i + 600).")");
		if($result->num_rows > 0)
		{
			$median_array = array();
			$db_temp_array = array();
			$db_temp_array['min'] = 1000000000;
			$db_temp_array['max'] = 0;
			$db_temp_array['mail_count'] = 0;
			$db_temp_array['delay_overall_count'] = 0;
			while($row = $result->fetch_assoc())
			{
				if($row['send_to_desk_create_delay'] < $db_temp_array['min'])
				{
					$db_temp_array['min'] = $row['send_to_desk_create_delay'];
				}
				if($row['send_to_desk_create_delay'] > $db_temp_array['max'])
				{
					$db_temp_array['max'] = $row['send_to_desk_create_delay'];
				}
				$db_temp_array['delay_overall_count'] = $db_temp_array['delay_overall_count'] + $row['send_to_desk_create_delay'];
				$db_temp_array['mail_count'] = $db_temp_array['mail_count'] + 1;
				
				$mail_time = $i;
				$last_mail_start_time = $i;
				$median_array[] = $row['send_to_desk_create_delay'];
			}
			$db_mail_delay_array[0]['data'][] = array($mail_time * 1000, intval($db_temp_array['min']));
			$db_mail_delay_array[1]['data'][] = array($mail_time * 1000, intval($db_temp_array['max']));
			$db_mail_delay_array[2]['data'][] = array($mail_time * 1000, intval(round($db_temp_array['delay_overall_count'] / $db_temp_array['mail_count'])));
			$db_mail_delay_array[3]['data'][] = array($mail_time * 1000, intval(array_median($median_array)));
			$db_mail_delay_array[4]['data'][] = array($mail_time * 1000, intval($db_temp_array['mail_count']));
		}
		else
		{
			if($last_mail_start_time !== 0)
			{
				$db_mail_delay_array[0]['data'][] = array(($last_mail_start_time + 600) * 1000, 0);
				$db_mail_delay_array[1]['data'][] = array(($last_mail_start_time + 600) * 1000, 0);
				$db_mail_delay_array[2]['data'][] = array(($last_mail_start_time + 600) * 1000, 0);
				$db_mail_delay_array[3]['data'][] = array(($last_mail_start_time + 600) * 1000, 0);
				$db_mail_delay_array[4]['data'][] = array(($last_mail_start_time + 600) * 1000, 0);
				$last_mail_start_time = $last_mail_start_time + 600;
			}
		}
		$result->free();
	}
}

if(isset($_GET['callback'])) echo $_GET['callback'].'(';
if($do_db_query === true)
{
	$json_encode = json_encode($db_mail_delay_array);
	unset($db_mail_delay_array);
	$redis->setex($redis_key, (15 * 60), gzcompress($json_encode));
	echo $json_encode;
}
elseif($found_in_redis === true)
{
	echo gzuncompress($redis_json);
}
if(isset($_GET['callback'])) echo ')';
?>