<?php
// äüö UTF8-ftw
require_once __DIR__ . '/_mysql.php';
$do_db_query = true;

// Redis
$redis_key = 'twitchstats:strikes_by_kanthes_per_week';
$redis = new Redis();
$found_in_redis = false;
$redis->connect('better-desk.8rs2gm.0001.usw1.cache.amazonaws.com', 6379, 2.5);
redis_key_check:
$redis_json = $redis->get($redis_key);
if($redis_json !== false)
{
	if($redis_json == 'generating')
	{
		for($i = 0; $i < 100; $i++)
		{
			// Wait 1 second and try again
			sleep(1);
			$redis_json = $redis->get($redis_key);
			if($redis_json === false)
			{
				break;
			}
			elseif($redis_json !== false && $redis_json != 'generating')
			{
				$found_in_redis = true;
				$do_db_query = false;
				break;
			}
		}
	}
	else
	{
		$found_in_redis = true;
		$do_db_query = false;
	}
}

if($do_db_query === true)
{
	if($redis->set($redis_key, 'generating', array('nx', 'ex' => 120)) !== true)
	{
		goto redis_key_check;
	}

	$strikes = array();
	$db_query = $mysqli->query("SELECT DATE_FORMAT(CONVERT_TZ(`report_time`,@@session.time_zone,'America/Los_Angeles'), '%Y-%u') as `report_date_week`, COUNT(*) as `strikes` FROM `report_mails` WHERE `from_user_username` = 'kanthes' AND `is_strike` = 'true' GROUP BY `report_date_week` ORDER BY `report_date_week` DESC");
	if($db_query->num_rows > 0)
	{
		while($row = $db_query->fetch_assoc())
		{
			$strikes[$row['report_date_week']] = $row['strikes'];
		}
	}
}

if($do_db_query === true)
{
	$json_encode = json_encode($strikes);
	$redis->setex($redis_key, 1800, gzcompress($json_encode));
}
elseif($found_in_redis === true)
{
	$strikes = json_decode(gzuncompress($redis_json), true);
}
?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>Strikes by Kanthes - Per Week</title>
</head>
<body>
<table border="1">
<thead>
	<tr>
		<th style="max-width:200px;width:200px;text-align:left;">Year-WeekNumber</th>
		<th style="max-width:200px;width:200px;text-align:left;">Strikes</th>
	</tr>
</thead>
<tbody>
<?php
foreach($strikes as $date => $strike_number)
{
	echo '<tr>';
	echo '<td style="max-width:200px;width:100px;text-align:left;">'.htmlspecialchars($date, ENT_QUOTES|ENT_HTML5).'</td>';
	echo '<td style="max-width:200px;width:200px;text-align:left;">'.htmlspecialchars($strike_number, ENT_QUOTES|ENT_HTML5).'</td>';
	echo '</tr>'.PHP_EOL;
}
?>
</tbody>
</table>
<br>
</body>
</html>