<?php
ini_set('max_execution_time', '0');
require_once __DIR__ . '/_mysql.php';
$do_db_query = true;


// Redis
$redis_key = 'twitchstats:whisper_reports_per_day_detailed';
$redis = new Redis();
$found_in_redis = false;
$redis->connect('better-desk.8rs2gm.0001.usw1.cache.amazonaws.com', 6379, 2.5);
redis_key_check:
$redis_json = $redis->get($redis_key);
if($redis_json !== false)
{
	if($redis_json == 'generating')
	{
		for($i = 0; $i < 100; $i++)
		{
			// Wait 1 second and try again
			sleep(1);
			$redis_json = $redis->get($redis_key);
			if($redis_json === false)
			{
				break;
			}
			elseif($redis_json !== false && $redis_json != 'generating')
			{
				$found_in_redis = true;
				$do_db_query = false;
				break;
			}
		}
	}
	else
	{
		$found_in_redis = true;
		$do_db_query = false;
	}
}

// $do_db_query = true;
header('Content-type: application/json');
if($do_db_query === true)
{
	if($redis->set($redis_key, 'generating', array('nx', 'ex' => 120)) !== true)
	{
		goto redis_key_check;
	}

	$db_reports_per_hour_array = array();
	// Reasons
	$db_reports_per_hour_array[0] = array('name' => 'harassment', 'data' => array());
	$db_reports_per_hour_array[1] = array('name' => 'spam', 'data' => array());
	$db_reports_per_hour_array[2] = array('name' => 'overall', 'data' => array());
	
	for($i = strtotime('2015-12-15T09:00:00+02:00'); $i < time(); $i = $i + 86400)
	{
		$temp_array = array('harassment' => 0, 'spam' => 0);
		$db_query = $mysqli->query("SELECT COUNT(*) AS `count`, `report_reason` FROM `whisper_reports` WHERE `report_time` >= FROM_UNIXTIME(".$i.") AND `report_time` < FROM_UNIXTIME(".($i + 86400).") GROUP BY `report_reason`");
		if($db_query->num_rows > 0)
		{
			while($row = $db_query->fetch_assoc())
			{
				$temp_array[strtolower($row['report_reason'])] = $row['count'];
			}
		}
		
		foreach($temp_array as $reason => $value)
		{
			if($reason == 'harassment')
			{
				$ID = 0;
			}
			elseif($reason == 'spam')
			{
				$ID = 1;
			}
			else
			{
				continue;
			}
			$db_reports_per_hour_array[$ID]['data'][] = array(($i * 1000), intval($value));
		}
		
		// Add the overall count
		$overall_count = 0;
		foreach($temp_array as $reason => $value)
		{
			$overall_count = $overall_count + $value;
		}
		$db_reports_per_hour_array[2]['data'][] = array(($i * 1000), intval($overall_count));
		unset($temp_array);
	}
}

if(isset($_GET['callback'])) echo $_GET['callback'].'(';
if($do_db_query === true)
{
	$json_encode = json_encode($db_reports_per_hour_array);
	unset($db_reports_per_hour_array);
	$redis->setex($redis_key, 1800, gzcompress($json_encode));
	echo $json_encode;
}
elseif($found_in_redis === true)
{
	echo gzuncompress($redis_json);
}
if(isset($_GET['callback'])) echo ')';
?>