<?php
// üöä UFT8-FTW
function apply_curl_defaults(&$ch)
{
	curl_reset($ch);
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:'));
	curl_setopt($ch, CURLOPT_ENCODING, '');
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($ch, CURLOPT_AUTOREFERER, false);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36');
	// SSL stuff
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
	curl_setopt($ch, CURLOPT_CAINFO, __DIR__ . '/cacert.pem');
	curl_setopt($ch, CURLOPT_CAPATH, __DIR__);
	curl_setopt($ch, CURLOPT_HEADER, true);
}

// HEAD request to just get the response code of the first request (mainly used for clips embed check)
if(isset($_GET['url']) && isset($_GET['js_head_check']) && $_GET['js_head_check'] == 'true' && !empty($_GET['url']))
{
	$ch = curl_init();
	apply_curl_defaults($ch);
	curl_setopt($ch, CURLOPT_URL, $_GET['url']);
	curl_setopt($ch, CURLOPT_NOBODY, true);
	$curl_output = curl_exec($ch);
	$curl_info = curl_getinfo($ch);
	if($curl_info['http_code'] == 0)
	{
		$curl_info['http_code'] = 504;
	}

	header('X-Status: '.$curl_info['http_code'], true, $curl_info['http_code']);
	exit();
}

if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['url']) && !empty($_POST['url']))
{
	$max_steps = 20;
	$current_step = 1;
	$end_found = false;
	$url_array = array();
	$request_url = $_POST['url'];

	$ch = curl_init();
	while($end_found === false && $current_step <= $max_steps)
	{
		apply_curl_defaults($ch);
		curl_setopt($ch, CURLOPT_URL, $request_url);
		$curl_output = curl_exec($ch);
		$curl_info = curl_getinfo($ch);
		if(!empty($curl_info['redirect_url']))
		{
			// It's a redirect
			$request_url = $curl_info['redirect_url'];
		}
		else
		{
			// Something else
			$end_found = true;
		}

		// Fill the array witht the info from the current request
		$url_array[] = array('http_code' => $curl_info['http_code'], 'url' => $curl_info['url'], 'redirect_url' => $curl_info['redirect_url']);

		// Unset the data so we have more space for the next url
		unset($curl_output, $curl_info);

		// Increase the step counter
		$current_step++;
	}
}


?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>URL Resolver</title>
</head>
<body>
<div>
<?php if(isset($error) && $error === true) echo '<h2><b>'.$error_msg.'</b></h2>'.PHP_EOL; ?>
</div>
<form action="" method="POST">
<div>
<label for="url">URL: </label>
<input id="url" name="url" type="text" value="" size="50" required>
</div>
<div>
<input type="submit" value="Check">
</div>
</form>
<div>
<?php
if(isset($url_array) && count($url_array) > 0)
{
	echo '<br><b>Results:</b><br>'.PHP_EOL;
	foreach($url_array as $step => $info)
	{
		echo ($step + 1).'. '.htmlspecialchars('"'.$info['url'].'"', ENT_QUOTES|ENT_HTML5).' ('.$info['http_code'].')';
		if(!empty($info['redirect_url']))
		{
			echo htmlspecialchars(' => "'.$info['redirect_url'].'"', ENT_QUOTES|ENT_HTML5);
		}
		echo '<br>'.PHP_EOL;
	}
}
?>
</div>
<br><br>
</body>
</html>