<?php
// ÜÖÄ UTF8-FTW
ignore_user_abort(false);
$script_start_time = microtime(true);

require_once __DIR__ . '/RedisSessionHandler.php';
$sessHandler = new RedisSessionHandler(null, null, null, null, true);
session_set_save_handler($sessHandler);
session_start();
// We don't change anything in the session so we can close writes here
@session_write_close();

// header('Cache-Control: no-store, no-cache, must-revalidate');
// header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
// header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
// header('Pragma: no-cache');

function time_to_pst_time($time)
{
	$dateTime = new DateTime(date('c', strtotime($time)), new DateTimeZone(date_default_timezone_get()));
	$dateTime->setTimezone(new DateTimeZone('America/Los_Angeles'));

	$return = $dateTime->format('r (T)');
	return $return;
}

function sec_to_nice_time($seconds, $skip_sec = false)
{
	$days = floor($seconds/60/60/24);
	$hours = floor(($seconds/60/60)%24);
	$min = floor(($seconds/60)%60);
	$sec = floor($seconds%60);
	
	$string = '';
	$started = false;
	if($days > 0)
	{
		$string .= '<b>'.$days.'d</b> ';
		$started = true;
	}
	
	if($hours > 0 || $started == true)
	{
		$string .= $hours.'h ';
		$started = true;
	}
	
	if($min > 0 || $started == true)
	{
		$string .= $min.'m ';
		$started = true;
	}
	
	if(($sec > 0 || $started == true) && $skip_sec == false)
	{
		$string .= $sec.'s';
	}
	
	return $string; 
}

function mysql_escape_mimic($inp)
{
	if(is_array($inp)) return array_map(__METHOD__, $inp);

	if(!empty($inp) && is_string($inp))
	{
		return str_replace(array('\\', "\0", "\n", "\r", "'", '"', "\x1a"), array('\\\\', '\\0', '\\n', '\\r', "\\'", '\\"', '\\Z'), $inp);
	}

	return $inp;
} 

function array_to_sql_string($array)
{
	if(count($array) > 0)
	{
		$return = '';
		foreach($array as $part)
		{
			$return .= ",'".mysql_escape_mimic($part)."'";
		}
		return substr($return, 1);
	}
	else
	{
		return "''";
	}
}

if(isset($_SESSION['auth']) && !empty($_SESSION['auth']) && $_SESSION['auth'] === true)
{
	// mysql connection
	$mysqli = @new mysqli('betterdesk-mysql.cunim1xnmwzu.us-west-1.rds.amazonaws.com', 'twitch_reports_read', '5pcNl7VZ4hrP9s8N', 'twitch_reports');
	if($mysqli->connect_errno)
	{
		echo 'Whisper history DB is currently not available.';
		// echo 'Connection to database failed: '.$mysqli->connect_error;
		exit();
	}
	// Set charset of the connection to uf8mb4
	$mysqli->set_charset('utf8mb4');
	
	if(isset($_POST['list']) && !empty($_POST['list']) && isset($_POST['reporter']) && !empty($_POST['reporter']))
	{
		$list = str_replace(array('	', ' '), ' ', $_POST['list']);
		$list_explode = explode("\n", $list);
		// remove spaces at the start and end of each line and remove blank lines
		foreach($list_explode as $key => $part)
		{
			$part = trim($part);
			$list_explode[$key] = $part;
			if(empty($part))
			{
				unset($list_explode[$key]);
			}
		}
		$list_explode = array_unique($list_explode);
		
		// Remove possible user match and banned info
		$not_lookup_user_array = array('xanbot', 'nightbot', 'moobot', 'ackbot', 'login');
		$list_list_explode = array();
		foreach($list_explode as $part)
		{
			$part_exploded = explode(' ', $part);
			// If it ends with View the it's for sure an AA lookup
			if(count($part_exploded) >= 2 && substr($part, -4) == 'View')
			{
				$part_username = $part_exploded[2];
			}
			elseif(is_numeric($part_exploded[0]) && isset($part_exploded[2]) && !empty($part_exploded[2]))
			{
				// Still AA lookup
				$part_username = $part_exploded[2];
			}
			else
			{
				// Normal list or Alt Lookup room
				$part_username = $part_exploded[0];
			}
			if(!in_array(strtolower($part_username), $not_lookup_user_array))
			{
				$list_list_explode[] = $part_username;
			}
		}
		$user_array = array_unique($list_list_explode);
		unset($list_explode, $list_list_explode);
		
		$error = false;
		if(count($user_array) > 2500)
		{
			$error = true;
			$error_msg = 'You can only check up to 2500 user at once!'.PHP_EOL;
		}
		elseif(count($user_array) > 0)
		{
			// Produce query
			$query_string = "SELECT `desk_caseID`, `target_user_username` FROM `whisper_reports` WHERE `from_user_username` = '".mysql_escape_mimic($_POST['reporter'])."' AND `target_user_username` IN (".array_to_sql_string($user_array).") AND `report_time` >= FROM_UNIXTIME('".(time() - (48 * 60 * 60))."') ORDER BY `target_user_username` ASC, `desk_caseID` ASC";
			// echo $query_string.PHP_EOL;
			// exit();
			
			if($result = $mysqli->query($query_string))
			{
				$active_account_array = array();
				while($row = $result->fetch_assoc())
				{
					$target_user_username_string = $row['target_user_username'].'     ';
					$active_account_array_count = count($active_account_array);
					if($active_account_array_count > 0 && substr($active_account_array[($active_account_array_count - 1)], 0, strlen($target_user_username_string)) == $target_user_username_string)
					{
						// Add case ID to last string
						$active_account_array[($active_account_array_count - 1)] .= ','.$row['desk_caseID'];
					}
					else
					{
						// Create new entry
						$active_account_array[] = $target_user_username_string.$row['desk_caseID'];
					}
				}
				$result->free();
			}
		}
	}


?><!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>Whisper report history checker</title>
</head>
<body>
<h2>Check if multiple alts have been reported by a user</h2><br>
<form id="form" action="" method="post">
<table>
<tr>
	<td>
		Reporter: <input type="text" name="reporter" size="35" placeholder="username" value="<?php if(isset($_POST['reporter']) && !empty($_POST['reporter'])) echo htmlspecialchars($_POST['reporter'], ENT_QUOTES); ?>" required>
	</td>
</tr>
<tr>
	<td>
		<div align="center">Userlist (2000 max):</div>
	</td>
	<?php
	if(isset($_POST['list']) && !empty($_POST['list']))
	{
		?>
	<td>
		<div align="center">List of names that got used for lookup:</div>
	</td>
		<?php
	}
	?>
</tr>
<tr>
	<td>
		<textarea name="list" id="list" cols="60" rows="15" required><?php if(isset($_POST['list']) && !empty($_POST['list'])) echo htmlspecialchars($_POST['list'], ENT_QUOTES); ?></textarea>
	</td>
	<?php
	if(isset($_POST['list']) && !empty($_POST['list']))
	{
		?>
	<td>
		<textarea name="used_list" id="used_list" cols="30" rows="15" readonly><?php 
		if(isset($user_array) && count($user_array) > 0)
		{
			foreach($user_array as $user)
			{ 
				echo htmlspecialchars($user, ENT_QUOTES).PHP_EOL;
			}
		} ?></textarea>
	</td>
		<?php
	}
	?>
</tr>
<tr>
	<td>
		<br>
		<input type="Submit" name="check" value="Check" />
	</td>
</tr>
</table>
</form>
<?php
if(isset($error) && $error === true)
{
	echo '<h2><b>'.$error_msg.'</b></h2>'.PHP_EOL;
}
if(isset($active_account_array))
{
?>
<br>
<table>
<tr>
	<td>
		<div align="center">Accounts that are in the userlist and have been reported by the reporter in the last 48 hours:</div>
	</td>
</tr>
<tr>
	<td>
		<textarea name="active_accounts" id="active_accounts" cols="60" rows="15"><?php
if(count($active_account_array) > 0)
{
	foreach($active_account_array as $part)
	{
		echo htmlspecialchars($part, ENT_QUOTES).PHP_EOL;
	}
}
else
{
	echo 'No user from the list has been reported by the reporter in the last 48 hours!';
}
?></textarea>
	</td>
</tr>
</table>
<?php
}
?>
<br>
Total request time: <strong><?php echo round(microtime(true) - $script_start_time, 4); ?> sec</strong>
</body>
</html>
<?php
}
else
{
	echo 'Authentication failed!<br>'.PHP_EOL;
	echo 'Please <a href="index.php?login_redirect=whisper_report_history">login</a><br><hr>'.PHP_EOL;
}
?>