<?php
// üöä-UTF8 FTW
ini_set('max_execution_time', '0');
$report_api_token = 'JciEQf0Z-8G764yQVhhImgxjPsLStxvA';
$suspension_api_token = 'htP1jGagBYj2lGyQZ_q2uzd0gDe-T1HS';

function report_reason_sanitize($reason)
{
	static $valid_reasons = array('other','spam','porn','harassment','nongaming','hate_speech','cheating','ban_evasion','selfharm','offensive_username','ddos','impersonation','harm','underaged','chat_ban_evasion','staff_impersonation','prohibited','sexual','gore','music_conduct','tos_ban_evasion','creative_conduct','suggestive','violence','social_eating_violation','bits_violation');
	if(in_array($reason, $valid_reasons))
	{
		return $reason;
	}
	else
	{
		return 'other';
	}
}

function parse_ban_duration($description)
{
	if(($pos = strpos($description, '----------------------------------------')) !== false)
	{
		if(strpos(substr($description, 0, $pos), 'Suspension: temporary') !== false)
		{
			return "86400";
		}
		else
		{
			return "-1";
		}
	}
	else
	{	
		return "-1";
	}
}

function parse_ip_ban($description)
{
	if(($pos = strpos($description, '----------------------------------------')) !== false)
	{
		if(strpos(substr($description, 0, $pos), 'IP Block: false') !== false)
		{
			return "0";
		}
		elseif(strpos(substr($description, 0, $pos), 'IP Block: true') !== false)
		{
			if(strpos(substr($description, 0, $pos), 'Suspension: temporary') !== false)
			{
				return "86400";
			}
			else
			{
				return "-1";
			}
		}
		else
		{
			return "-1";
		}
	}
	else
	{	
		return "-1";
	}	
}

function parse_cleared_images($description)
{
	if(($pos = strpos($description, '----------------------------------------')) !== false)
	{
		if(strpos(substr($description, 0, $pos), 'Cleared Images: true') !== false)
		{
			return "1";
		}
		else
		{
			return "0";
		}
	}
	else
	{	
		return "0";
	}
}

function apply_curl_defaults(&$ch)
{
	// curl_reset($ch);
	curl_setopt($ch, CURLOPT_TIMEOUT, 15);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
	curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:'));
	curl_setopt($ch, CURLOPT_ENCODING, '');
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Better Desk by commanderroot@twitch.tv');
	// SSL stuff
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
}

function do_leviathan_report_request($post_array)
{
	curl_setopt($GLOBALS['ch'], CURLOPT_URL, 'https://leviathan.moderation.twitch.tv/reports');
	curl_setopt($GLOBALS['ch'], CURLOPT_POST, true);
	curl_setopt($GLOBALS['ch'], CURLOPT_POSTFIELDS, $post_array);

	$try = 0;
	before_request:
	$curl_output = curl_exec($GLOBALS['ch']);
	$curl_info = curl_getinfo($GLOBALS['ch']);
	if($curl_info['http_code'] != 200)
	{
		echo PHP_EOL;
		print_r($curl_info);
		echo PHP_EOL;
		echo $curl_output.PHP_EOL;
		$try = $try + 1;
		if($try >= 3)
		{
			// Log as failed request
			log_failed_request('https://leviathan.moderation.twitch.tv/reports', $post_array);
			return;
		}
		sleep(3 * $try);
		// Retry
		goto before_request;
	}
}

function do_leviathan_suspension_request($post_array)
{
	curl_setopt($GLOBALS['ch'], CURLOPT_URL, 'https://leviathan.moderation.twitch.tv/suspensions');
	curl_setopt($GLOBALS['ch'], CURLOPT_POST, true);
	curl_setopt($GLOBALS['ch'], CURLOPT_POSTFIELDS, $post_array);

	$try = 0;
	before_request:
	$curl_output = curl_exec($GLOBALS['ch']);
	$curl_info = curl_getinfo($GLOBALS['ch']);
	if($curl_info['http_code'] != 200)
	{
		echo PHP_EOL;
		print_r($curl_info);
		echo PHP_EOL;
		echo $curl_output.PHP_EOL;
		$try = $try + 1;
		if($try >= 3)
		{
			// Log as failed request
			log_failed_request('https://leviathan.moderation.twitch.tv/suspensions', $post_array);
			return;
		}
		sleep(3 * $try);
		// Retry
		goto before_request;
	}
}

function log_failed_request($url, $post_array)
{
	file_put_contents(__DIR__ . DIRECTORY_SEPARATOR . 'failed_requests.log', json_encode(array('url' => $url, 'body' => $post_array)).PHP_EOL, FILE_APPEND);
}

$mysqli = new mysqli('betterdesk-mysql.cunim1xnmwzu.us-west-1.rds.amazonaws.com', 'twitch_reports_write', 'QjghE4wuAN8CP55g', 'twitch_reports');
if($mysqli->connect_errno)
{
	// echo 'Report DB is currently not available.';
	echo 'Connection to database failed: '.$mysqli->connect_error;
	exit();
}
if(!$mysqli->set_charset('utf8mb4')) {
	printf("Error loading character set utf8mb4: %s\n", $mysqli->error);
	exit();
} else {
	printf("Current character set: %s\n", $mysqli->character_set_name());
}

$ch = curl_init();
apply_curl_defaults($ch);



echo 'Starting reports / strikes ...'.PHP_EOL;
$last_report_mails_query = $mysqli->query("SELECT `last_added_id` FROM `status` WHERE `ID` = '7' ");
if($last_report_mails_query->num_rows > 0)
{
	while($row = $last_report_mails_query->fetch_assoc())
	{
		$last_report_mails_ID = $row['last_added_id'];
	}
	$last_report_mails_query->close();
}
else
{
	echo 'Couldn\'t get last id for report_mails from DB'.PHP_EOL;
	exit();
}

// Select data in chunks of 100
$found_data = false;
do
{
	$report_query = $mysqli->query("SELECT *, UNIX_TIMESTAMP(`report_time`) as `report_time_s` FROM `report_mails` WHERE `ID` > '".$mysqli->real_escape_string($last_report_mails_ID)."' ORDER BY `ID` ASC LIMIT 100");
	if($report_query->num_rows > 0)
	{
		while($row = $report_query->fetch_assoc())
		{
			echo $row['ID'];
			// Update the last ID var
			$last_report_mails_ID = $row['ID'];

			if(!empty($row['is_strike']) && $row['is_strike'] == 'true')
			{
				$post_array = array();
				$post_array['authorisation_token'] = $suspension_api_token;
				$post_array['suspension[content]'] = $row['content'];
				$post_array['suspension[from_user_id]'] = $row['from_user_ID'];
				$post_array['suspension[target_user_username]'] = $row['target_user'];
				$post_array['suspension[reason]'] = report_reason_sanitize($row['report_reason']);
				$post_array['suspension[detailed_reason]'] = $row['report_reason_detailed'];
				$post_array['suspension[description]'] = $row['report_description'];
				$post_array['suspension[duration]'] = parse_ban_duration($row['report_description']);
				$post_array['suspension[ip_ban]'] = parse_ip_ban($row['report_description']);
				$post_array['suspension[cleared_channel_images]'] = parse_cleared_images($row['report_description']);
				$post_array['suspension[origin]'] = 'desk_forward';

				do_leviathan_suspension_request($post_array);
				unset($post_array);
			}
			else
			{
				$post_array = array();
				$post_array['authorisation_token'] = $report_api_token;
				$post_array['report[content]'] = 'user_report';
				if($row['from_user_ID'] > 0)
				{
					$post_array['report[from_user_id]'] = $row['from_user_ID'];
				}
				$post_array['report[target_user_username]'] = $row['target_user'];
				$post_array['report[reason]'] = report_reason_sanitize($row['report_reason']);
				$post_array['report[description]'] = $row['report_description'];
				$post_array['report[origin]'] = 'desk_forward';
				
				do_leviathan_report_request($post_array);
				unset($post_array);
			}			
			echo '. ';
		}
		$found_data = true;
	}
	else
	{
		$found_data = false;
	}
	$report_query->close();

	// Update the DB entry (just to "quick" save)
	$mysqli->query("UPDATE `status` SET `last_added_id` = '".$mysqli->real_escape_string($last_report_mails_ID)."' WHERE `ID` = '7' ");
} while ($found_data === true);
// ------------------------------------------------------------------------------------------------------------------------------------------------------


echo PHP_EOL.PHP_EOL.'Starting channel_feed_reports ...'.PHP_EOL;
$last_channel_feed_reports_query = $mysqli->query("SELECT `last_added_id` FROM `status` WHERE `ID` = '8' ");
if($last_channel_feed_reports_query->num_rows > 0)
{
	while($row = $last_channel_feed_reports_query->fetch_assoc())
	{
		$last_channel_feed_reports_ID = $row['last_added_id'];
	}
	$last_channel_feed_reports_query->close();
}
else
{
	echo 'Couldn\'t get last id for channel_feed_reports from DB'.PHP_EOL;
	exit();
}

// Select data in chunks of 100
$found_data = false;
do
{
	$report_query = $mysqli->query("SELECT *, UNIX_TIMESTAMP(`report_time`) as `report_time_s` FROM `channel_feed_reports` WHERE `ID` > '".$mysqli->real_escape_string($last_channel_feed_reports_ID)."' ORDER BY `ID` ASC LIMIT 100");
	if($report_query->num_rows > 0)
	{
		while($row = $report_query->fetch_assoc())
		{
			echo $row['ID'];
			// Update the last ID var
			$last_channel_feed_reports_ID = $row['ID'];

			if($row['type'] == 'channel_feed_post')
			{
				$post_array = array();
				$post_array['authorisation_token'] = $report_api_token;
				$post_array['report[content]'] = 'channel_feed_post_report';
				$post_array['report[content_id]'] = $row['post_ID'];
				$post_array['report[from_user_id]'] = $row['from_user_ID'];
				$post_array['report[target_user_id]'] = $row['target_user_ID'];
				$post_array['report[reason]'] = report_reason_sanitize($row['report_reason']);
				$post_array['report[description]'] = $row['post_content'];
				$post_array['report[origin]'] = 'desk_forward';
				
				do_leviathan_report_request($post_array);
				unset($post_array);
			}
			elseif($row['type'] == 'channel_feed_comment')
			{
				$post_array = array();
				$post_array['authorisation_token'] = $report_api_token;
				$post_array['report[content]'] = 'channel_feed_comment_report';
				$post_array['report[content_id]'] = explode('/', $row['post_ID'], 2)[1];
				$post_array['report[from_user_id]'] = $row['from_user_ID'];
				$post_array['report[target_user_id]'] = $row['target_user_ID'];
				$post_array['report[reason]'] = report_reason_sanitize($row['report_reason']);
				$post_array['report[description]'] = $row['post_content'];
				$post_array['report[extra1]'] = $row['feed_owner_user_ID'];
				$post_array['report[origin]'] = 'desk_forward';
				
				do_leviathan_report_request($post_array);
				unset($post_array);
			}
			echo '. ';
		}
		$found_data = true;
	}
	else
	{
		$found_data = false;
	}
	$report_query->close();

	// Update the DB entry (just to "quick" save)
	$mysqli->query("UPDATE `status` SET `last_added_id` = '".$mysqli->real_escape_string($last_channel_feed_reports_ID)."' WHERE `ID` = '8' ");
} while ($found_data === true);
// ------------------------------------------------------------------------------------------------------------------------------------------------------


echo PHP_EOL.PHP_EOL.'Starting clip_reports ...'.PHP_EOL;
$last_clip_reports_query = $mysqli->query("SELECT `last_added_id` FROM `status` WHERE `ID` = '9' ");
if($last_clip_reports_query->num_rows > 0)
{
	while($row = $last_clip_reports_query->fetch_assoc())
	{
		$last_clip_reports_ID = $row['last_added_id'];
	}
	$last_clip_reports_query->close();
}
else
{
	echo 'Couldn\'t get last id for clip_reports from DB'.PHP_EOL;
	exit();
}

// Select data in chunks of 100
$found_data = false;
do
{
	$report_query = $mysqli->query("SELECT *, UNIX_TIMESTAMP(`report_time`) as `report_time_s` FROM `clip_reports` WHERE `ID` > '".$mysqli->real_escape_string($last_clip_reports_ID)."' ORDER BY `ID` ASC LIMIT 100");
	if($report_query->num_rows > 0)
	{
		while($row = $report_query->fetch_assoc())
		{
			echo $row['ID'];
			// Update the last ID var
			$last_clip_reports_ID = $row['ID'];

			$post_array = array();
			$post_array['authorisation_token'] = $report_api_token;
			$post_array['report[content]'] = 'clip_report';
			$post_array['report[content_id]'] = $row['target_user_username'].'/'.$row['clip_emotestring'];
			$post_array['report[from_user_id]'] = $row['from_user_ID'];
			$post_array['report[target_user_username]'] = $row['target_user_username'];
			$post_array['report[reason]'] = report_reason_sanitize($row['report_reason']);
			$post_array['report[description]'] = $row['report_description'];
			$post_array['report[origin]'] = 'desk_forward';
			
			do_leviathan_report_request($post_array);
			unset($post_array);
			echo '. ';
		}
		$found_data = true;
	}
	else
	{
		$found_data = false;
	}
	$report_query->close();

	// Update the DB entry (just to "quick" save)
	$mysqli->query("UPDATE `status` SET `last_added_id` = '".$mysqli->real_escape_string($last_clip_reports_ID)."' WHERE `ID` = '9' ");
} while ($found_data === true);
// ------------------------------------------------------------------------------------------------------------------------------------------------------


echo PHP_EOL.PHP_EOL.'Starting whisper_reports ...'.PHP_EOL;
$last_whisper_reports_query = $mysqli->query("SELECT `last_added_id` FROM `status` WHERE `ID` = '10' ");
if($last_whisper_reports_query->num_rows > 0)
{
	while($row = $last_whisper_reports_query->fetch_assoc())
	{
		$last_whisper_reports_ID = $row['last_added_id'];
	}
	$last_whisper_reports_query->close();
}
else
{
	echo 'Couldn\'t get last id for whisper_reports from DB'.PHP_EOL;
	exit();
}

// Select data in chunks of 100
$found_data = false;
do
{
	$report_query = $mysqli->query("SELECT *, UNIX_TIMESTAMP(`report_time`) as `report_time_s` FROM `whisper_reports` WHERE `ID` > '".$mysqli->real_escape_string($last_whisper_reports_ID)."' ORDER BY `ID` ASC LIMIT 100");
	if($report_query->num_rows > 0)
	{
		while($row = $report_query->fetch_assoc())
		{
			echo $row['ID'];
			// Update the last ID var
			$last_whisper_reports_ID = $row['ID'];

			$post_array = array();
			$post_array['authorisation_token'] = $report_api_token;
			$post_array['report[content]'] = 'whisper_report';
			$post_array['report[from_user_id]'] = $row['from_user_ID'];
			$post_array['report[target_user_id]'] = $row['target_user_ID'];
			$post_array['report[reason]'] = report_reason_sanitize($row['report_reason']);
			$post_array['report[description]'] = $row['recent_messages'];
			$post_array['report[origin]'] = 'desk_forward';
			
			do_leviathan_report_request($post_array);
			unset($post_array);
			echo '. ';
		}
		$found_data = true;
	}
	else
	{
		$found_data = false;
	}
	$report_query->close();

	// Update the DB entry (just to "quick" save)
	$mysqli->query("UPDATE `status` SET `last_added_id` = '".$mysqli->real_escape_string($last_whisper_reports_ID)."' WHERE `ID` = '10' ");
} while ($found_data === true);
// ------------------------------------------------------------------------------------------------------------------------------------------------------

echo PHP_EOL.'Done!'.PHP_EOL;

